<?php
/* @var $this ConfigController */
$this->registerSpxScript( 'basemodel.js' );

$this->sidebar = $this->widget('zii.widgets.CMenu', array(
    'items' => $this->pages,
    'htmlOptions' => array( 'class' => "cl-vnavigation" ),
    'submenuHtmlOptions' => array( 'class' => "sub-menu" ),
    'itemCssClass' => "",
    'activateParents' => false,
    'activeCssClass' => 'active'
), true);

if ( Tools::doShutdown() )
    Tools::shutdown();

$this->beginContent('//layouts/menu');

$config = array(
    'bootId' => Tools::getBootID(),   
    'urlReboot' => CHtml::normalizeUrl( array("/controlcenter/operation/reboot", 'reboot'=>true, ) ),
    'bootNow' => Tools::checkReboot(),
    'instalMode' => Tools::checkInstallationmode(),
    'pendingChangeList' => Tools::getPendingChangeList(),
    'addMessages' => Tools::getMessages(),
    'csrfTokenName' => Yii::app()->request->csrfTokenName,
    'csrfToken' =>
        "js:'" . CJavaScript::quote(Yii::app()->request->csrfToken) . "'"
); 

echo CHtml::script( $this->localScript )."\n";       
echo CHtml::script( "function extendModel( yiiModel, yiiErrors ){ return extendModelExt( yiiModel, yiiErrors, ".CJavaScript::encode( $config )."  ); };" )."\n";
echo $content;
echo Chtml::tag("div", array( 'id' => 'FillerSpace'), "");
?>

<script type="text/javascript" >
//<![CDATA[
if ( !yiiErrors ) {
    var yiiErrors =  [];
}
extendModel( yiiModel, yiiErrors );

ko.applyBindings( yiiModel );

$(function(){
    var pos;
    var timeoutID = null; 
    function updateActive( ){
        
        var foundTop = false;
        $(".cl-vnavigation li.active ul li").each(function(){
            var href = $('a',this).attr('href');
            if ( href ) {
                var frag = href.indexOf('#');
                if ( frag>=0 ){
                    var fragment = href.substr( frag );
                    var top = $(fragment).offset().top;
                    if ( !foundTop && pos < top ){
                        foundTop = true;
                        $(this).addClass('active');
                        yiiModel.activeFragment = fragment;
                    } else {
                        $(this).removeClass('active');
                    }
                }
            }
        });
    }
    
    $(window).scroll(function() {
         
         pos = $(this).scrollTop();
         if ( !timeoutID ){
             timeoutID = setTimeout( function() { 
                 timeoutID = null; 
                 updateActive( pos ); 
             }, 500);    
         }
     });
     
    function goToHashByScroll( ){
        var hash = window.location.hash;
        if ( !hash || hash === "#" ){
            if ( window.location.search && window.location.search.substr(1,3) == "id=" ){
                var end = window.location.search.indexOf("&");
                if ( end >0 ){
                    hash = "#"+window.location.search.substr(4, end-4);
                } else {
                    hash = "#"+window.location.search.substr(4);
                }
            }
        }
        if ( hash && hash !== "#" ){
            $('html,body').animate( { scrollTop: $(hash).offset().top-40 },'slow');

            $(".cl-vnavigation li.active ul li").each(function(){
                var href = $('a',this).attr('href');
                if ( href ){
                    var pos = href.indexOf('#');
                    if ( pos>=0 ){
                        var fragment = href.substr( href.indexOf('#') );
                        if ( fragment == hash ){
                            $(this).addClass('active');
                            yiiModel.activeFragment = fragment;
                        } else {
                            $(this).removeClass('active');
                        }
                    }
                }
            });

        }        
        // fix the active menu

    }
    $(goToHashByScroll);
    if ("onhashchange" in window) {
        window.onhashchange = goToHashByScroll;
    } else {
        $(window).bind( 'hashchange', goToHashByScroll);
    }
    $('#FillerSpace').height( $(window).height() - 260 );
    
});

//]]></script>

<?php 
$timeout = Yii::app()->user->getState(CWebUser::AUTH_ABSOLUTE_TIMEOUT_VAR);
if ($timeout !== null) {
    $timeout = max($timeout - time(), 55);
} else {
    $timeout = -1;
}
?> 

<script>
const TIMEOUT = <?php echo $timeout?> * 1000;
if (TIMEOUT >= 0) {
    setTimeout(function() {location.replace("/user/logout");}, TIMEOUT);
}
</script>

<?php
$this->endContent();