<?php
class CredentialsConfig extends CFormModel {
	
    static $file="/etc/raperca/spxpasswd.xml";
    static $setPasswords = "**********";
    var $credits = array();
    
    public function rules() {
		$res = array(
    	);
        return $res;
	}
    public function attributeLabels()
	{
		return array(
            'title'=>'Network Credentials',
            'desc'=>'Use the table below to defined usernames and passwords. Optionally you can specify different usernames and passwords depending on the realm returned by the server. ',
		);
	}
    
    function addCreditential( $credit ) {
        $this->credits[] = $credit;
    }
    function getCredits( $hosts ) {
        $xlinkNS = 'http://www.w3.org/1999/xlink';
        $credits = array();
        $idx = 0;
        foreach ($hosts as $host){
            $server = new Credentials;
            $server->hrefConfig=$host->getAttributeNS($xlinkNS,"href");
            $server->username=$host->getAttribute("username");
            $server->password=$host->getAttribute("password");
            $server->realm=$host->getAttribute("realm");
            $server->idx = $idx++;
            if ( ! $host->hasAttribute("xml:id") )
                $credits[]= $server;
        } 
        return $credits;
    }
    function load() {   
        $xlinkNS = 'http://www.w3.org/1999/xlink';

        $pass_config = new DOMDocument;
        if ( file_exists( self::$file ) )
	        $pass_config->loadXML(file_get_contents( self::$file ));
            
        $hosts = $pass_config->getElementsByTagName('creditentials');
        $this->credits = $this->getCredits( $hosts );
        
    }
    
    function save($ip = null) {
        $xlinkNS = 'http://www.w3.org/1999/xlink';

        $pass_config = new DOMDocument;
        if ( file_exists( self::$file ) )
	        $pass_config->loadXML(file_get_contents( self::$file ));
    
        $creds=$pass_config->getElementsByTagName('creditentials');
        $oldCredits = $this->getCredits( $creds );
        
        $credsList=array();
        foreach ($creds as $cred) $credsList[]=$cred;
        foreach ($credsList as $cred)
            if ( ! $cred->hasAttribute("xml:id") )
                $cred->parentNode->removeChild($cred);
        $parent=$pass_config->getElementsByTagName('credits');
	    if ($parent->length<1) 
            $parent=$pass_config->appendChild($pass_config->createElement('credits'));
	    else 
            $parent=$parent->item(0);
        
        foreach ( $this->credits as &$server ) {
            if ( $server->password == self::$setPasswords ){                
                $found = false;
                foreach ( $oldCredits as $old ) {
                    if ( $old->idx == $server->idx ){
                        $server->password = $old->password;                        
                        $found = true;
                        break;
                    }
                }
                if ( !$found ){
                    $server->addError( 'password', "Password not valid" );
                    return false;
                }
            }
            $cred=$pass_config->createElement('creditentials');
            $cred->setAttribute("username", $server->username);
			$cred->setAttribute("password", $server->password);
			$cred->setAttribute("realm", $server->realm);
			$cred->setAttributeNS($xlinkNS,"xlink:href", $server->getHrefConfig($ip));
			$parent->appendChild($cred);
        }
        Tools::save_file( self::$file, $pass_config->saveXML(), true);
        
    }

    public function refresh($ip) {
        $this->load();
        $this->save($ip);
    }
}
