<?php
/* @var $this ConfigController */

$formConfig = $this->beginWidget(
    'SimpleForm',
    array('title' => 'Ethernet 802.1X', 'id' => '8021X'),
);

if ($wiredAuthInfo) {
    $headers = array(
        'Address',
        'Link Present',
        'IP Configuration',
        'Authenticated',
    );

    if ($ipConfig->netiface === IPConfig::NET_ETHERNET) {
        $ipConfigAddresses = $basicInfo->mac;
    }

    $table = array();

    foreach ($wiredAuthInfo as $name => $interface) {
        $checkmark = fn ($value) =>
            $value ? CHtml::tag('span', array('class' => 'fa fa-check')) : '';

        $table[] = array(
            $interface['address'],
            $checkmark($interface['connected']),
            $checkmark(isset($ipConfigAddresses[$name])),
            $checkmark($interface['authenticated']),
        );
    }

    echo BsHtml::alert(
        BsHtml::ALERT_COLOR_INFO,
        $formConfig->table($headers, $table, array(
            'sizes' => array( 'col-sm-3', '', '', '', '', '', '', '' ),
            'sizes' => array( 'col-sm-3', '', '', '', '', '', '', '' ),
        )),
        array('closeText' => false , 'class' => 'table-responsive'),
    );
} else {
    echo BsHtml::alert(BsHtml::ALERT_COLOR_INFO, 'Not currently configured.');
}

if (Yii::app()->request->isPostRequest) {
    // this is a hack to prevent browser from opening a popup in case the last action was a POST.
    $script = 'location.assign("' . $this->createUrl(
        '/controlcenter/main/network', 
        array('re' => 'load', '#' => '8021X'),
    ) . '");';
} else {
    $script = 'location.reload()';
}

$this->widget(
    'DialogButton',
    array('label' => 'Refresh', 'script' => $script, 'content' => false),
);

$this->endWidget();
