<?php 

$this->beginWidget('SimpleForm', array( 
    'title' => "Test log",
    'hide' => true
)); 
    echo CHtml::openTag("pre") . "\n";
    foreach ( $diag->outputs as $out ){
        echo $out . "\n";
    }
    echo CHtml::closeTag("pre") . "\n";
$this->endWidget();

$this->errorSummary( $diag );

$this->beginWidget('SimpleForm', array( 
    'title' => "Internal test results",    
)); 

    if ( $diag->setupok ) {
        echo CHtml::tag("p", array(), "Test setup was successful." ) . "\n";
    } else {
        echo CHtml::tag("p", array(), "Test setup failed." ) . "\n";
    }
    echo CHtml::tag("p", array(), "Summary:" ) . "\n";
    echo CHtml::openTag("table", array( 'class'=>'table' ) );
    if ( $diag->status != 0 ) 
        $str = CHtml::tag("th", array("class"=>"bg-danger"), "FAILED");
    else
        $str = CHtml::tag("th", array("class"=>"bg-success"), "PASSED");
    echo CHtml::tag("thead", array(), CHtml::tag("tr", array(), CHtml::tag("th", array( 'class'=>'col-md-8' ),"Overall result") . $str ) ) ;
    echo CHtml::openTag("tbody");
    echo CHtml::tag("tr", array(), CHtml::tag("td", array( ),"Steps passed") . CHtml::tag("td", array(), $diag->nr_passed) );
    echo CHtml::tag("tr", array(), CHtml::tag("td", array( ),"Steps skipped") . CHtml::tag("td", array(), $diag->nr_skipped) );
    echo CHtml::tag("tr", array(), CHtml::tag("td", array( ),"Steps failed") . CHtml::tag("td", array(), $diag->nr_failed) );
    echo CHtml::closeTag("tbody");
    echo CHtml::closeTag("table");

    echo CHtml::tag("p", array(), "Details:" ) . "\n";
    echo CHtml::openTag("table", array( 'class'=>'table') );

    foreach ($diag->details as $d) {
        echo CHtml::openTag("tr");
        echo CHtml::tag("td", array('class'=>'col-md-8'), $d['name'] );

        $class = $d['status'] !== 'PASSED' && $d['status'] !== 'SKIPPED' ? "bg-danger" : "bg-success";
        echo CHtml::tag("td", array( 'class'=>$class ), $d['status'] );

        echo CHtml::closeTag("tr");
    }

    echo CHtml::closeTag("table" );

$this->endWidget();

if ( $feedback ) {
    
    $this->beginWidget('SimpleForm', array( 
        'title' => "External test results",
        'button' => "Save results and get report",
        'action' => array( 'post' => array("report") )
    )); 

    echo CHtml::tag("p", array(),"Fill in the form below to finish the tests and click the button below to save and obtain the device report. ".
                                 "Use the text boxes below for any additional remarks that should be saved in the report." ) . "\n";
    
    echo CHtml::hiddenField("pid", $diag->pid ) . "\n";

    if ( ! empty( $diag->fchecks ) ) {
        $str = "";
        foreach ($diag->fchecks as $c)
           $str .= $c['name']  . ' ';
        echo CHtml::hiddenField("checks", $str) . "\n";
        
        echo CHtml::openTag("table", array( 'class'=>'table table-striped'));
        echo CHtml::tag("thead", array(), CHtml::tag("tr", array(),  CHtml::tag("th", array(),"Test / Description") . 
                                        
                                        CHtml::tag("th", array(),"OK") .
                                        CHtml::tag("th", array(),"Bad") .
                                        CHtml::tag("th", array(),"Unknown") .
                                        CHtml::tag("th", array(),"Remarks") ) );

        foreach ($diag->fchecks as $c) {
      
           $hn = htmlspecialchars($c['name']);
           echo CHtml::openTag("tr");
           
           echo CHtml::tag("td", array('class'=>'test' ), $c['label'] );
           
           
           echo CHtml::tag("td", array('class'=>'center'), CHtml::radioButton( 'test_'.$hn , false, array( 'value'=>'ok' ) ) );
           echo CHtml::tag("td", array('class'=>'center'), CHtml::radioButton( 'test_'.$hn , false, array( 'value'=>'bad' ) ) );
           echo CHtml::tag("td", array('class'=>'center'), CHtml::radioButton( 'test_'.$hn , true, array( 'value'=>'unknown' ) ) );
           echo CHtml::tag("td" );
           echo CHtml::closeTag("tr");
           echo CHtml::openTag("tr");
           echo CHtml::tag("td", array('class'=>'desc'), $c['desc'] );
           
           echo CHtml::tag("td", array( 'colspan'=>4 ), CHtml::textArea( 'comm_'. $hn, " ", array( "rows"=>"1", 'style'=>'width:100%;') ) );
           
           echo CHtml::closeTag("tr");
        }
        echo CHtml::closeTag("table");
      
     }
     echo CHtml::tag("p", array(),"General remarks:" );
     echo CHtml::textArea("comments", "", array( "rows"=>"4", 'style'=>'width:100%;' ) );
     
     $this->endWidget();
 }
 
 ?>
<script type="text/javascript" >
//<![CDATA[

$('form').submit(function(){  
    // We will start a get request a bit latter. This request will be blocked until
    // php has finised generating the report, thus insuring that the index page will only be opened once
    // the report has been generated.
    // Because of chrome small timeout, we try this every 30s until we succeed
    window.setInterval( function() {
        $.ajax("/info.php").success( function() {
            window.location.replace("/controlcenter");
        });        
    }, 30*1000 );
    
    return true;
    
}); 
//]]></script>
 