<?php
class DebugLogger extends CFormModel {
    public function rules() {
        return array(
            array('name', 'required'), 
            array('level', 'in', 'allowEmpty' => false, 'range' => 
            $this->levels, 'message' => '{attribute} must be one of ' . 
            implode(', ', $this->levels) . '.', 'strict' => true));
    }

    public $name = '';
    public $level = '';

    private $levels = array(
        'trace', 'debug', 'info', 'warn', 'error', 'fatal');
}

class DebugLog extends CFormModel {
    const FILE = '/etc/raperca/spxconfig.xml';

    public function rules() {
        return array(array('loggers', 'validateLoggers'));
    }

    public function validateLoggers($attribute, $params) {
        $error = false;
        foreach ($this->$attribute as $logger) {
            if (!$logger->validate()) {
                $error = true;
            }
        }
        if ($error) {
            $this->addError($attribute, 'Invalid logger parameters.');
        }
    }

    public function load() {
        $doc = new DOMDocument;
        if (!$doc->load(self::FILE)) {
            return;
        }
        //Use DOMXPath::query?
        if (!($log = $doc->getElementsByTagName('debugLog')->item(0))) {
            return;
        }
        foreach ($log->childNodes as $child) {
            if ($child->nodeType == XML_ELEMENT_NODE && $child->nodeName == 
                'logger') {
                $logger = new DebugLogger();
                $logger->name = $child->getAttribute('name');
                $logger->level = $child->getAttribute('level');
                $this->loggers[$logger->name] = $logger;
            }
        }
    }

    public function save() {
        $doc = new DOMDocument;
        $doc->preserveWhiteSpace = false;
        $doc->formatOutput = true;
        if (!$doc->load(self::FILE)) {
            return;
        }
        $changed = false;
        //Use DOMXPath::query?
        if (($log = $doc->getElementsByTagName('debugLog')->item(0))) {
            $nodes = array();
            foreach ($log->childNodes as $child) {
                if ($child->nodeType == XML_ELEMENT_NODE && $child->nodeName 
                    == 'logger') {
                    $nodes[] = $child;
                }
            }
            foreach($nodes as $node) {
                $log->removeChild($node);
            }
            if (!empty($nodes)) {
                $changed = true;
            }
        } 
        if (!empty($this->loggers)) {
            if (!$log) {
                if (!($node = $doc->getElementsByTagName('configFile')->item(0))) {
                    return;
                }
                $log = $node->appendChild($doc->createElement('debugLog'));
            }
            foreach ($this->loggers as $logger) {
                $node = $log->appendChild($doc->createElement('logger'));
                $node->setAttribute('name', $logger->name);
                $node->setAttribute('level', $logger->level);
            }
            $changed = true;
        } else if ($log && !$log->hasChildNodes()) {
            $log->parentNode->removeChild($log);
            $changed = true;
        }
        if ($changed) {
            Tools::save_file(self::FILE, $doc->saveXML());
            Tools::addReason('debug log configuration change');
        }
    }

    public $loggers = array();
}
