// Media handling class
/* for the translation
 * 
 * spxapi.t('playlist')
 * spxapi.t('playout')
 * spxapi.t('apps')
 * spxapi.t('media') 
 * spxapi.t('template') 
 * spxapi.t('external') 
 */

if ( !"_spxapi_locale_keys" in window ){
    _spxapi_locale_keys = {};    
}

var spxapi = (function() {
    var unloadedPage = false;
    $(window).bind('beforeunload', function(){
        unloadedPage = true;
    });
    var _base_uri= "/api/";
    var iconSet = {
        media : "/images/media_icon.svg",
        playlist : "/images/playlist_icon.svg",
        playout : "/images/playout_icon.svg",
        elementi : "/images/brand_icon.svg",
        project : "/images/project_icon.svg"
    };
    function getSnapshots( previews, icon ) {
        var sizes = {
            small: { h: 256, w:256 },
            medium: { h: 256, w:400 },
            large: { h: 450, w:800 },
            single: { h: 900, w:1600 }
        };
        var result = {
            small: null,
            medium: null,
            large: null,
            single: null
        };

        if ( !previews || previews.length === 0 ) {
            //console.log( "new icon: " + icon );
            var src = ( icon && iconSet[icon]) || icon || iconSet['media'];
            var type = icon?"icon":undefined;
            for ( var size in sizes ) {
                result[size] = {
                               src: ko.observable( src ),                           
                               dh: ko.observable( sizes[size].h ),
                               dw: ko.observable( sizes[size].w ),
                               type: type
                           };
            }   
            result.single.vertical = false;
        } else {
            for ( var i=0; i< previews.length; i++ ) {
                var p_size;
                var type = previews[i].type;
                if ( previews[i].size ) {
                    p_size = previews[i].size.split("x");
                } else {
                    if ( type==='icon' )
                        p_size = [16, 16];
                    else
                        p_size = [256, 256];
                }
                var p_h = parseInt(p_size[1]);
                var p_w = parseInt(p_size[0]);
                for ( var size in sizes ) {
                  if ( p_h<=sizes[size].h || p_w<=sizes[size].w ){
                       if ( result[size]===null || 
                               ( result[size].type==='default' && type!=='default' ) ||
                               ( type!=='default' && (result[size].h<p_h || result[size].w<p_w ) ) 
                                ){
                           var dh = sizes[size].h;
                           var dw = dh*p_w/p_h;
                           if ( dw<sizes[size].w ) {
                               dw = sizes[size].w;
                               dh = dw*p_h/p_w;
                           }
                           result[size] = {
                               src: ko.observable( previews[i].uri ),
                               h: p_h,
                               w: p_w,
                               dh: ko.observable( dh ),
                               dw: ko.observable( dw ),
                               type: type
                           };
                       }
                   }                   
               }
            }
            result.single.vertical = result.single.h > result.single.w;                                    
        }
        return result;
    }
    function addModelList( data, textStatus, jqXHR ){         
        for ( var i=0; i<data.length; i++ )
            data[i].model = _spxapi.resources.add( data[i] ); 
    }
    function addModel( data, textStatus, jqXHR ){
        data.model = _spxapi.resources.add( data );
    }
    function fail( jqXHR, textStatus, errorThrown ){
        if ( unloadedPage ){
            // do not display the errors if the user is unloading the page
            return; 
        }
        var r = {};
        if ( jqXHR.responseText ){
            try {
                r = JSON.parse( jqXHR.responseText );
            } catch ( e ) {
                
            }
        }
        var error;
        if ( 'errors' in r && $.isArray(r.errors) && r.errors.length == 1  ){
            r.error = r.errors[0];
            r.errors = null;
        }
        if ( 'error' in r ) {
            error = spxapi.t(r.error);
        } else {
            error = spxapi.t("Some error occured")+": " + errorThrown;
        }
        var body;
        if ( r.errors ) {
            body = error + "<ul>";
            for ( var i=0 ; i<r.errors.length; i++ ){
                body += "<li>" + spxapi.t(r.errors[i]) + "</li>" ;                
            }
            body += "</ul>";
        } else if ( r.details ) {
            body = r.error + "<ul>";
            for ( var key in r.details ){
                var errors = r.details[key];
                for ( var i=0 ; i<errors.length; i++ ){
                    body += "<li>" + spxapi.t(errors[i]) + "</li>" ;                
                }                
            }
            body += "</ul>";
        } else {
            body = r.error;            
        }
        _spxapi.ui.message({
            body: body
        });
        if ( r.redirect ){
            setTimeout(function(){  
                if ( location == r.redirect ){
                    location.reload();
                } else {
                    location.assign( r.redirect );                
                }
            }, 1000);
        }    
    }
    var _spxapi = {
        media: {  
            uri: _base_uri+"media/",
            list: function( ) {
                return $.ajax( this.uri, {
                    type: "GET",                    
                    dataType : "json"
                }).done( addModelList ).fail( fail );
            },
            create: function( name, file ) {                
                var fd = new FormData();
                fd.append("media", file); // Append the file
                fd.append("data", JSON.stringify({ name: name }) );

                return $.ajax( this.uri, {
                    type: "POST",
                    processData: false,
                    contentType: false,
                    data : fd,
                    dataType : "json"
                }).done( addModel ).fail( fail );
            },
            get: function ( uri ) {
                return $.ajax( uri, {
                    type: "GET",
                    dataType : "json"
                }).done( addModel ).fail( fail );;
            },
            del: function ( uri, force ) {
                if ( force===true )
                    uri += "?force=true";
                return $.ajax( uri, {
                    type: "DELETE",
                    dataType : "json"
                }).fail( fail );;
            },
            updateData: function ( uri, data ) {
                return $.ajax( uri+"data", {
                    type: "PUT",
                    contentType : "application/json",
                    data : JSON.stringify( data ),
                    dataType : "json"
                }).done( addModel ).fail( fail );
            },
            updateMedia: function ( uri, file, contentType ) {
                return $.ajax( uri+"media", {
                    type: "PUT",
                    contentType : contentType,
                    data : file,
                    dataType :  "json",
                    processData: false
                }).done( addModel ).fail( fail );
            }
        }
    };
    $.each(['playlist', 'playout', 'template', 'apps', 'external', 'project' ], function(i, name) {
        _spxapi[name] = {  
            uri: _base_uri+name+"/",
            list: function( data ) {
                return $.ajax( this.uri, {
                    type: "GET",     
                    data: data,
                    dataType : "json"
                }).done( addModelList ).fail( fail );
            },
            create: function( args ) {                
                return $.ajax( this.uri, {
                    type: "POST",
                    contentType : "application/json",
                    data : JSON.stringify( args ),
                    dataType : "json"
                }).done( addModel ).fail( fail );
            },
            get: function ( uri ) {
                return $.ajax( uri, {
                    type: "GET",
                    dataType : "json"
                }).done( addModel ).fail( fail );
            },
            del: function ( uri, force ) {
                if ( force===true )
                    uri += "?force=true";
                return $.ajax( uri, {
                    type: "DELETE",
                    dataType : "json"
                }).fail( fail )
                  .done( function( data ) {
                    if ( data.variables ){
                        _spxapi.rpc.variable_remove( data.variables );
                    }
                });
            },
            update: function ( uri, args ) {                
                return $.ajax( uri, {
                    type: "PUT",
                    contentType : "application/json",
                    data : JSON.stringify( args ),
                    dataType : "json"
                }).done( addModel ).fail( fail );
            }
        };
    });
    
    _spxapi.schedule = {  
        uri: _base_uri+"schedule/",
        get: function( data ) {
            function pad(number) {
                if ( number < 10 ) {
                  return '0' + number;
                }
                return number;
            }
            function formatDate( date ) {
                return date.getUTCFullYear() +
                  '-' + pad( date.getUTCMonth() + 1 ) +
                  '-' + pad( date.getUTCDate() );
            };
            var now = new Date();
            var start = new Date( now - 30*24*3600*1000);
            var end = new Date( "2035-01-01T00:00:00" );

            data = data || {};
            if ( data.start === undefined  ){
                data.start = formatDate( start );
            }
            if ( data.end === undefined ){
                data.end = formatDate( end );
            }
            return $.ajax( this.uri, {
                type: "GET", 
                data: data,
                dataType : "json"
            }).done( function( data, textStatus, jqXHR ) {
                for ( var i=0; i<data.length; i++ ){
                    if ( data[i].resource ) {
                        data[i].resource.model =_spxapi.resources.add( data[i].resource ); 
                    }
                }
            }).fail( fail );
        },
        set: function( args ) {                
            return $.ajax( this.uri, {
                type: "PUT",
                contentType : "application/json",
                data : JSON.stringify( args ),
                dataType : "json"
            }).done( function( data, textStatus, jqXHR ) {
            }).fail( fail );
        },
        clear: function( ) {                
            return $.ajax( this.uri, {
                type: "DELETE",
                contentType : "application/json",
                dataType : "json"
            }).done( function( data, textStatus, jqXHR ) {
            }).fail( fail );
        }
    };
    _spxapi.rpc = {
        uri: "/rpc",
        call: function( method, params, id ) {       
            var args = {
                method: method,
                params: params,
                id: id || 1
            };
            return $.ajax( this.uri, {
                type: "POST",
                contentType : "application/json",
                data : JSON.stringify( args ),
                dataType : "json"
            }).fail( fail );
        },
        variable_get: function( name, callback ) { 
            return this.call( "webstorage_get", [ [ name ] ] ).done( function( data ){
                if ( !data.error && data.result && data.result.length === 1 && data.result[0].success ){
                    callback( JSON.parse( data.result[0].value ) );
                } else {
                    callback( );
                }
            });
        },
        variable_set: function( name, value ) { 
            return this.call( "webstorage_set", [ [ { name: name, value: JSON.stringify( value ) } ] ] );
        },
        variable_remove: function( name ) { 
            if ( !$.isArray(name) ){
                name = [ name ];
            }
            return this.call( "webstorage_remove", [ name ] );
        }
    };
    /**
     * resources: @type Object global variable to store the information about the assets:
        id: {
            name: ko.observable( )
            snapshots : {
                small : {
                    src: ko.observable(  ),
                    h: int,
                    w: int,
                    dh: ko.observable(  ),
                    dw: ko.observable(  ),
                    type: String
                },
                medium: ...,
                large: ...,
                single: ...
            }
        }
     **/
    _spxapi.resources = {
        _r: {},
        add: function( data ) {
            if ( !data ){
                return;
            }
            var id = data.id;
            if ( !id ) 
                return null;
            if ( this._r[id] ){
                //console.log( "update: " + id);
                this._r[id].name( data.name );
                this._r[id].manage( data.manage );
                this._r[id].type( data.type );
                var snapshots = getSnapshots( data.previews, data.icon );
                this._r[id].vertical( data.vertical || snapshots.single.vertical );
                for ( var size in this._r[id].snapshots ) {
                    var source = snapshots[size];
                    var dest = this._r[id].snapshots[size];                
                    dest.src( source.src() );
                    dest.dh( source.dh() );
                    dest.dw( source.dw() );
                    dest.h = source.h;
                    dest.w = source.w;
                    dest.type = source.type;                        
                }
            } else {
                //console.log( "new: " + id);
                this._r[id] = {
                    name: ko.observable( data.name ).extend( { shortStr: 20 } ),
                    manage: ko.observable( data.manage ),
                    type: ko.observable( data.type ),
                    snapshots: getSnapshots( data.previews, data.icon ),
                    mimeType: ko.observable( data.mimeType )
                };
                this._r[id].vertical = ko.observable( data.vertical || this._r[id].snapshots.single.vertical );
            }                
            return this._r[id];
        },
        edit: function( id ) {
            if ( !this._r[id] ){
                return;
            }
            var media = this._r[id];
            _spxapi.ui.modalDialog( {
                title: media.name(),
                body: "<img src='"+media.snapshots.single.src()+"'/>",
                buttons : [                        
                    { name: "OK" }
                ]
            } ).modal('show');
        },
        deleteForced: function( id, callback ) {
            var self = this;
            if ( !this._r[id] ){
                if ( callback ){
                    callback( false );
                }
                return;
            }
            var media = this._r[id];
            var type = media.type();
            var manage = media.manage();
            _spxapi[type].del( manage, true ).done(  function( data, textStatus, jqXHR ) { 
                self._r[id] = null;
                if ( callback ){
                    callback( data, textStatus, jqXHR );
                }
            });
        },
        delete: function( id, callback ) {
            var self = this;
            if ( !this._r[id] ){
                if ( callback )
                    callback( false );
                return;
            }
            var media = this._r[id];            
            var type = media.type();
            var manage = media.manage();
            _spxapi[type].del( manage ).done( function( data, textStatus, jqXHR ) { 
                if ( jqXHR.status===202 ) {
                    var txt = "<p>"+spxapi.t("Used by")+"<ul>";
                    var txt2 = "";
                    for (var i=0; i< data.length; i++ ) {
                        if ( data[i].type === 'schedule' ){
                            txt += "<li>"+data[i].name+"</li>";
                        } else {
                            txt2 += "<li>"+spxapi.t(data[i].type) + ": "+data[i].name+"</li>";
                        }
                    }
                    txt += txt2;
                    txt += "</ul></p>";

                    var msgId = _spxapi.ui.message( {
                        title: spxapi.t("{name} in use", { "{name}": media.name()} ),
                        body: txt,
                        sticky: true,
                        button : {  
                                name: spxapi.t("Delete anyway"),
                                action: function( ev ) {
                                    $(ev.target).button('loading');
                                    _spxapi.resources.deleteForced( id, function( data, textStatus, jqXHR ){
                                        _spxapi.ui.removeMessage( msgId );
                                        if ( callback ) {
                                            callback( data, textStatus, jqXHR );
                                        }
                                    });
                                },
                                close: false
                            }
                    } );
                } else {
                    self._r[id] = null;
                    callback( data, textStatus, jqXHR );
                }
            });
        }, 
        get: function( id ) {
            if ( !id ) {                    
                return {
                    name: ko.observable( 'unknown' ).extend( { shortStr: 20 } ),
                    manage: ko.observable( ),
                    type: ko.observable( ),
                    vertical: ko.observable( ),
                    snapshots: getSnapshots( ),
                    mimeType: ko.observable( )
                };
            }
            if ( !this._r[id] ){
                //console.log( "blanck: " + id);
                this._r[id] = this.get();
                var string = "" + id;                
                this._r[id].name( string.charAt(0).toUpperCase() + string.slice(1) );
            }
            return this._r[id];                    
        },
        updateCalendarNewItem: function( data ) {
            // if this is a new item, then we complete it
            var memory = _spxapi.storage.get("spx-calendar-new-item" );
            if ( memory ){
                var newItem = JSON.parse( memory );
                newItem.title = data.name;
                newItem.resource = {
                    id: data.id,
                    type: data.type
                };  
                _spxapi.storage.set( "spx-calendar-new-item", JSON.stringify( newItem ) );                
            }
        }       
    };
    _spxapi.storage = {
        get: function( name ){
            if ( !localStorage ){
                return "";
            }
            try {
                return localStorage.getItem( name );
            } catch( e ){             
                return "";
            } 
        },
        set: function( name, value, errorText  ){
            if ( !localStorage ){
                if ( errorText ){
                    alert( errorText );
                }
                return false;
            }
            try {
                localStorage.setItem( name, value );
            } catch( e ){
                if ( errorText ){
                    alert( errorText );
                }
                return false;
            }
            return true;
        },
        remove: function( name ){
            if ( !localStorage ){
                return true;
            }
            try {
                localStorage.removeItem( name );
            } catch( e ){             
            }
            return true;
        }
    };
    _spxapi.ui = {
        loading: function( target ){
            $(target).button('loading');
        },
        reset: function( target ){
            $(target).button('reset');
        },
        iconAction: function( options ){
            var icon = "question";
            var txt = options.type;

            switch ( options.type ){
                case "settings": icon = "gear"; txt = spxapi.t("Settings"); break; 
                case "edit": icon = "pencil"; txt = spxapi.t("Edit"); break; 
                case "delete": icon = "times"; txt = spxapi.t("Delete"); break; 
                case "open": icon = "edit"; txt = spxapi.t("Open"); break;
                case "copy": icon = "copy"; txt = spxapi.t("Copy"); break;
                case "single": icon = "ellipsis-h"; txt = spxapi.t("Single Line"); break;
                case "double": icon = "th-large"; txt = spxapi.t("Double Line"); break;
                case "all": icon = "th-large"; txt = spxapi.t("All Media"); break;
                case "large": icon = "th-large"; txt = spxapi.t("Large Icon"); break;
                case "small": icon = "th"; txt = spxapi.t("Small Icon"); break;
                case "list": icon = "list"; txt = spxapi.t("List View"); break;
                case "media": icon = "camera"; txt = spxapi.t("Media"); break;
                case "image": icon = "picture-o"; txt = spxapi.t("Image"); break;
                case "video": icon = "video-camera"; txt = spxapi.t("Video"); break;
                case "audio": icon = "music"; txt = spxapi.t("Audio"); break;
                case "playlist": icon = "film"; txt = spxapi.t("Playlist"); break;
                case "apps": icon = "list-alt"; txt = spxapi.t("App"); break;
                case "playout": icon = "desktop"; txt = spxapi.t("Playout"); break;
                case "external": icon = "sign-in"; txt = spxapi.t("Live Sources"); break;
                case "template": icon = "desktop"; txt = spxapi.t("Template"); break;
                case "backup": icon = "upload"; txt = spxapi.t("Backup"); break;
                case "project": icon = "folder-o"; txt = spxapi.t("Project"); break; // archive, address-card-o
            };
            var text = options.text;
            if ( options.text === true ){
                text = txt;
            } else {
                text = "";
            }
            var tooltip = options.tooltip;
            if ( options.tooltip === true ){
                tooltip =  " title='"+ txt +"' data-toggle='tooltip'";
            } else {
                tooltip = "";
            }


            if ( options.link )
                return "<a class='btn btn-default btn-xs' href='"+options.link+"'"+tooltip+" ><i class='fa fa-"+icon+"'></i>"+text+"</a>";
            if ( options.click )
                options.bind = "click: " + options.click;                   
            if ( options.bind )
                return "<a class='btn btn-default btn-xs' data-bind='"+options.bind+"'"+tooltip+"><i class='fa fa-"+icon+"'></i>"+text+"</a>";
            // just an icon, without actions
            return "<span class='fa-stack'"+tooltip+">"+
                        "<i class='fa fa-circle fa-stack-2x' style='color: #1a68b3'></i>"+
                        "<i class='fa fa-inverse fa-"+icon+" fa-stack-1x'></i>"+
                   "</span>";
            //return "<i class='fa fa-"+icon+"'></i>";
        },
        modalDialog: function( args ) {
            var contentHeight = args.contentHeight || 300;
            var contentWidth = args.contentWidth || 580;
            
            var main = $("<div/>")
                    .addClass("modal fade");
            var dialog = $("<div/>")
                    .addClass("modal-dialog")
                    .appendTo( main );
            
            var content = $("<div/>")
                    .addClass("modal-content")
                    .appendTo( dialog );
            
            var headerContent = null;
            if ( args.header )
                headerContent = args.header;
            else if ( args.title ) {
                headerContent = $("<h4/>")
                        .addClass("modal-title")
                        .text( args.title );
            }
            if ( headerContent ){
                var header = $("<div/>")
                        .addClass("modal-header")
                        .appendTo( content );
                var button = $("<button>&times;</button>")
                                    .attr( 'type', 'button')
                                    .attr( 'data-dismiss', 'modal')
                                    .addClass("close");
                header.append( button );
                header.append( headerContent );
            }
            if ( args.body ) {
                var body = $("<div/>")
                        .addClass("modal-body")
                        .appendTo( content );
                body.append( args.body );
            }
            if ( args.footer ) {
                var footer = $("<div/>")
                        .addClass("modal-footer")
                        .appendTo( content );
                footer.add( args.footer );
            } else if ( args.buttons ) {
                var footer = $("<div/>")
                        .addClass("modal-footer")
                        .appendTo( content );
                for ( var i=0; i< args.buttons.length; i++ ) {
                    var btn = args.buttons[i];
                    var button = $('<button/>')
                                    .attr( 'type', 'button')
                                    .addClass("btn")
                                    .appendTo( footer );
                    if ( btn.class )
                        button.addClass( btn.class );
                    if ( btn.name )
                        button.text( btn.name );
                    else
                        button.text( "Close" );
                    if ( btn.action )
                        button.click( btn.action );
                    if ( btn.close!==false )
                        button.attr( 'data-dismiss', 'modal');
                }
            }
            $('body').append(main);
            main.css('display', 'block');
            dialog.width(contentWidth);
            content.height(contentHeight + 'px');
            dialog.css({
                'margin-top': ($(window).height() - dialog.height()) / 2 + 'px',
                'padding-top': 0
            });
            main.css('display', '');
            /*
            if ( args.target ){
                $(args.target).add( main );
            } else {
                $('body').add( main );
            }
            */
            main.modal();
            /*
            main.on('hidden.bs.modal', function () {
                main.remove();
            });
            */
            return main;
        }, 
        message: function( args ) {
            args = args || {};
            
            if ( args.header ){
                alert( "args.header not supported");
            }
            var text = args.body || "";
            if ( args.footer ){
                alert( "args.footer not supported");
            }
            if ( args.progress ){
                if ( args.progress == "100%" ) {
                    text += "<div class='progress'><div class='progress-bar progress-bar-striped active' role='progressbar' style='width: 100%;'></div></div>";
                } else {
                    text += "<div class='progress'><div class='progress-bar' role='progressbar' style='width: 0%;'></div></div>";
                }
            }
            var afterOpen;
            if ( args.button ){
                var btn = args.button;
                var css = 'btn';   
                var txt = 'Close'; 
                var attr = '';
                if ( btn.class ){
                    css += " " + btn.class ;
                } else {
                    css += " btn-default";
                }
                if ( btn.name )
                    txt = btn.name ;
                if ( btn.onclick )
                    attr += " onclick='"+btn.onclick+"'";
                if ( btn.action ){
                    css += " spx-action";
                    if ( btn.close === false ){
                        afterOpen = function( elem ){
                            elem.find( ".spx-action" ).click( btn.action );
                        };
                    } else {
                        afterOpen = function( elem ){
                            elem.find( ".spx-action" ).click( function( ev ){
                                btn.action( ev );
                                $.gritter.remove( uniqueId );
                            });
                        };
                    }
                    
                }
                if ( btn.close!==false )
                    attr += " data-dismiss='modal'";                        
                text += "<div class='pull-right'><button class='"+css+"'"+attr+">"+txt+"</button></div>";
            }
            var options = $.extend({
                title: args.title || args.type || 'warning',
                text: text,                
                time: 20*1000,                  
                class_name: args.type || 'warning',
                after_open: afterOpen,
            }, args);

            var uniqueId = $.gritter.add( options );
            return uniqueId;
        },
        removeMessage: function( id ) {
            $.gritter.remove( id, { });
        },
        resourceLoadingInfo: {
            toLoad: 0,
            loaded: 0,
            inc: 0,
            msgId: null,
            progressBar: null,
            timer: null,
            self: this,
            start: function() {
                if ( !this.msgId ) {
                    this.toLoad = 0;
                    this.loaded = 0;
                    this.msgId = _spxapi.ui.message({
                        title: spxapi.t('Loading resources'),
                        body: "",
                        progress: true,
                        type: 'info',
                        sticky: true, 
                        after_close: function() {
                            _spxapi.ui.resourceLoadingInfo.msgId = null;
                        }, 
                        after_open: function( el ) {
                            _spxapi.ui.resourceLoadingInfo.progressBar = el.find('.progress-bar');
                            _spxapi.ui.resourceLoadingInfo.timer = window.setInterval( function() {
                                var self = _spxapi.ui.resourceLoadingInfo;
                                var v = self.inc++;
                                if ( self.progressBar && self.msgId ) {   
                                    var p = parseInt( 100*self.loaded/self.toLoad + v, 10 );
                                    if ( p > 99 ){
                                        p = 99;
                                        self.inc -= 5;
                                    }                                    
                                    self.progressBar.css( 'width', p + '%'); 
                                }
                            }, 1000 );
                        }
                    });
                }
            },
            finished: function() {
                this.loaded++;
                this.inc = 0;                
                if ( this.progressBar && this.msgId ) {                       
                    this.progressBar.css( 'width', parseInt( 100*this.loaded/this.toLoad, 10 ) + '%'); 
                }
                if ( this.msgId && this.loaded === this.toLoad ){
                    _spxapi.ui.removeMessage( this.msgId );
                    this.msgId = null;
                    if ( this.timer ){
                        window.clearInterval( this.timer );
                    }
                }        
            }
        }
    };   
    var first = true;
    _spxapi.locale = {    
        _lang: "en",
        setLang: function( lang ){
            console.log( "Setting language to: " + lang );
           this._lang = lang; 
        },        
        names: [ "en_US" ],
        languages: { "en" : {"en_US": "English" } },        
        timezones:{},
        territory:{},
        keys:{},
        r: function( txt, args ){
            if ( args ) {
                for ( var k in args ) {
                    var patt = new RegExp(k , "g");
                    txt = txt.replace( patt, args[k] );
                }
            }
            return txt;            
        },
        t: function( str, args, appskeys ) {
            var keys = appskeys || _spxapi_locale_keys || {};
            if ( str in keys && keys[str] !== "" ) {
                return this.r( keys[str], args);
            } else {     
                if ( this._lang !== "en" ){
                    console.log( "Translation not found: " + str );                       
                }
                return this.r( str, args);
            }
        },
        getTimezones: function () {
            if ( _spxapi_locale_timezones ){
                return _spxapi_locale_timezones;
            } else {
                return [ "UTC" ];
            }
        },
        formatLocale: function( id ){
           if ( !this.languages[this._lang] ){
               return "no language: " + id.replace("_"," ");
           }
           if ( !this.languages[this._lang][id] ){
               return "no found: " + id.replace("_"," ");
           }
           return this.languages[this._lang][id];
        },
        formatTimezone: function( id ){
            if ( id === "" || !id ){
                return spxapi.t("Local time");
            }
            if ( !this.timezones[this._lang] ){
                console.log( "Timezone not found for: " + this._lang );
                return id.replace("/"," / ");
            }
            var txt = "";
            var items = id.split("/");
            var countryCode = items[0];

            items.splice( 0, 1);
            if ( this.territory[this._lang][countryCode] ){
                txt += this.territory[this._lang][countryCode] + " / ";
            } else {
                if ( countryCode !== "--") {
                    for ( var i=0; i<items.length-1; i++){              
                       txt += _spxapi.locale.t( items[i].replace("_"," ") ) + " / ";
                    }
                } else {
                    items[ items.length-1 ] = items[ items.length-1 ].replace("\-", ":").replace("\+", "-").replace(":", "+");
                }
            }

            if ( !this.timezones[this._lang][id] ){
                txt += items[ items.length-1 ].replace("_"," ");
            } else {
                txt += this.timezones[this._lang][id];
            }
            return txt;
        }
    };
    _spxapi.t = function( str, args, appskeys ) {
        return _spxapi.locale.t( str, args, appskeys);    
    };
    return _spxapi;
})();


function alertBox( args ) {
    var main = $(document.createElement('div'))
            .addClass("alert alert-danger fade in");
    if ( args.type )
        main.addClass("alert-"+args.type);
    else
        main.addClass("alert-warning");
    var close = $("<button>&times;</button>")
                            .attr( 'type', 'button')
                            .attr( 'data-dismiss', 'modal')
                            .addClass("close");
    main.append( close );
    
    if ( args.title ) {
        main.append( $(document.createElement('h4')).text( args.title ) );
    }
    if ( args.body ) {
        main.append( args.body );
    }
    if ( args.buttons ) {
        var p = $(document.createElement('p')).appendTo( main );
        for ( var i=0; i< args.buttons.length; i++ ) {
            var btn = args.buttons[i];
            var button = $(document.createElement('button'))
                            .attr( 'type', 'button')
                            .addClass("btn")
                            .appendTo( p );
            if ( btn.class )
                button.addClass( btn.class );
            if ( btn.name )
                button.text( btn.name );
            else
                button.text( "Close" );
            if ( btn.action )
                button.click( btn.action );
            if ( btn.close!==false )
                button.attr( 'data-dismiss', 'alert');
        }
    }
    main.alert();
    return main;
}
function debug( object ){
    var myObject = object;
}
$(function() {
    $.fn.button.Constructor.DEFAULTS.loadingText = "<i class='fa fa-circle-o-notch fa-spin'></i>";
});
