<?php
/* @var $this MediaController */
// If neededing additonal scripts
//Yii::app()->clientScript->registerScriptFile(Yii::app()->baseUrl.'/js/ascript/file',CClientScript::POS_END);
$agent = Yii::app()->request->userAgent;
if ( strpos($agent, 'iPhone OS 7') === false && strpos($agent, 'iPad OS 7') === false ){
    $multiple = 'multiple="multiple" ';
} else {
    $multiple = "";
}

$this->breadcrumbs = array( 
    I18N::t("Playouts") => array( "playing/create", 'filter'=>'playout' ),
    "ko" =>"breadcrumbs"
);
$this->title = I18N::t("Playout");

$this->registerSpxScript( 'playlist.js' );
$this->registerSpxScript( 'apps.js' );
$this->registerSpxScript( 'playout.js' );
$this->registerSpxScript( 'resources.js' );

$this->topBar .= $this->widget('ActionSet', array(
    'actions' => array(
        array( 'preset'=> 'ok',
                'data-bind' => 'click: save, hidden: !editLayout() && !appForLayout(), css: { disabled: playout().overlap() }'
        ),
        array( 'preset'=> 'copy',
                'data-bind' => 'click: copy, visible: !editLayout() && !appForLayout() && id()',
                'visible' => Yii::app()->user->checkAccess('copyPlayout')
        ),
        array( 'preset'=> 'apply',
                'data-bind' => 'click: apply, visible: !editLayout() && !appForLayout() && status.isDirty()'
        )
    ),
    'options' => array( 
        "class" => "pull-right", 
        "data-bind" => 'visible: !playlist() || !playlist().visible()'
    )
), true); 

$this->topBar .= $this->widget('ActionSet', array(
    'actions' => array(
        array( 'icon'=> 'edit', 'title' => I18N::t('Edit'),                 
                'data-bind' => 'click: function(){ editLayout( true ); }, visible: !playout().locked() && !editLayout() && !appForLayout()',
                'id' => 'EditComponents',
                'visible' => Yii::app()->user->checkAccess('managePlayoutLayers') 
        ),
        array( 'preset'=> 'properties',                 
                'data-bind' => 'click: function(){ playout().editProperties( !playout().editProperties() ); }, '.
                                'css: { active: playout().editProperties()}, '.
                'visible: !appForLayout()',
                'id' => 'EditProperties'
        ),
    ),
    'options' => array( 
        "class" => "pull-right", 
        "data-bind" => 'visible: !playlist() || !playlist().visible()'
    )
), true);

$this->topBar .= $this->widget('ActionSet', array(
    'actions' => array(
        array( 'icon'=> 'exchange', 'title' => I18N::t('Swap Horizontal'),                 
                'data-bind' => 'click: playout().switchHorizontal',
                'id' => 'HorizontalSwitch'),
        array( 'icon'=> 'exchange fa-rotate-90', 'title' => I18N::t('Swap Vertical'),                 
                'data-bind' => 'click: playout().switchVertical',
                'id' => 'VerticalSwitch'),
        array( 'icon'=> 'arrows-h', 'title' => I18N::t('Fill Horizontal'),                 
                //'data-bind' => 'click: playout().fillHorizontal, css: { disabled: !playout().selectedLayer() || playout().selectedLayer().background }',
                'data-bind' => 'click: playout().fillHorizontal',
                'id' => 'FillHorizontal'),
        array( 'icon'=> 'arrows-v', 'title' => I18N::t('Fill Vertical'),                 
                //'data-bind' => 'click: playout().fillVertical, css: { disabled: !playout().selectedLayer() || playout().selectedLayer().background }',
                'data-bind' => 'click: playout().fillVertical',
                'id' => 'FillVertical'),
        
    ),
    'options' => array( 
        "class" => "pull-right", 
        "data-bind" => 'visible: editLayout()'
    )
), true);

$this->topBar .= $this->widget('ActionSet', array(
    'actions' => array(
        array( 'preset'=> 'upload',
                "data-bind" => "if: !playlist(), visible: ( !playlist() || playlist().visible() ) && !editLayout() && playout().selectedLayer() && playout().selectedLayer().type === 'playlist'",
                'html' => '<input type="file" '.$multiple.' name="media" data-bind="jQueryFileupload: addMediaFile, args: {url: spxapi.media.uri} " />' ),
        
    ),
    'options' => array( 
        "class" => "pull-right", 
        "data-bind" => 'visible: !playlist() || !playlist().visible()'
    )
), true); 

$this->topBar .= $this->helpButton( 
    array(
        'steps' => array(
            array( 'intro' => I18N::t('This page let you edit Playout')),
            array( 
                'element' => '#MediaIconViewTable',
                'intro' => I18N::t('Select the files to be displayed'),
                "position" => 'top'
            ),        
            array( 
                'element' => '#MediaIconViewTable',
                'intro' => I18N::t('Upload your media using drag & drop from explorer'),
                "position" => 'top'
            ),
            array( 
                'element' => '.spx-dropzone',
                'intro' => I18N::t('Drop the file on any media apps of the Playout.'),
                "position" => 'right'
            ),
            array( 
                'element' => '#accordion',
                'intro' => I18N::t('Click on any available apps to select it. Selected apps are highlighted in the preview.'),
                "position" => 'left'
            ),
            array( 
                'element' => '#accordion .panel-heading span[title="'.I18N::t('Clear').'"]',
                'intro' => I18N::t('Click to clear all the content of the media apps.'),
                "position" => 'left'
            ),
            array( 
                'element' => '#accordion .panel-heading span[title="'.I18N::t('Edit').'"]',
                'intro' => I18N::t('Click to edit the content of the media apps.'),
                "position" => 'left'
            ),
            array( 
                'element' => '#EditProperties',
                'intro' => I18N::t('Click to change the name of the Playout or to add keywords.'),
                "position" => 'left'
            ),
            array( 
                'element' => '#EditComponents',
                'intro' => I18N::t('Click to edit the position of the apps or to add/delete apps.'),
                "position" => 'left'
            ),
        )
    ), 
    "startIntroPlayout", array( "data-bind" => 'visible: !editLayout() && ( !playlist() || !playlist().visible() )') 
);
//echo BsHtml::alert( BsHtml::ALERT_COLOR_WARNING, "This is currently displayed on the screen",  array( "data-bind"=> "visible: playout().active()" ) );

?>
<div data-bind="hidden: editLayers()">
    <?php $this->renderPartial("edit/top"); ?>  
</div>
<div data-bind="if: playlist()">
    <?php $this->widget('PlaylistEdit', array( 'editName' => false, 'hasCancel' => false )); ?>
</div>
<div class="row">    
    <div id="selectZoneHorizontal" class=" col-md-12" data-bind="css:{ 'col-sm-6': !( playlist() && playlist().visible()) && !useVerticalLayout()}"> 
        <div id="selectZone"> 
            <div class="clearfix" data-bind="with: apps, visible: editLayout()">
                <?php $this->widget('AssetsSelect', array( 'direction'=> false )); ?>        
            </div>
            <div data-bind="visible: !editLayers() || ( playlist() && playlist().visible())" >
                <div class="clearfix" data-bind="with: media, visible: !editLayout()">
                    <?php $this->widget('AssetsSelect', array( 
                        'tableOptions'=>array( "id"=>"MediaIconViewTable" )                    
                    )); ?>        
                </div>
            </div>
       </div> 
    </div> 
</div>
<div id="appsTemplates" >
    <script type="text/html" id="loading">
        <div>Loading...</div>        
    </script> 
</div>

<script type="text/javascript" >
//<![CDATA[
var model = new PlayoutEdit({
<?php 
    if ( isset($id) ) {
        echo "\tid: '".$id."',\n";
    } else if ( isset($templateId) ) {
        echo "\ttemplateId: '".$templateId."',\n";
        echo "\tbackLink: " . CJavaScript::encode( CHtml::normalizeUrl( '/assets/playing/schedule' ) ).",\n";
    }
    echo "\tappsEditLink: " . CJavaScript::encode( Yii::app()->getBaseUrl(true) . $this->createUrl("apps/edit", array('id'=>"[id]") ) ). "\n";
?>
});

Layer2('setTarget', $('#playoutEditZone') );

// add drag utils to the model
(function ( model ){
    var handle_click = true;
    model.hideSVG = ko.observable( false );
    model.startResize  = function( layer, event, ui ) { 
        model.hideSVG( true );
    };
    model.startDrag = function( layer, event, ui ) { 
        model.selectLayer( layer, true ); 
        handle_click = false;
    };
    model.stopDragResize = function( layer, event, ui ) { 
        handle_click = false;
        model.hideSVG( false );
    };
    model.click = function( layer ) { 
        if ( handle_click )
            model.selectLayer( layer ); 
        handle_click = true;    
    };
    model.editTemplateName = function( layer ) {        
        if ( model.editLayout() ){
            if ( layer.resizable || layer.draggable )
                return "position-template";
            else 
                return "fixed-template";
        } else {
            if ( layer.type==='playlist' )
                return "playlist-template";
            else
                return "widget-template";
        }
    }; 
}(model));

ko.applyBindings( model );

//]]></script>