<?php

class CertificatesController extends ControlCenterController
{    
    public function actionAdd()
    {
        $this->ajaxOnly(); 
        $errors = array();
        $data = null;
        $sslConfig = new SSLConfig;
        $sslConfig->setScenario('upload');
        if ( isset($_FILES['SSLConfig']) ) {
            $sslConfig->setAttributes( $_FILES['SSLConfig'] );
            if ( $sslConfig->validate() )
                $data = $sslConfig->saveCertificate( CUploadedFile::getInstance($sslConfig, 'uploadedfile') );
        }  else {
            $errors[] = "No file provided";            
        }
        
        $this->render('/layouts/ajax', array(
            'errors' => $this->updateErrors( $sslConfig, $errors ),
            'data' => $data
        ));
    }
    public function actionAddServer()
    {
        $this->ajaxOnly(); 
        $errors = array();
        $serverCertificates = new ServerCertificates;
        if ( isset($_POST['ServerCertificates']) ) {
            $serverCertificates->setAttributes( $_POST['ServerCertificates'] );  
            $serverCertificates->handleFiles();            
        }
        $data = $serverCertificates->getCertificatesList( );
        $this->render('/layouts/ajax', array(
            'errors' => $this->updateErrors( $serverCertificates, $errors ),
            'data' => $data
        ));
    }
    public function actionDelete()
	{
        $this->ajaxOnly();
        
        $errors = array();
        $sslConfig = new SSLConfig;
        $sslConfig->scenario = 'delete';
        $sslConfig->target = Yii::app()->request->getParam("target");
        $sucess = $sslConfig->delete( );
        $this->render('/layouts/ajax', array(
            'errors' => $this->updateErrors( $sslConfig, $errors ),
            'success' => $sucess
        ));
    }
    public function actionDeleteServer()
	{
        $this->ajaxOnly();
        
        $errors = array();
        
        $serverCertificates = new ServerCertificates;
        
        $serverCertificates->setScenario( 'delete' );
        $serverCertificates->uid = Yii::app()->request->getParam("uid");
        $sucess = $serverCertificates->delete( );
        
        $data = $serverCertificates->getCertificatesList( );
        
        $this->render('/layouts/ajax', array(
            'errors' => $this->updateErrors( $serverCertificates, $errors ),
            'success' => $sucess,
            'data' => $data
        ));
         
    }
    public function actionActivate()
	{
        $this->ajaxOnly();
        
        $errors = array();
        
        $serverCertificates = new ServerCertificates;
        $serverCertificates->setScenario( 'activate' );
        
        $serverCertificates->uid = Yii::app()->request->getParam("uid");
        $sucess = $serverCertificates->activate( );
        
        $data = $serverCertificates->getCertificatesList( );
                
        $this->render('/layouts/ajax', array(
            'errors' => $this->updateErrors( $serverCertificates, $errors ),
            'success' => $sucess,
            'data' => $data
        ));
    }
    public function actionView( $target )
	{
        $sslConfig = new SSLConfig;
        $sslConfig->scenario = 'dump';
        $sslConfig->target = $target;
        if ( !$sslConfig->dump() ){
            $this->redirect( array( '#' => "HTTPS") );
        }
        
    }
    public function actionViewServer( $target )
	{
        $serverCertificates = new ServerCertificates;
                
        if ( !$serverCertificates->dump( $target ) ){
            $this->redirect( array( '#' => "ServerCertificates") );
        }        
    }
    
}