<?php

/**

 */
class External extends Resource
{
    protected $externalFile = "source.json";
    
    protected $_sourceHref = null;
    protected $_sourceFullPath = null;
    
    protected $previewLastModified =0;
    
	/**
	 * @return array validation rules for model attributes.
	 */
	public function rules()
	{
		$rules = parent::rules();
        $rules[] = array('href', 'SimpleURLValidator', 'validSchemes'=>array('spx','http','https'));
        $rules[] = array('sourceHref', 'SimpleURLValidator', 'validSchemes'=>array('spx','http','https'));
        $rules[] = array('sourceFullPath', 'safe');
        return $rules;
	}

	/**
	 * @return array customized attribute labels (name=>label)
	 */
	public function attributeLabels()
	{
		return array(
			'id' => 'id',
			'name' => 'name',
			'href' => 'uri',
		);
	}
    public function init(){
        parent::init();
        $this->type = "external"; 
    }
    public function defaultScope(){
        return array(
            'condition'=>"type='external'",
        );
    }
    
    public function gethref() {
        return $this->sourceHref;
    }
    
    public function getListDesc( $preview=true ) {
        $description = array(
            'id' => $this->id,
            'name' => $this->name,
            'type' => $this->type,
            'href' => $this->href,
            'manage' => $this->manage,
            'modified' => $this->modified,
            'keywords' => $this->keywords
        );        
        if (  $preview ) {
            $previews = $this->previews;
            if ( $previews === false ){
                $description['hidden'] = true;
            } else {
                if ( count( $previews ) )
                    $description['previews'] = $previews;
            }
        }
        return $description;
    }
    public function getDesc( $parents = true, $short = false ) {
        $description = $this->getListDesc( !$short );   
        $description[ 'sourceHref' ] = $this->sourceHref;
        $description[ 'sourceFullPath' ] = $this->sourceFullPath;
        if ( $parents ) {
            foreach ( $this->parents as $parent ){
                $description['parents'][] = $parent->getListDesc( false );
            }
        }
        return $description;
    }
    public function getPreviews() {
        $where = $this->getFolder() ;
        // generate the previews each time, and force it when they don't exist, we generate them now
        if ( !$this->generatePreviews( $where, file_exists( $where . "previews/" ) )) {
            return false;
        }
        
        return parent::getPreviews();
    }
    public function fixRights() {      
        if( PHP_OS == "WINNT" ){
            return;
        }
        $user = posix_getpwnam('www-data'); // firmware 4.0
        if ( !$user)
            $user = posix_getpwnam('www'); // firmware 3.x
        if ( $user ) {
            $folder = $this->getFolder();
            chown( $folder, $user['name'] );
            chgrp( $folder, $user['gid'] );
            
            $file = $folder.$this->externalFile;
            if ( file_exists( $file ) ){
                chown( $file, $user['name'] );
                chgrp( $file, $user['gid'] );            
            }
        }
    }
    public function clearPreviews(){
        $this->previewLastModified = 0;
        $where = $this->getFolder();
        $path = $where."previews/";
        if (file_exists($path) ){
            GlobalSettings::rrmdir( $path, true );
        }
    }        
    public function generatePreviews( $where, $getOnly = false ) {
        // only generate previews, if the previews are not up to date
        
        if ( $this->delayPreview ){
            return true;
        }
        
        
        $source = $this->getSourceFullPath();
        $pos = strrpos( $source, "/" );
        $sourcePath = substr($source, 0, $pos );
        $sourceFile = substr($source, $pos+1 );
        
        if ( substr( $source,0,4 ) === 'http' ){
            if ( $getOnly ){
                return true;
            }
            stream_context_set_default(
                array( 'http' => array( 'method' => 'HEAD' ) )
            );
            $headers = get_headers( $source ,1 );
            if ( isset( $headers['Last-Modified']) ){                     
                $previewLastModified = strtotime( $headers['Last-Modified'] );
                if ( $previewLastModified <= $this->previewLastModified ){                    
                    return true;
                }                
            }            
        } else {
            if ( !file_exists($source) ){
                return false;
            }
            $previewLastModified = filemtime( $source );
            if ( $previewLastModified <= $this->previewLastModified ){
                return true;
            }
        }
        
        // clear up the preview folder and create it
        $path = $where."previews/";
        if (file_exists($path) )
            GlobalSettings::rrmdir( $path, false );            
        else
            mkdir( $path );
        
        
        $exe="cd /srv/raperca && raperca";
        if( PHP_OS == "WINNT" ){
            $exe = "C:\\SpinetiX\\sources\\genesis\\trunk\\user\\hmd\\bin_d\\raperca.exe";
            if ( !file_exists( $exe ) ){
                $exe = "\"C:\\Program Files (x86)\\SpinetiX\\Elementi\\Elementi\\bin\\raperca.exe\"";
            }
        } else  if (file_exists('/opt/sysroot/usr/local/lib/liblive555.so.0')) {
            // this is a Bonsai/Sakura system hacked as Ikebana, need special LD_LIBRARY_PATH
            $exe = "cd /srv/raperca && LD_LIBRARY_PATH=/opt/sysroot/lib:/opt/sysroot/usr/lib:/opt/sysroot/usr/local/lib raperca";
        }
        
        $cmd = "$exe -preview -s 960x960 -pm 1 -d " . escapeshellarg($sourcePath) . " -t " . escapeshellarg("${path}preview.png") . " " . escapeshellarg($sourceFile) . " 2>&1";
        Yii::log($cmd, 'info', 'spx.preview');
        $output = array();
        $ret = -1;
        exec( $cmd, $output, $ret );
        if ( $ret !== 0 && PHP_OS == "WINNT" ) {
            $img = imagecreatetruecolor(480, 480);
            $textcolor = imagecolorallocate($img, 255, 255, 255);
            imagestring( $img, 5, 10, 480/4, $this->name, $textcolor);            
            imagepng( $img, $path."preview.png");
            $ret = 0;
        }
        if ( $ret==0 ) {
            $info = getimagesize( $path."preview.png" );
            $width = $info[0];
            $height = $info[1];
            $dimension = "{$width}x{$height}";            
            @rename( $path."preview.png", $path."preview_$dimension.png");
            
            // create smaller images
            while ( $width>100 && $height>50 ){
                $width = round( $width/2 );
                $height = round( $height/2 );
                $this->previewsImage( $width."x".$height, $path, $path, "preview_$dimension.png" );            
            }                     
        } 

        $this->previewLastModified = $previewLastModified;
        if ( $getOnly ){
            $this->delayPreview =  true;
            $this->save( );
        }   
        return true;
    }
    
    public function getSourceFullPath() {
        if ( $this->_sourceFullPath === null ){
            
            $this->loadSource( );
        }
        return  $this->_sourceFullPath;
    }
    public function setSourceFullPath( $href) {
        $this->_sourceFullPath = $href;
    }
    
    public function getSourceHref() {
        if ( $this->_sourceHref === null ){            
            $this->loadSource( );
        }
        return  $this->_sourceHref;
    }
    public function setSourceHref( $href) {
        $this->_sourceHref = $href;
    }
    public function loadSource( ) {
        $path = $path = $this->getFolder();
        if ( !file_exists( $path . $this->externalFile )){
            return;
        }
        $file = file_get_contents( $path . $this->externalFile );
        $data = json_decode($file, true);
        if ( $data && isset( $data['href'] ) ){
            $this->_sourceHref = $data['href'];
        }
        if ( $data && isset( $data['previewLastModified'] ) ){
            $this->previewLastModified = $data['previewLastModified'];
        }
        if ( $data && isset( $data['path'] ) ){
            $this->_sourceFullPath = $data['path'];
        } else {
            $this->_sourceFullPath = $this->_sourceHref;
        }
    }
    public function saveSource( $path ) {
        $data = array( 
            'href' => $this->_sourceHref,
            'previewLastModified' => $this->previewLastModified
        );
        if ( $this->_sourceFullPath && $this->_sourceFullPath != $this->_sourceHref ){
            $data['path'] = $this->_sourceFullPath;
        }
        $file = json_encode( $data );
        return file_put_contents( $path . $this->externalFile, $file ); 
    }
    
    public function recover( $file = null ){
        
        $path = $this->getFolder();
        $externalFilename = $path . $this->externalFile;            
        return parent::recover($externalFilename);
    }
    
    public function afterSave(){
        
        parent::afterSave();
        $path = $this->getFolder();
        if ( !$path )
            throw new Exception( "path not found" );        
        $this->generatePreviews( $path );
        $this->saveSource( $path );
    }
    
    /**
	 * Retrieves a list of models based on the current search/filter conditions.
	 *
	 * Typical usecase:
	 * - Initialize the model fields with values from filter form.
	 * - Execute this method to get CActiveDataProvider instance which will filter
	 * models according to data in model fields.
	 * - Pass data provider to CGridView, CListView or any similar widget.
	 *
	 * @return CActiveDataProvider the data provider that can return the models
	 * based on the search/filter conditions.
	 */
	public function search()
	{
		// @todo Please modify the following code to remove attributes that should not be searched.

		$criteria=new CDbCriteria;

		$criteria->compare('id',$this->id);
		$criteria->compare('name',$this->name,true);
		
		return new CActiveDataProvider($this, array(
			'criteria'=>$criteria,
		));
	}

	/**
	 * Returns the static model of the specified AR class.
	 * Please note that you should have this exact method in all your CActiveRecord descendants!
	 * @param string $className active record class name.
	 * @return Playout the static model class
	 */
	public static function model($className=__CLASS__)
	{
		return parent::model($className);
	}
}

