#!/bin/sh
#
# License: Copyright 2019 SpinetiX. This file is licensed
#          under the terms of the GNU General Public License version 2.
#          This program is licensed "as is" without any warranty of any
#          kind, whether express or implied.
#
# Copyright 1999-2003 MontaVista Software, Inc.
# Copyright 2002, 2003, 2004 Sony Corporation
# Copyright 2002, 2003, 2004 Matsushita Electric Industrial Co., Ltd.
#
### BEGIN INIT INFO
# Required-Start: udev
# Required-Stop:
# Should-Start:
# Should-Stop:
# Default-Start: 2 3 5
# Default-Stop:
# Short-Description: Updates fontconfig caches
# Description: Updates fontconfig caches
### END INIT INFO

# Init script information
NAME=fc-cache
DESC="fc-cache"

# Source main resources
[ -f /usr/share/resources/default/init/main ] && . /usr/share/resources/default/init/main

case "$1" in
    start|restart)
	echo -n "$DESC: "

	# If we have rebooted a couple of times cleanup the font cache
	# just in case the reboots are due to a corrupt font cache
        if type -t bootcount > /dev/null; then
            BOOTCOUNT="$(bootcount read)"
        else
            BOOTCOUNT=0
        fi
        BCNTLIM=3

        [ -n "$rc_bootcount_lim_offset" ] && \
            [ "$rc_bootcount_lim_offset" -gt 0 ] && \
            BCNTLIM=$(( BCNTLIM + rc_bootcount_lim_offset ))

        if [ "${BOOTCOUNT:-10}" -ge $BCNTLIM ]; then
	    find /var/cache/fontconfig -mindepth 1 -delete
	else
	    # this version of fontconfig uses cache-7 files, remove all others
	    find /var/cache/fontconfig -name "*.cache-*" \! -name "*.cache-7" -delete
	fi

	fc-cache -s
	RET=$?
	if [ $RET -ne 0 ]; then
	    echo " failed ($RET)."
	else
	    echo "."
	fi
	;;
    stop)
	;;
esac
