<?php

class FsmController extends ControlCenterController
{
    public $defaultAction = 'backup';
    
    public function actionAdd()
	{
        $this->ajaxOnly(); 
        $errors = array();
        $data = null;
        
        $serialConfig = new SerialConfig;
        $serialConfig->load();
        
        $serialConfig->setScenario('upload');
        if ( isset( $_FILES['SerialConfig'] ) ) {
            if ( $serialConfig->validate() ){
                $data = $serialConfig->saveFsm( CUploadedFile::getInstance($serialConfig, 'uploadedfile') );                
            }
        } else {
            $errors[] = "No file provided";            
        }
        
        $this->render('/layouts/ajax', array(
            'errors' => $this->updateErrors( $serialConfig, $errors ),
            'data' => $data
        )); 
    }
    public function actionDelete( )
	{
        $this->ajaxOnly(); 
        $errors = array();
        
        $serialConfig = new SerialConfig;
        $serialConfig->load();
        
        if ( isset( $_POST['target'] ) ) {
            $target = $_POST['target'];
            $serialConfig->setScenario('delete');
            $serialConfig->target = "usr/$target.fsm";
            if ( $serialConfig->validate() )
                $serialConfig->delete();            
        } else {
            $errors[] = "No data provided";            
        }
        $this->render('/layouts/ajax', array(
            'errors' => $this->updateErrors( $serialConfig, $errors ),
        )); 
        
    }
    public function actionView( $target, $system = false )
	{
        $serialConfig = new SerialConfig;
        $serialConfig->setScenario('dump');
        if ( $system )
            $serialConfig->target = "sys/$target.fsm";
        else
            $serialConfig->target = "usr/$target.fsm";
        if ( $serialConfig->validate() )
            $serialConfig->dump();
        else {
            $this->redirect( array('fsm') );
        }
    }
}