<?php
/* @var $this ConfigController */

$formConfig = $this->beginWidget('SimpleForm', array( 
    'title' => "IP Configuration",
    'id' => "IP",
    'button' => "Apply",
    'action' => array ( 'post' => array() )
) );
    $data = array(
        array( 'label'=>"IP", 'value' =>  $basicInfo->getIp() ),
        array( 'label'=>"IPv6", 'value' =>  $basicInfo->getIpv6() ),
        array( 'label'=>"Hostname", 'value' =>  $basicInfo->getHostname() .".local" )
    );
    echo BsHtml::alert( BsHtml::ALERT_COLOR_INFO, $this->widget('DataTable', array( 'data' => $data, 'title' => "Current Settings" ), true ) );
    
    $formConfig->errorSummary( $ipConfig );
    
    if ( Yii::app()->branding->hasRight('WIFI') ) {
        echo $formConfig->activeDropDownList( $ipConfig, "netiface", 
                $ipConfig->getNetifaceSelect()
        );     
    }
    
    $modes = array(
                "1"=>"DHCP",
                "0"=>"Static IP"
            );
    
    echo $formConfig->activeDropDownList( $ipConfig, "dhcp", $modes, array(), 
        true
    );
    
    $options = array(
        'placeholder' => "xxx.xxx.xxx.xxx"
    );
    echo CHtml::openTag("div", array( 'data-bind' => "if: dhcp() == '0'") );
        echo $formConfig->activeTextField( $ipConfig, "address", $options );
        echo $formConfig->activeTextField( $ipConfig, "netmask", $options);
        echo $formConfig->activeTextField( $ipConfig, "gateway", $options);            
    echo CHtml::closeTag("div");
    
    
    echo $formConfig->activeDropDownList( $ipConfig, "ipv6Configuration", 
        $ipConfig->ipv6ConfigurationOption, array(), true        
    );
    echo CHtml::openTag("div", array( 'data-bind' => "if: ipv6Configuration() == 'static'") );    
        echo $formConfig->activeTextField( $ipConfig, "ipv6Address", $options );
        echo $formConfig->activeTextField( $ipConfig, "ipv6Netmask", $options);
        echo $formConfig->activeTextField( $ipConfig, "ipv6Gateway", $options); 
    echo CHtml::closeTag("div") ."\n";
       
    echo $formConfig->activeDropDownList( $ipConfig, "dnsConfiguration", 
        array(
            "automatic" => "Automatic",
            "manual" => "Manual"
        ), array(), true        
    );
    echo CHtml::openTag("div", array( 'data-bind' => "if: dnsConfiguration() == 'manual'") );    
        echo $formConfig->activeTextField( $ipConfig, "nameserver1", $options);
        echo $formConfig->activeTextField( $ipConfig, "nameserver2", $options);
        echo $formConfig->activeTextField( $ipConfig, "nameserver3", $options);
        echo $formConfig->activeTextField( $ipConfig, "domain");
    echo CHtml::closeTag("div") ."\n";
    
    
    echo $formConfig->activeCheckBox( $ipConfig, "disableSLAAC"  ); 
    
$this->endWidget();
