#
# spxmanage configuration file for the content vhost
#
# this file is included from the <VirtualHost> declarations for the
# content virtual host
#

DocumentRoot /srv/raperca/content

# Unconditionally set the which_vhost environment variable
# so that other config files can do per-vhost conditional
# processing reliably (SetEnv cannot be used because it
# occurs late in request processing)
SetEnvIf Request_URI ^ which_vhost=content

<IfDefine LicenseType>
Header set X-spinetix-license ${LicenseType}
</IfDefine>

# We make use of RewriteRule, make sure it is enabled.
RewriteEngine on

# Add a rule to redirect all non-local plain HTTP accesses to HTTPS if
# configured and SSL is enabled and neither non-SSL nor SSL ports are
# limited to localhost.
<IfDefine NOSSL_REDIRECT>
    <IfDefine SSL>
        <IfDefine !NOSSL_LOCALHOST_ONLY>
            <IfDefine !SSL_LOCALHOST_ONLY>
                RewriteCond %{HTTPS} !=on
                RewriteCond %{SERVER_ADDR} !=127.0.0.1
                RewriteCond %{SERVER_ADDR} !=::1
                RewriteRule ^ https://${SSL_SUBJECT_NAME}:9802%{REQUEST_URI} [NS,R,L]
            </IfDefine>
        </IfDefine>
    </IfDefine>
</IfDefine>

# Only allow LOCK requests on files and forbid all others to
# avoid getting locks on WebDAV collections (directly or via lock-null
# resources). This allows normal clients that require locking to work
# (e.g., Windows Vista and 7 which first create an empty resource and then
# lock it before putting the real content) but avoids the memory issues
# related with locks on collections and the resulting indirect locks on
# a very large number of files. Note that %{REQUEST_FILENAME} is not
# available at this stage, but we know the mapping of URI to file path.
RewriteCond %{REQUEST_METHOD} =LOCK
RewriteCond /srv/raperca/content%{REQUEST_URI} !-f
RewriteRule ^ - [F]

# Allow all rewrites from the main server definition to apply
# to this pseudo-virtual server
RewriteOptions Inherit

# Under this virtual host no PHP execution allowed
AddType text/plain .php
RemoveHandler .php

# Override the DAV lock DB to use our own
DavLockDB /var/cache/spxmanage/dav/lockdb

# Enable keep-alive connections here since the
# drawbacks usually do not affect content access
# but keep-alive should benefit publishing speed
KeepAlive On

# Use separate logs (ending the name in "log" make them
# to be handled by apache's logrotate config)
ErrorLog /var/log/apache2/content-error_log
CustomLog /var/log/apache2/content-access_log common_extended
