<?php

if( PHP_OS == "WINNT" ) {
    $yii=dirname(__FILE__).'/../../../framework/yii.php';
} else {
    $yii='yii-framework/yii.php';
}
require_once($yii);

include_once( __DIR__.'/../components/MyConsoleApplication.php' );

function runYiic( $_argv, $script, $admin = true ){
    $_SERVER['argv'] = $argv = $_argv; 
    $_SERVER['SCRIPT_FILENAME'] = $script;
    $pid = pcntl_fork();
    if ($pid == -1) {
         die('could not fork');
    } else if ($pid) {
         // we are the parent
         $status = null;
         pcntl_wait($status); //Protect against Zombie children
         $exitCode = 1;
         if ( pcntl_wifexited($status) ){
             $exitCode =  pcntl_wexitstatus ( $status );
             syslog(LOG_NOTICE, 'Child exited with exit code '.$exitCode );
         } else if ( pcntl_wifsignaled($status) ){
             $signal =  pcntl_wtermsig ( $status );
             syslog(LOG_NOTICE, 'Child exited with signal '.$signal );
             $exitCode = 128 + $signal;
         } else {
             trigger_error("runYiic: pcntl_wait() unknown status", E_USER_WARNING);
         }
         return $exitCode;
    } else {
         // we are the child
        if ( !$admin ){
            $user = posix_getpwnam('www-data'); // firmware 4.0
            if ( !$user)
                $user = posix_getpwnam('www'); // firmware 3.x
            if ( !$user ){
                trigger_error("runYiic: posix_getpwnam() failed", E_USER_WARNING);
                exit( 1 );
            }
            if ( !posix_setgid ( $user['gid'] ) ){
                trigger_error("runYiic: posix_setgid() failed", E_USER_WARNING);
                exit( 1 );
            }
            if ( !posix_setuid ( $user['uid'] ) ){
                trigger_error("runYiic: posix_setuid() failed", E_USER_WARNING);
                exit( 1 );
            }
        }
        $app = Yii::createApplication( 'MyConsoleApplication', dirname(__FILE__).'/../config/console.php' );
        $app->commandRunner->addCommands(YII_PATH.'/cli/commands');
        $app->run();
    }
}
