<?php
/* @var $this ConfigController */

$formConfig = $this->beginWidget('SimpleForm', array( 
    'title' => "Saved Passwords",
    'button' => "Apply",
    'id' => 'SavedPasswords',
    'action' => array ( 'post' => array() )
) );
    $formConfig->errorSummary( $credentialsConfig );
    foreach ($credentialsConfig->credits as $i => $credential ){
        $formConfig->errorSummary( $credential );
    }
    
    $c = new Credentials;
    $headers = array( 
        $c->getAttributeLabel( "href"),
        $c->getAttributeLabel( "username"),
        $c->getAttributeLabel( "password"),
        $c->getAttributeLabel( "realm"), 
        ""
        
    );
    $options = array(
        "data-bind" => "foreach: credentials",
        "sizes" => array( "col-xs-5", "col-xs-2", "col-xs-2", "col-xs-2", "col-xs-1" )
    );
    $row = array();
    $row[] = CHtml::textField( "", "", $formConfig->itemOptions( array(
        "data-bind" => "value: href, attr: { name: 'Credentials['+\$index()+'][href]'}",
        'placeholder' => "http://SomeServer/SomePath/"
    ) ) );
    $row[] = CHtml::textField( "", "", $formConfig->itemOptions( array(
        "data-bind" => "value: username, attr: { name: 'Credentials['+\$index()+'][username]'}"
    ) ) );
    $row[] = CHtml::passwordField( "", "", $formConfig->itemOptions( array(
        "data-bind" => "value: password, attr: { name: 'Credentials['+\$index()+'][password]'}"
    ) ) ) . CHtml::hiddenField("", "", $formConfig->itemOptions( array(
        "data-bind" => "value: idx, attr: { name: 'Credentials['+\$index()+'][idx]'}"
    ) ) );
    $row[] = CHtml::textField( "", "", $formConfig->itemOptions( array(
        "data-bind" => "value: realm, attr: { name: 'Credentials['+\$index()+'][realm]'}"
    ) ) );
    $row[] = CHtml::link( CHtml::tag("i", array( "class" => "fa fa-times"), "" ), "#", array(
        "data-bind" => "click: \$parent.removeCrendential, css: { disabled: \$parent.credentials().length === 1 && obs === true && href() === '' && username() == '' && password() == '' && realm() == ''}",
        "class" => "btn btn-sm btn-warning btn-block"
    ) );
    $this->widget('BsRow', array( 
        'options' => array( 'class' => 'table-responsive'),            
        'content' => $formConfig->table( $headers, array( $row ), $options, array(), array( "data-bind" => "css: { \"has-error\": hasError }") ) 
    ));
    $this->widget('BsRow', array( 'cols' => array( 
        array( 'sizes' => array( 'sm' => 6, 'md' => 5 ), 
            'offsets' => array( 'sm' => 6, 'md' => 0 ),
            'content' => CHtml::link( "Add", "#", array(
                            "data-bind" => "click: addCrendential",
                            "class" => "btn btn-sm btn-default btn-block"
                        ))
            )
    )));
$this->endWidget();


?>
<script type="text/javascript" >
//<![CDATA[
yiiModel.credentials = ko.observableArray( <?php
    $credentials = array();
    foreach ($credentialsConfig->credits as $i => $credential ){
        $credentials[] = array(
            "href" => $credential->href,
            "username" => $credential->username,
            "password" => $credential->hasErrors()?$credential->password:CredentialsConfig::$setPasswords,
            "realm" => $credential->realm, 
            "idx" => $credential->idx, 
            "hasError" => $credential->hasErrors(),            
            "obs" => false
        );
    }
    $credentials[] = array(
        "href" => "js:ko.observable('')",
        "username" => "js:ko.observable('')",
        "password" => "js:ko.observable('')",
        "realm" => "js:ko.observable('')",          
        "idx" => "js:ko.observable('')",  
        "hasError" => "js:ko.observable(false)",
        "obs" => true
    );
    echo CJavaScript::encode( $credentials );
?> );
yiiModel.removeCrendential = function() {
    if ( yiiModel.credentials().length > 1 ){
        yiiModel.credentials.remove(this);
    } else {
        yiiModel.credentials( [ {
            href: ko.observable(''),
            username: ko.observable(''),
            password: ko.observable(''),
            realm: ko.observable(''),
            idx: ko.observable(''),
            hasError: ko.observable(false),
            obs: true
        } ] );
    }    
};
yiiModel.addCrendential = function() {
    
    yiiModel.credentials.push({
        href: ko.observable(''),
        username: ko.observable(''),
        password: ko.observable(''),
        realm: ko.observable(''),
        idx: ko.observable(''),
        hasError: ko.observable(false),
        obs: true
    });
};
//]]></script>