<?php


class OperationController extends ControlCenterController
{
    public function accessRules()
    {
        $rules = array(            
            array('allow',
                'actions' => array( 'checkNetwork' ),
                'roles'=>array('viewLogs'),
            )
        );
        
        return array_merge( $rules, parent::accessRules() ); ;
    }
    public function init(){
        parent::init();
        $this->breadcrumbs['Operation'] = "";
    }
    
    public function actionHttpPublish(  )
    {
        $this->ajaxOnly(); 
        $data = null;
        $errors = array();
        $syncSource = new SyncSource;  
        if ( !isset($_POST['action']) ){
            $errors[] = "Action unknown";
        } else {
            $action = $_POST['action'];
            if ( $action == 'publish' && isset($_POST['uri']) ){
                $syncSource->setAttributes( $_POST );
                if ( $syncSource->validate() )
                    $data = $syncSource->publish( );                        
            } else if ( $action == 'status' ){
                if ( !isset($_POST['id']) )
                    $errors[] = "Missing id";
                else {
                    $data = $syncSource->publishStatus( $_POST['id'] );
                }
            } else {
                $errors[] = "Action unknown";
            }
        }
        $this->render('/layouts/ajax', array(
            'errors' => $this->updateErrors($syncSource, $errors),
            'data' => $data
        ));
    }
    
    public function actionReport()
	{        
        $maintenance = new Maintenance;
        $maintenance->getReportFile( Yii::app()->request->getParam('extended', false) );
	}
    
    public function actionArya($enable = true)
	{
        $this->ajaxOnly();

        $maintenance = new Maintenance;

        $ARYAMode = new ARYAMode;
        $ARYAMode->resetArya($enable ? true : null);

        $maintenance->forcedReboot();

        if ($enable){
            Tools::$redirect = "https://arya.spinetix.cloud/setup/" . $this->serial ;
        }

        $this->render('/layouts/ajax', array( 
            'reboot' => Tools::checkReboot(),
            'data' => array( 
                'sucess' => true
            )
        ));

    }
    public function actionReboot()
	{
        $this->ajaxOnly();        
        
        $maintenance = new Maintenance;        
        if ( Yii::app()->request->getParam('reboot') )
            $maintenance->forcedReboot();
        if ( Yii::app()->request->getParam('rebootrecovery') )
            $maintenance->forcedReboot( true);
        if ( Yii::app()->request->getParam('shutdown') )
            $maintenance->shutdown();
        
        $this->render('/layouts/ajax', array( 
            'reboot' => Tools::checkReboot(),
            'data' => array( 
                'recoveryMode' => Tools::checkRecoveryMode(),
                'shutdown' => Tools::checkShutdown(),                
            )
        ));
    }
    public function actionRemoteSupport()
	{      

        $this->ajaxOnly();
        
        $maintenance = new Maintenance;   
        $maintenance->manageSSH( Yii::app()->request->getParam('enable', 'stop')=='start' );
        
        $this->render('/layouts/ajax', array( 
            'data' => array( 'enabled' => $maintenance->checkSSH() )
        ));        
    }
    
    public function actionReset()
	{      

        $this->ajaxOnly();
        
        $messages = array();
        $errors = array();
        $maintenance = new Maintenance;
        $targets = Yii::app()->request->getParam('targets');
        foreach ( $targets as $target ){
            if ( $target == 'content' ){
                $maintenance->resetContent( ); 
                $messages[] = "Default content restored";
            } else if ( $target == 'logs' ){
                $maintenance->clearLogs( ); 
                $messages[] = "Log cleared";
            } else if ( $target == 'cache' )
                $maintenance->clearCache( );
            else if ( $target == 'ntp' )
                $maintenance->clearNtp( );
            else if ( $target == 'streaming' )
                $maintenance->clearStreaming( );
            else if ( $target == 'factory' )
                $maintenance->resetFactory( );
            else if ( $target == 'storage' )
                $maintenance->formatStorage( );
            else if ( $target == 'splash' ){
                $splashScreen = new SplashScreen;
                $splashScreen->reset();
                $errors = $this->updateErrors( $splashScreen, $errors );
                $messages[] = "Splash screen cleared";
            } else if ( $target == 'calibration' ) {
                $touchCalibration = new TouchCalibration;
                $touchCalibration->reset();
                if ( $touchCalibration->validate() )
                    $touchCalibration->save();      
                $errors = $this->updateErrors( $touchCalibration, $errors );
                $messages[] = "Touchscreen calibration cleared";
            } else if ( $target == 'webstorage' ) {
                $webstorage = new WebStorage;
                $webstorage->clear( ); 
                $errors = $this->updateErrors( $webstorage, $errors );
            } else if ( $target == 'firmware' ) {
                $firmwareUpdate = new FirmwareUpdate;
                $firmwareUpdate->resetUri( ); 
                $errors = $this->updateErrors( $firmwareUpdate, $errors );
                // need to reload the page
                Tools::$redirect = array('main/operations', '#' => 'Reset');
            } else if ( $target == 'webPageData' ) {
                $maintenance->clearWebPageData( );
            } else 
                $errors[] = "command not found: $target";
        }
        $this->render('/layouts/ajax', array(
            'errors' => $this->updateErrors( $maintenance, $errors ),
            'messages' => $messages
        ));        
    }
        
    public function actionCheckNetwork()
	{
		if ( !Yii::app()->request->isAjaxRequest )
			throw new CHttpException(403 , "Direct access not allowed");
		
		$net = new IPCheck();
		
		$ret = $net->ping();
			
		if ( $ret==0 ) {
			echo json_encode( array( 'success'=>true ) );
		} else {
			echo json_encode( array( 'success'=>false,
									 'code' => $ret,
                                     'reason' => $net->codes[$ret],
									 'details' => $net->phrase)
							);
		}
	}
    var $calibrationUsername = "spx-calibration-auto-user";
    
    protected function createUser( ) {
        $errors = array();
        
        $user = new User();
        $username = "spx-calibration-auto-user";
        $password = "pass-".uniqid();
        $user->attributes = array(
            "username" => $this->calibrationUsername,
            "password" => $password,
            "verifyPassword" => $password
        );
        $user->lowSecurityPassword = true;
        if ( !$user->save() ){
            return $this->updateErrors( $user, $errors );
        }
        
        $user->userRights->attributes = array( "admin" => true );
        if ( !$user->userRights->save() ){
            $errors = $this->updateErrors( $user->userRights, $errors );
            $user->delete();
            return $errors;
        }
        if ( !$user->updateHttpdSecurity() ) {
            $errors = $this->updateErrors( $user, $errors );
            $user->delete();
            return $errors;
        }
        
        $credentialsConfig = new CredentialsConfig;
        $credentialsConfig->load();
        
        $credentials = new Credentials;
        $credentials->attributes = array(
            "username" => $this->calibrationUsername,
            "password" => $password,
            "href" => "http://localhost/"
        );
        if ( !$credentials->validate() ){
            $errors = $this->updateErrors( $credentials, $errors );
            $user->delete();
            return $errors;
        }
        $credentialsConfig->addCreditential( $credentials );
        $credentialsConfig->save();
        
        return $errors;
        
    }
    protected function removeUser( ) {
        
        $user = User::model()->findByAttributes( array('username'=>$this->calibrationUsername) );
        if ( !$user ){
            return ; 
        }
        $user->delete();
            
        $credentialsConfig = new CredentialsConfig;
        $credentialsConfig->load();
        foreach ( $credentialsConfig->credits as $idx => $credentials ) {
            if ( $credentials->username === $this->calibrationUsername ){
                unset($credentialsConfig->credits[$idx]);
            }
        }
        $credentialsConfig->save();
        return ; 
    }
    public function actionCalibration() {

        $this->ajaxOnly();
        $errors = array();
        $messages = array();
        
        $touchCalibration = new TouchCalibration;
        
        if ( Yii::app()->request->getParam('start') ){
            $this->createUser();
            $touchCalibration->startCalibration();               
        }
        if ( Yii::app()->request->getParam('stop') ){
            $this->removeUser();
            $touchCalibration->stopCalibration();                        
        }
        $this->render('/layouts/ajax', array(
            'errors' => $this->updateErrors( $touchCalibration, $errors ),
            "data" => $touchCalibration->isCalibrationOn(),
            "messages" => $messages
        ));        
    }
    
    public function actionSplashUpdate()
	{
        $this->ajaxOnly(); 
        $errors = array();
        
        $splashScreen = new SplashScreen;
        $uri = (object)array();
        if ( isset($_FILES['SplashScreen']) ) {
            $splashScreen->setScenario( 'setsplash'  );            
            foreach ( $splashScreen->filenicename as $attribute=>$name ){
                $file = CUploadedFile::getInstance( $splashScreen, $attribute );
                if ( $file ) {
                    $splashScreen->$attribute = $file;
                    break;
                }
            }            
            if ( $splashScreen->validate() ) {                
                $splashScreen->save();
                $link = $attribute. "_link";
                $uri = $splashScreen->$link;
            } 
            
        } else {
            $errors[] = "No file provided";            
        }
        
        $this->render('/layouts/ajax', array(
            'errors' => $this->updateErrors( $splashScreen, $errors ),
            'data' => $uri
        )); 
        
	}    
}