<?php

class ConfigCommand extends CConsoleCommand {

	var $defaultAction = 'restore';

	public function getHelp() {
		return <<<EOD
USAGE
  yiic config <action> [arguments]

DESCRIPTION
  Operates on the system configuration.

ACTIONS
  restore [options] <file>
    Restores a configuration backup from a file.
    The following options are accepted.
      --rebootDelay=<minutes>
        The delay to apply to the reboot if the configuration file has
        a reboot action. Default is zero (i.e. immediate reboot).
        A negative value disables the shutdown.

EOD;
	}
	public function actionRestore( $rebootDelay=0, $args=array() ) {

		if ( ! is_numeric($rebootDelay) ) {
			echo "rebootDelay must be a non-negative integer number\n";
			return 1;
		}
		$rebootDelay = intval($rebootDelay);
		
		if ( count( $args ) != 1 ) {
			echo "must pass configuration backup file as the only non-option argument\n";
			return 1;
		}
		$file = $args[0];
		if ( ! is_file( $file ) ) {
			echo "file '$file' does not exist or is not a file\n";
			return 1;
		}

		$configBackup = new ConfigBackup;
		if ( $rebootDelay != 0 ) {
			$configBackup->shutdownDelay = $rebootDelay;
		}
		$configBackup->applyBackupFile( $file );
		if ( $configBackup->hasErrors() ) {
			foreach ( $configBackup->errors as $attr => $desc ) {
				foreach ($desc as $d) {
					Yii::log("$attr: $d", 'error', 'spx.config');
				}
			}
			return 1;
		}

		return 0;
	}

}