<?php
/* @var $this MainController */

$this->breadcrumbs[] = $this->title = 'Media'; 

$this->registerSpxScript( 'resources.js' );


$this->beginWidget('AssetsList', array(
    'useDropZone' => true,
    'model' => 'mediaList',
    'resources' => "['media']"    
)); 
$this->endWidget();

$this->topBar .= $this->iconSet( array(
        array(  'icon'=> 'upload', 
                'class' => "fileinput-button",
                'title' => I18N::t('Upload'), 
                'html' => '<input type="file" name="media" data-bind="jQueryFileupload: addMediaFile, args: {url: spxapi.media.uri} " /> ')
    ),
    array( 
        "class" => "pull-right"
    )
);


?>

<script type="text/javascript" >
//<![CDATA[
mediaList.editLinkTemplate = "<?php echo $this->createUrl("media/edit", array('id'=>"[id]") ); ?>";
mediaList.open = function ( model ) {
    var where = mediaList.editLinkTemplate.replace( "%5Bid%5D", model.id );
    location.href = where;
}
mediaList.addColumn({   
    title: "<?php echo I18N::t("Mime Type");?>", 
    data : "mimeType" 
});
mediaList.addColumn({   
    title: "<?php echo I18N::t("Dimensions");?>", 
    data : "dimension" 
});



ko.applyBindings( mediaList );

//]]></script>