<?php

class Updater {

    static $fileFolder = "/var/tmp/";
    static $pid_file="/var/lock/updater";
    protected static $statusFileName='/var/lib/updater/status';
    protected static $stateFileName='/var/lib/updater/update-state';
    
    protected $logFileName='/var/log/updater/lastlog';
    
    
    var $update_pid=false;
    var $update_id=false;
    
    var $nb_updates = false;
    var $update_info = false;
    var $updater_fallback = false;
    var $updater_mode = "check";
    var $updater_status = false;
    var $applied_on_reboot = false;
    
    var $product;
    var $email;
    
    var $errorStr="";
    
    function startUpdate( $checkOnly=true, $source="", $max_wait_time=-1, $block=false, $test=false ) {
    
        $opts = "";
        if ( !$block ) $opts .= "-b ";
        if ($checkOnly) $opts .= "-n ";
        if ( $test ) $opts .= "-N ";
        if ( $source=="usb" ) {
            $opts .= '--repo=local-usb ';
            $mount=file_get_contents("/proc/mounts");
            $mounts=explode("\n",$mount);
            $usbContent=false;
            $usbUpdate=false;
            foreach ($mounts as $mount){
                $info=preg_split("/\s/",$mount);
                if (count($info)>2){
                    if ($info[1]=='/srv/raperca/content') $usbContent=true;
                    if ($info[1]=='/var/lib/updater/mnt-usb-updates') $usbUpdate=true;
                }
            }
            if (!$usbUpdate){
                if ($usbContent) $this->errorStr = "USB storage is used as Local Storage.";
                else $this->errorStr = "No USB storage Found.";
                return false;
            }elseif (!file_exists("/var/lib/updater/mnt-usb-updates/repodata")){
                $this->errorStr = "USB storage found but folder <strong>/updates</strong> does not contain update data.";
                return false;
            }
        }
        else if ( $source!="" && $source!="default" )
        	$opts .= "--repo=base " . escapeshellarg("--repo-url=base:$source") . " ";
        
        do {
            $this->update_id = uniqid();
            $updater_log = $this->getLogFileName( $this->update_id );
            $updater_log_file = fopen($updater_log, 'xb');
        } while ($updater_log_file === FALSE);
        //store the running ID in the file
        
        fclose($updater_log_file);
        if ( PHP_OS == "WINNT" ) {
            $str = "/usr/sbin/updater $opts >" . escapeshellarg($updater_log);
        } else {
        	$str = "/usr/sbin/updater --log-to-stderr --lock-timeout=2 " . escapeshellarg("--max-wait-time=$max_wait_time") . " $opts " . escapeshellarg("--log-to=$updater_log") . " 2>&1";
        }
        $updater_out = array();
        $updater_ret = -1;
        exec($str, $updater_out, $updater_ret);
        if ( PHP_OS == "WINNT" ) {
            $updater_out = explode( "\n", file_get_contents($updater_log ) );
        }
        if ( $updater_ret==0 ) {
            // success
            if ( $block ) 
                return true;
            foreach ($updater_out as $line ){
                $matches = array();
                if (preg_match("/---\s+BACKGROUND PID\s+([^-]+)\s+---/", $line, $matches)) {
                    $this->update_pid = $matches[1];
                    $this->errorStr=$str;
                    return true;
                }
            }
            $this->errorStr="Cannot find PID of updater.";
        } else {
			syslog(LOG_NOTICE, "updater failed with error ($updater_ret). command: " . $str);
            if ($updater_ret==1){
                if ( $checkOnly )
                    $this->errorStr="Check for update failed. Please check the logs for more details.";
                else
                    $this->errorStr="Update failed. Please check the logs for more details.";
            } elseif ($updater_ret==2)
	            $this->errorStr="Fatal error during update. ".
								"The ".$this->product." might not be usable anymore. ".
								"Reboot in recovery mode to re-install the firmware from a firmware package. ".
								"Contact support <a href='mailto:".$this->email."' >".$this->email."</a> if you require assistance.";		
            elseif ($updater_ret!=0)
	            $this->errorStr="Failed starting update process. ".
								"The most probable cause is that the device is shutting down. ".
								"Please wait before trying to reload the page to see if this solves the problem. ".
								"Contact support <a href='mailto:".$this->email."' >".$this->email."</a> if you require assistance.";
        }
        if ( file_exists($updater_log) )
            unlink( $updater_log );
        
        return false;
        
    }

    function parseLog( $lines) {
        $matches = array();
        foreach ($lines as $line ) {
            if (strstr($line,"UPDATE(S) ---")){
                $vals=explode(" ",$line);
                if (count($vals)>3) 
                    $this->nb_updates=$vals[2];
            } elseif (preg_match("/---\s+(FIRMWARE|UPDATER)\s+([^-]+)-([^-]+)\s+---/", $line, $matches)) {
                $this->update_info['type'] = $matches[1];
                $this->update_info['ver'] = $matches[2];
                $this->update_info['rel'] = $matches[3];
            } elseif (preg_match("/---\s+RETRY UPDATER ONLY\s+---/", $line)) {
                $this->updater_fallback = true;
            } elseif (preg_match("/---\s+(BACKGROUND PID|MODE|EXIT)\s+([^-]+)\s+---/", $line, $matches)) {
                if ( $matches[1]=="BACKGROUND PID" )
                    $this->update_pid = $matches[2];
                elseif ( $matches[1]=="MODE" )
                    $this->updater_mode = $matches[2];
                else
                    $this->updater_status = $matches[2];
            } elseif (preg_match("/---\s+APPLIED ON REBOOT\s+---/", $line)) {
            	$this->applied_on_reboot = true;
            }
        }

    }
    
    function getLastLog() {
    
        if ( file_exists($this->logFileName) )
            return explode("\n", file_get_contents($this->logFileName) );
        else
            return false;
    }
    
    function getLastLogTime() {
        if ( file_exists($this->logFileName) )
            return filemtime($this->logFileName);
        else 
            return false;
    }
    
    
    function getLog( $id ) {
    
        $this->update_id = $id;
        $name = $this->getLogFileName( $id );
        if ( file_exists($name) ) {
            return explode("\n", file_get_contents($name) );
        } else
            return false;
    }
    
    function cleanUp( $id=false ) {
        if ( $id===false )
            $id = $this->update_id;
        if ( $this->update_pid===false || ($id!=$this->update_id) ) {
            $this->parseLog( $this->getLog( $id ) );
        }
        if ( $this->update_pid===false ) 
            return false;
            
        if ( $this->isUpdateRunning( $this->update_pid ) ) return false; // cannot cleanup
        
        $name = $this->getLogFileName( $id );
        if ( file_exists($name) )
            unlink( $name );

        return true;
    }
    
    function getLogFileName( $id ) {
        return self::$fileFolder."/updater-" . $id . ".log";
    }
    
    function checkPID( $pid ) {
        if ( PHP_OS == "WINNT" ) {
            return false;
        }
        return posix_kill($pid, 0);
    }
    
    static function getStatus() {
        if (file_exists(self::$statusFileName)){
            $status=trim(file_get_contents(self::$statusFileName));
        } else {
            $status = "";
        }
        if ($status=="") $status='READY';
        return $status;
    }
    
    static function isUpdateInProgress() {
        $status = self::getStatus();
        if ( defined('YII_DEBUG') && YII_DEBUG ){
            if ( $status=="DELAYING" )
                return true;
        }
        if ( $status=="UPDATING" || $status=="PKGSDONE" || $status=="REBOOTING" )
            return true;
        return false;
    }

    static function getRunningId( ) {
        
        $pid = self::getRunningPid();
        if ( $pid === false ){
            return false;
        } 
        // find the file
        $folder = "/proc/$pid/fd/" ;
        $names = scandir( $folder );
        foreach ($names as $name) {
            if ( is_link( $folder . $name )){
                $target = readlink( $folder . $name );
                $match = self::$fileFolder."updater-";
                if ( substr( $target, 0, strlen($match) ) == $match ){
                    $start = strlen( $match );
                    $end = strpos($target, ".");
                    return substr( $target, $start, $end-$start );
                }
            }             
        }
        return false;
    }
    static function getRunningPid( $pid=false ) {
        if (isset($_ENV['OS']) && $_ENV['OS']=='Windows_NT') return false;
        
        if ( $pid===false ){
            if ( !file_exists( self::$pid_file ) ){
                return false;
            }
            $pid = file_get_contents( self::$pid_file );
            if ( $pid===false) {
                return false;
            }
            $pid = trim($pid);
        }
        if ( !file_exists( "/proc/$pid/exe" ) ) {
            return false;
        }
        $exec = readlink( "/proc/$pid/exe" );
        if ( $exec===false) {
            return false;
        }
        
        if ( !preg_match("/\/updater\s*[^\/]*$/", $exec) ) {
            return false;
        }
        return $pid;
    }
    
    function isUpdateRunning( $pid=false ) {
    
        $pid = self::getRunningPid( $pid );
        if ( $pid === false ){
            return false;
        } 
        return $this->checkPID( $pid );
    }
    static function getState() {        
        $state = "COMPLETE";
        if ( file_exists( self::$stateFileName ) ) {
            $state = trim( file_get_contents( self::$stateFileName ) );
        }
        if ( $state == "" )
            $state = "COMPLETE";
        return $state;
    }
    function fastNoUpdateCheck() {
        if ( file_exists( self::$stateFileName ) ) {
            $mtime = filemtime( self::$stateFileName );
            $now = time();
            if ( $mtime>$now-3600*24 && $mtime<$now && $this->getState()=="COMPLETE" )
                return true;
        }
        return false;
    }
    function resetState() {
        if ( file_exists( self::$stateFileName ) ) {
            unlink( self::$stateFileName );
        }
    }
}
