<?php
include_once 'protected/utils/MaintenanceJobs.php';

class Iot extends CFormModel {
    public function rules() {
        return array(
            array('enable, enrollDebug, iotDebug', 'boolean'), 
            array('url', 'type', 'type' => 'string'));
    }

    public function save() {
        if ($this->enable !== null) {
            MaintenanceJobs::enableCloudConnection($this->enable);
        }
        if ($this->enrollDebug !== null) {
            MaintenanceJobs::enableCloudDebug($this->enrollDebug);
        }
        if ($this->url !== null) {
            MaintenanceJobs::configureEnrollUrl($this->url);
        }
        if ($this->iotDebug !== null) {
            MaintenanceJobs::enableIoTDebug($this->iotDebug);
        }
    }
    
    public $enable;
    public $enrollDebug;
    public $url;
    public $iotDebug;
}
