<?php

/**
 * Description of GlobalSettings
 */
class GlobalSettings {
    
    // where the file are on the local drive
    static $fileBase = "/srv/raperca/interface/public/";
    // How the player access the local files
    static $hrefBase = "/";
    // How the web interfce access the file
    static $uriBase = "/api/";
    // Link to the management API
    static $manageBase = "/api/";
    
    // Where the system media files are located to be copied
    static $systemMedia = "/usr/share/spxmanage/www/protected/media/";
    
    static function rrmdir( $dir, $delete_root=true ) {
        if ( !file_exists( $dir ) )
            return true;
        if ( is_dir($dir) ) {
            $objects = scandir($dir);
            foreach ($objects as $object) {
                if ($object != "." && $object != "..") {
                    if (filetype($dir . "/" . $object) == "dir"){
                        if ( !self::rrmdir($dir . "/" . $object) )
                            return false;
                    } else{
                        if ( !@unlink($dir . "/" . $object) )
                            return false;
                    }
                }
            }
            if ( $delete_root )
                return @rmdir($dir);
            else
                return true;
        }
    }
    static function rcopy( $src, $dst ) {
        if ( !file_exists( $src ) )
            return false;
        
        if ( is_dir( $src ) ) {
            if ( !file_exists( $dst ) && !@mkdir( $dst ) ){
                echo "mkdir failed $dst\n";
                return false;
            }
            $objects = scandir( $src );
            foreach ($objects as $object) {
                if ($object != "." && $object != "..") {
                    if ( !self::rcopy($src . "/" . $object, $dst. "/" . $object) ){
                        return false;                
                    }
                }
            }
            return true;
        } else {
            return @copy($src, $dst);
        }
    }
}
if( PHP_OS == "WINNT" ) {
    GlobalSettings::$uriBase = "/previews/";
    GlobalSettings::$systemMedia = "protected/media/";    
}