<?php
/* @var $this ConfigController */

$formConfig = $this->beginWidget('SimpleForm', array( 
    'title' => "Power",
    'id' => "Power",
    'button' => "Apply",
    'action' => array ( 'post' => array() )
) );
    $formConfig->errorSummary( $power );    
    if ( !$screenInfo->powersaveSupported ){
        echo BsHtml::alert( 
            BsHtml::ALERT_COLOR_WARNING, 
            $screenInfo->cecSupported ? 
                "Your HDMI display does not support CEC, display power management may not be fully supported.":
                "The selected video output does not support CEC, display power management may not be fully supported.",
            array(  )
        );
    }
    echo $formConfig->activeCheckBox($power, "enablePowerSave", array(), true );
    echo CHtml::openTag("div", array("data-bind" => "if: enablePowerSave()"));
        echo $formConfig->activeDropDownList( $power, "fixedMonPower", 
                    array( "no"=> "None", "daily" => "Fixed", "weekly" => "Daily" ), array( ), true
        );
        echo CHtml::openTag("div", array(
            "data-bind" => "if: fixedMonPower() === 'daily'"
        ));
            echo $formConfig->activeTextField($power, "onTime", array('placeholder' => '08:00') );
            echo $formConfig->activeTextField($power, "offTime", array('placeholder' => '20:00') );
        echo CHtml::closeTag("div");
        echo CHtml::openTag("div", array(
            "data-bind" => "if: fixedMonPower() === 'weekly'"
        ));
        $days = array(
                "sunday",
                "monday",
                "tuesday",
                "wednesday",
                "thursday",
                "friday",
                "saturday",
            );
            foreach ($power->days as $day) {
                echo $formConfig->formGroup(array(
                    $formConfig->activeTextField($power, $day."On", array('placeholder' => '08:00') ),
                    $formConfig->activeTextField($power, $day."Off", array('placeholder' => '20:00') )
                ));
            }
        echo CHtml::closeTag("div");
    echo CHtml::closeTag("div");
$this->endWidget();

