<?php

class BackupController extends ControlCenterController
{
    static function backup( ){
        $configBackup = new ConfigBackup;
        if ( isset( $_FILES['ConfigBackup'] ) ){
            $configBackup->setScenario( 'upload' );
            $file = CUploadedFile::getInstance($configBackup,'uploadedfile');
            if ( $configBackup->validate() && $file ) {
                $configBackup->applyBackupFile( $file->getTempName() );
            }
		} 
        return array( 
            'configBackup' => $configBackup,
            'upload' => isset( $_FILES['ConfigBackup'] )
        );
    }
    
    public function actionGet()
	{
        $backup = new ConfigBackup;
		if ( isset( $_POST['ConfigBackup'] ) )
			$backup->setAttributes( $_POST['ConfigBackup'] );
		if ( !$backup->dump() ) {
            throw new CHttpException(500, $backup->getError("uploadedfile"));
        }
    }

    public function actionGetClientConfig( $ntp = 'false' )
	{
        $ipConfig = new IPConfig;
        $ipConfig->loadIP();
        if ( $ipConfig->dhcp ){
            getInfoIp( $ip, $ipprefix, $iptype);
            $server = $ip;
            
            $addrs = getInfoIpv6("eth0", false, true);
            for ( $i=0; $i<count($addrs); $i++ ){
                if ( substr($addrs[$i], 0, 4) === "fe80" ) $server = "[" . $addrs[$i] . "]";
            }
        } else {
            $server = $ipConfig->address;            
        }
        
        $playerConfig = new PlayerConfig;
        
        header("Content-type: text/xml");
        header('Content-Disposition: attachment; filename="config-network-api.cfg"');
        echo "<?xml version=\"1.0\"?>\n<configuration version=\"2.1\">\n";
        echo "<credential>\n<server>coaps+tcp://${server}</server>\n<username/>\n<password>$playerConfig->sharedVarPSK</password>\n<realm/>\n</credential>\n";
        echo "<network-api-server>${server}</network-api-server>\n";
        if ( $ntp == 'true' ){
            echo "<time-ntp>\n<boot-delay>90</boot-delay>\n<server-1>${server}</server-1>\n<monitor-only-1>no</monitor-only-1>\n</time-ntp>\n";
        }
        echo "</configuration>";        
    }
    
    public function actionPost()
	{
        $this->ajaxOnly(); 
        $errors = array();
        
        $res = self::backup( );
        if ( !isset($res['upload']) ) {
            $errors[] = "No file provided";
        }
        
        $this->render('/layouts/ajax', array(
            'errors' => $this->updateErrors( $res['configBackup'], $errors ),
        )); 
        if ( isset($res['configBackup']) ){
            $res['configBackup']->reloadConfig();
        }
    }    
}