#!/bin/bash
#
# License: Copyright 2012 SpinetiX S.A. This file is licensed
#          under the terms of the GNU General Public License version 2.
#          This program is licensed "as is" without any warranty of any
#          kind, whether express or implied.
#
### BEGIN INIT INFO
# Required-Start:
# Required-Stop:
# Should-Start:
# Should-Stop:
# Default-Start: 2 3 5
# Default-Stop:
# Short-Description: Does spxsysconf related system level checks
# Description: Does spxsysconf related system level checks
### END INIT INFO

# Init script information
NAME=spxchecks
DESC=""

# The list of mount points which should always be mounted if present in fstab
MOUNT_LIST=( "/srv" )

# If this state variable is set after doing the checks the system is rebooted
REBOOT=

LOGGER="logger -p daemon.err -t $NAME -s"

# Source spxsysconf functions
. /etc/spinetix/init-functions

check_diskspace() {
    # This will report any availble space problem to syslog
    spxdiskwatch
}

# Checks that essential mounts did work
check_mounts() {
    local m

    # for each entry in MOUNT_LIST check it is mounted if it is
    # effectively in /etc/fstab
    for m in "${MOUNT_LIST[@]}"; do
        isinfstab "$m" || continue
        if ! ismounted "$m"; then
            $LOGGER "ERROR: $m is not mounted! forcing reboot!"
            REBOOT=yes
        fi
    done
}

do_checks() {
    check_diskspace
    check_mounts

    if [ -n "$REBOOT" ]; then
        touch "$BOOTCOUNT_NORESET" # leave bootcount alone on shutdown
        $LOGGER "ERROR: check failure forced reboot, rebooting now"
        shutdown -r now "$NAME" check failure forced reboot
    fi
}

#
# Main
#

case "$1" in
    start)
        echo -n "Doing system level checks... "

        do_checks

        echo "done"

        ;;
    stop)
        ;;
esac
