#!/bin/sh
#
# License: Copyright 2017 SpinetiX. This file is licensed
#          under the terms of the GNU General Public License version 2.
#          This program is licensed "as is" without any warranty of any
#          kind, whether express or implied.
#
# Copyright 1999-2003 MontaVista Software, Inc.
# Copyright 2002, 2003, 2004 Sony Corporation
# Copyright 2002, 2003, 2004 Matsushita Electric Industrial Co., Ltd.
#
### BEGIN INIT INFO
# Required-Start:
# Required-Stop:
# Should-Start:
# Should-Stop:
# Default-Start: S
# Default-Stop:
# Short-Description: SpinetiX's content player cleanup
# Description: Perform cleanup actions for SpinetiX's content player
### END INIT INFO

# Init script information
NAME=raperca-clean.sh

# Individual Deamon information
CLEANCACHE=/var/spool/raperca/clean-cache
CLEANWEBSTORAGE=/var/spool/raperca/clean-webstorage
CLEANWEBPAGEDATA=/var/spool/raperca/clean-web-page-data

# Set up the path variables
. /etc/raperca/init-functions
init_dirs

# Source the init script functions
. /etc/init.d/functions

# Source main resources
[ -f /usr/share/resources/default/init/main ] && . /usr/share/resources/default/init/main

do_clean() {
    local BOOTCOUNT
    local BCNTLIM1=2
    local BCNTLIM2=4

    BOOTCOUNT="$(bootcount read)"
    [ -n "$rc_bootcount_lim_offset" ] && \
        [ "$rc_bootcount_lim_offset" -gt 0 ] && \
        BCNTLIM1=$(( BCNTLIM1 + rc_bootcount_lim_offset ))
    [ -n "$rc_bootcount_lim_offset" ] && \
        [ "$rc_bootcount_lim_offset" -gt 0 ] && \
        BCNTLIM2=$(( BCNTLIM2 + rc_bootcount_lim_offset ))

    echo -n "clean tmp"
    clean "$TMPSRVDIR" "$TMPWEBSERVICEDIR"

    if [ "${BOOTCOUNT:-10}" -ge $BCNTLIM1 ]; then
	echo -n ", clean cache (bootcount >= $BCNTLIM1)"
	clean $CACHEDIR $CACHEWSDIR
    elif [ -f "$CLEANCACHE" ]; then
	echo -n ", clean cache (requested)"
	clean $CACHEDIR $CACHEWSDIR
    fi
    if [ "${BOOTCOUNT:-10}" -ge $BCNTLIM2 ]; then
	echo -n ", clearing pending uploader actions (bootcount >= 4)"
	rm -f "$SPOOLDIR"/action*
    fi
    if [ -f "$CLEANWEBSTORAGE" ]; then
	echo -n ", clean web storage (requested)"
	clean $WEBSTORAGEDIR
    fi
    if [ -f "$CLEANWEBPAGEDATA" ]; then
        echo -n ", clean web page data (requested)"
        clean $CACHEWSDIR $COOKIEJARWSDIR $OFFSTORAGEWSDIR $WEBSTORAGEWSDIR $CEFDATAWSDIR
    fi
    if [ -f "$CLEANCACHE" -o -f "$CLEANWEBSTORAGE" -o -f "$CLEANWEBPAGEDATA" ]; then
	rm -f "$CLEANCACHE" "$CLEANWEBSTORAGE" "$CLEANWEBPAGEDATA"
	# be sure cleanup is on stable storage and we do not retrigger it.
	sync 
    fi

    return 0
}

case "$1" in
    start)
	echo -n "Doing SPX content player cleanup: "

	do_clean

    	echo -n " "
	success
	echo

	;;
    stop)
	;;
esac
