<?php

/**
 * Description of SecurityRPC
 *
 * @author jr
 */
class SecurityRPC extends Token
{
    public function init()
    {
        $this->setPrefix("cors");
    }
    public function rules()
    {
        $res = array(
            array("APIKey", 'length', 'min' => 10, 'max' => 64),
            array("APIKey", 'match', 'pattern' => "/^[-a-zA-Z0-9._+@]*$/"),
            array("enableCORS", 'checkToken'),
        );
        return $res;
    }
    public function attributeLabels()
    {
        return array(
            'APIKey' => 'API Key',
            'enableCORS' => 'Enable CORS requests',
        );
    }
    public function addTokenError()
    {
        $this->addError("APIKey", "API Key is required");
    }

    public function getAPIKey()
    {
        return $this->token;
    }
    public function setAPIKey($token)
    {
        $this->token = $token;
    }
    public function getEnableCORS()
    {
        return $this->enableToken;
    }
    public function setEnableCORS($val)
    {
        $this->enableToken = $val;
    }
}
