<?php
class SNMPConfig extends CFormModel {
	
    static $snmpfile="/etc/snmp/snmpd.local.conf";
    
    const RUN_CONFIG_FILE = '/etc/default/snmpd';

    var $rocommunity="";
    var $snmpaddress="";
    var $access="";
    
    var $snmpconf = null;
    var $snmpip="";
    var $snmpmask="";

    private $runConfig = null;
    
    public function rules() {
		$res = array(
            array( "rocommunity", 'required', 'on'=>'limited, all, community'),
            array( "rocommunity", 'match', 'pattern'=>'/^[\S]*$/', 'on'=>'limited, all, community'),
            array( "snmpaddress", 'required', 'on'=>'limited, backup-limited' ),
            array( "snmpaddress", 'checkAddress' , 'on'=>'limited, backup-limited'),
    	);
        return $res;
	}
    public function attributeLabels()
	{
		return array(
            'rocommunity'=>'Read-only community',
            'access'=>'Limit access to SNMP from the network',
            'snmpaddress'=>'Address range',            
            'local'=>'Closed',
            'limited'=>'Open to the following address range',
            'all'=>'Open to everybody',
            'example'=>'e.g., 192.168.1.100, 192.168.1.0/24 or 192.168.1.0/255.255.255.0',
		);
	}
    
    public function checkAddress( $attribute ){
        
        $addr = $this->$attribute;
        
        if ( preg_match("@^\s*([\d\.]*)(/([\d\.]*)|)\s*$@",$addr, $matches)!=0 && count($matches)>=2){
            $this->snmpip = $matches[1];
            $ch1 = new checkIPv4;
            $ch1->validateAttribute($this, 'snmpip');
            if ( $matches[1]=="127.0.0.1" ){
				$this->addError($attribute, "IP used in SNMP address range is not valid" );	
			}
			if ( count($matches)>3 ) {
				if ( strpos($matches[3],'.')===false ){
					$val = intval( $matches[3] );
					if ( $val<=0 || $val>32 ){
						$this->addError($attribute, "Mask used in SNMP address range is not valid (must be between 1 and 32)");	
					}
				}
				if ( strpos($matches[3],'.')!==false ){
                    $this->snmpmask = $matches[3];
                    $ch2 = new checkNetmask;
                    $ch2->validateAttribute($this, 'snmpmask');
				}
				if ( !$this->netaddr_check($matches[1], $matches[3] ) ){
					$this->addError($attribute, "IP and Mask used in SNMP address range are not valid (address must end with 0)");	
				}
			}
		}else {
			$this->addError($attribute, "SNMP address range is not valid" );	
		}
    }
    
    function netaddr_check($adr, $msk) {
        $a=ip2long($adr);
        if (strpos($msk,'.')!==false) {
            $m=ip2long($msk);
        } else {
            $m=pow(2, 32)-pow(2, 32-$msk);
        }
        
        if ( ($a & $m) == $a ) return true;
        return false;
        
    }

    
    function load() {
        if ( $this->snmpconf===null )
            $this->snmpconf=file_get_contents( self::$snmpfile );
        
        if (preg_match("@^\s*agentaddress\s+(\S+)@m", $this->snmpconf,$matches)){
            if ($matches[1]=="udp:127.0.0.1:161")
                $this->access="local";
            elseif ($matches[1]=="udp:161,tcp:161") {
                $this->access="limited";
            }elseif ($matches[1]=="udp:161,tcp:161,udp6:161,tcp6:161")
                $this->access="all";
        } 
        if (preg_match("@^\s*rocommunity\s+(\S+)\s+(\S+)+@m", $this->snmpconf,$matches)){
            $this->rocommunity=$matches[1];
            if ( $matches[2]!='default' && $matches[2]!='127.0.0.1' ) {
                $this->snmpaddress = $matches[2]; 
            } else if ($matches[2]=='127.0.0.1') {
                if ( preg_match("@^(\s*rocommunity\s+(\S+)\s+(\S+)+)+@m", $this->snmpconf,$matches)){
                    if ( $matches[3]!='default' && $matches[3]!='127.0.0.1' )
                        $this->snmpaddress = $matches[3]; 
                }
            } 
        }   
         
        $disabled = true;
        if (($this->runConfig || ($this->runConfig = @file_get_contents(self::RUN_CONFIG_FILE))) && preg_match('/SNMPDRUN=(.*)/', $this->runConfig, $matches)) {
            if ( $matches[1] === 'yes' ){
                $disabled = false;
            }
        }
        if ($disabled) {
            $this->access = "local";
        }
    }
    
    function save() {
        
        $comunity = $this->rocommunity;
        $addr = $this->snmpaddress;
        $access =  $this->access;

        if ($access !== 'limited') {
            $addr = '';
        }
        
        $this->load();
        if ( $comunity === $this->rocommunity &&
                $addr === $this->snmpaddress &&
                $access ===  $this->access )
            return ; // nothing changed
        
        $this->rocommunity = $comunity;
        $this->snmpaddress = $addr;
        $this->access = $access;

        if ( $addr=="" )
            $addr = "default";
            
        if ( $access=='all' ) {
            $this->snmpconf =preg_replace("@^\s*agentaddress\s+\S+.*@m","agentaddress udp:161,tcp:161,udp6:161,tcp6:161", $this->snmpconf);
        } else if ( $access=='limited' ) {
            $this->snmpconf =preg_replace("@^\s*agentaddress\s+\S+.*@m","agentaddress udp:161,tcp:161", $this->snmpconf);
            
        } else {
            $this->snmpconf =preg_replace("@^\s*agentaddress\s+\S+.*@m","agentaddress udp:127.0.0.1:161", $this->snmpconf);
        }
        
        $this->snmpconf =preg_replace("@^\s*rocommunity\s+\S+\s+127\.0\.0\.1.*@m","rocommunity $comunity 127.0.0.1", $this->snmpconf);
		$this->snmpconf =preg_replace("@^\s*rocommunity\s+\S+\s+(?!127\.0\.0\.1).*@m","rocommunity $comunity $addr", $this->snmpconf);
		$this->snmpconf =preg_replace("@^\s*rocommunity6\s+\S+.*@m","rocommunity6 $comunity default", $this->snmpconf);
        
        
        Tools::save_file( self::$snmpfile, $this->snmpconf );

        $run = $access === 'local' ? 'no' : 'yes';
        if ($this->runConfig) {
            $this->runConfig = preg_replace('/SNMPDRUN=.*/', "SNMPDRUN=$run", $this->runConfig);
        } else {
            $this->runConfig = "SNMPDRUN=$run\n";
        }
        Tools::save_file( self::RUN_CONFIG_FILE, $this->runConfig );

        Tools::addReason('snmp config change');
        
    }
}
