<?php

class Credentials extends CModel {
	
	protected $_href="";
    var $username="";
    var $password="";
    var $realm="";
    var $idx="";
    
    var $options = array();
    
    public function attributeNames() {
        return array("href", "username", "password", "realm" );
    }
    
    public function rules() {
		$res = array(
            array( "href", 'SimpleURLValidator', 'validSchemes' => array('http', 'https', 'coaps\+tcp'), 'allowEmpty' => false ),
            array( "username", 'safe' ),
            array( "password", 'safe' ),
            array( "realm", 'safe' ),
            array( "idx", 'safe' ),
    	);
        return $res;
	}
    
    public function attributeLabels()
	{
		return array(
            'href'=>'Server URI',
            'username'=>'Username',
            'password'=>'Password',
            'realm'=>'Realm',
		);
	}
    public function discard() {
        return $this->href=="" && $this->username=="" && $this->password=="" && $this->realm=="" ;
    }

    function setHref( $href ){
        $this->_href = $href;
    }
    function getHref( ){
        return $this->_href;
    }
    function setHrefConfig( $href ){
        $href = preg_replace("/:\/\/\[([a-fA-F0-9:]+)(?:" . urlencode('%') . 
            "\w*)?\]/", "://[$1]", $href);
        $this->_href = $href;
    }
    function getHrefConfig( $ip = null ){
        $href = $this->_href;
        if (preg_match("/:\/\/\[([a-fA-F0-9:]*)\]/", $href, $IPv6Match)) {
            if (!$ip) {
                $ip = new IPConfig();
                $ip->loadIP();
            }
            $address = $ip->resolveLinkLocalAddress($IPv6Match[1], true);
            $href = preg_replace("/:\/\/\[[a-fA-F0-9:]+\]/", 
                "://[" . $address ."]", $href);
        }
        return $href;
    }
}