<?php

class UserController extends Controller
{

    public $defaultAction = 'login';
    public function actionLogin()
	{
        $this->layout = '//layouts/fullscreen';
        if (Yii::app()->user->isGuest) {
            $userLogin = new UserLogin;
            // collect user input data
            
            
            // need to destroy the session automatically created by yii, otherwise we may create a session as root.
            // but we should not loose the return URL
            $app = Yii::app();
            $returnUrl =  Yii::app()->user->returnUrl;
            $app->getSession()->destroy();
            $app->getSession()->open();
            
            if(isset($_POST['UserLogin']))
            {
                $userLogin->attributes=$_POST['UserLogin'];
                // validate user input and redirect to previous page if valid
                if( $userLogin->validate() ) {
                    if ( Yii::app()->branding->product !="DiVA" && $returnUrl =="/" && Yii::app()->user->checkAccess("useControlCenter") ){
                        $this->redirect( array("/controlcenter/main/index") );
                    } else {
                        $this->redirect($returnUrl);			
                    }
                }
            } else {
                Yii::app()->user->setReturnUrl( $returnUrl );
            }

            $ARYAMode = new ARYAMode();
            if ($ARYAMode->getEnabled() && !isset($_GET['noredirect']) && count(User::model()->findAll()) <= 1) {
                $this->redirect("https://arya.spinetix.cloud");
            }            
            // display the login form
            $this->render('login',array(
                'userLogin' => $userLogin
            ));            
		} else{
			if ( Yii::app()->user->returnUrl != Yii::app()->createUrl('user/login') ){
                $this->redirect(Yii::app()->user->returnUrl);					
            } else {
                $this->redirect( "/" );					
            }
        }
	}

	public function actionLogout()
	{
        // Logout the current user
        Yii::app()->user->logout();
		$this->redirect(Yii::app()->user->returnUrl);
	}

}