ko.extenders.shortStr = function( target, options ) { 
    if ( target.shortStr ){
        return target;
    }
    var length = options || 20;
    target.shortStr = ko.computed( function() {
        if ( !target() || target().length < length ){
            return target();
        } else {
            return target().substr(0, length-3) + "...";
        }
    });
};

ko.extenders.duration = function( target, options ) { 
    if ( target.formated ){
        return target;
    }
    target.formated = ko.computed( {
        read: function() {
            if ( target() === undefined ){
                return undefined;
            }
            // supported formats: hh:mm:ss or ss           
            var val = ( "" + target()).split(":");
            var h, m, s, txt = "";
            if ( val.length === 1 ){
                if ( val[0] === "" ){
                    return "";
                }
                // seconds format                
                val[0] = parseFloat(val[0]);                
                h = Math.floor( val[0]/3600 );
                m = Math.floor( val[0]/60 - h*60 );
                s = val[0] - h*3600 - m* 60;
            } else {
                // hh::mm(:ss) format
                h = parseFloat(val[0]);
                m = parseFloat(val[1]);
                if ( val.length > 2 ) {
                    s = parseFloat(val[2]);
                }
            }
            if ( h > 24 ){
                var d = Math.floor( h/24 );
                h = h - d*24;
                txt = d + "d";
            }
            if ( h > 0 ){
                if ( txt !== "" ){
                    txt += " ";
                }
                txt += h + "h";                             
            }
            if ( m > 0 ){
                if ( txt !== "" ){
                    txt += " ";
                }
                txt += m + "m";
            }
            s = Math.round(s*1000)/1000;
            if ( s > 0 ){                
                if ( txt !== "" ){
                    txt += " ";
                }
                txt += s + "s";
            }
            if ( txt === "" ){
                txt = "0s";
            }
            return txt;
        }, 
        write: function( newVal ) {
            var dur = /(?:(\d+\.?\d*)d)?\s*(?:(\d+\.?\d*)h)?\s*(?:(\d+\.?\d*)m)?\s*(?:(\d+\.?\d*)s?)?/;
            var match = dur.exec( newVal );
            var d, h, m, s;
            if ( match ){
                d = parseFloat(match[1]) || 0;
                h = parseFloat(match[2]) || 0;
                m = parseFloat(match[3]) || 0;
                s = parseFloat(match[4]) || 0;                
                target( d*24*3600 + h*3600 + m*60 + s );                
            } else {
                target("");
            }
        }
    });    
    return target;
};
ko.extenders.datetime = function( target, options ) { 
    var fmt = options || "YYYY-MM-DD";
    var inputFmt = "YYYY-MM-DD[T]HH:mm:ss";
    target.time = ko.computed({
        read: function(){
            if ( target() ){
                var d = moment( target() );
                var str = d.format("HH:mm");
                return str;
            } else {
                return "";
            }
        },  
        write: function( newTime ) {
            if ( newTime === "" ){
                if ( target() ){
                    newTime="00:00";
                } else {
                    return;
                }
            } 
            var t = newTime.split(":");
            var dt;
            if ( target() ){
                dt = moment( target() );
            } else {
                dt = moment( );
            }
            if ( t.length > 0 ){
                dt.hours( parseInt(t[0], 10));
            }else {
                dt.hours( 0 );
            }
            if ( t.length > 1 ){
                dt.minutes( parseInt(t[1], 10) );
            } else {
                dt.minutes( 0 );
            }
            if ( t.length > 2 ){
                dt.seconds( parseInt(t[2], 10));
            } else {
                dt.seconds( 0 );
            }
            target( dt.format( inputFmt ) );
        }
    });
    target.date = ko.computed({
        read: function(){
            if ( target() ){
                var d = moment( target() );
                var str = d.format( fmt );                
                return str;
            } else {
                return "";
            }
        },  
        write: function( newDate ) {
            if ( newDate === "" ){
                target( "" );
            } else {
                var d = moment( newDate );
                var dt;
                if ( target() ){
                    dt = moment( target() );                
                } else {
                    dt = moment( );
                    dt.set('hour',0);
                    dt.set('minute',0);
                    dt.set('second',0);                
                }
                dt.set('year', d.get('year') );
                dt.set('month', d.get('month') );
                dt.set('date', d.get('date') );
                target( dt.format( inputFmt ) );
            }
        }
    });    
    return target;
};

ko.dirtyFlag = function(root, isInitiallyDirty) {
    var result = function() {},
        _initialState = ko.observable(ko.toJSON(root)),
        _isInitiallyDirty = ko.observable(isInitiallyDirty);

    result.isDirty = ko.computed(function() {
        return _isInitiallyDirty() || _initialState() !== ko.toJSON(root);        
    }).extend({ rateLimit: 1 });

    result.reset = function( isInitiallyDirty ) {
        _initialState(ko.toJSON(root));
        _isInitiallyDirty( isInitiallyDirty );
    };

    return result;
};



// KO bindings
// Equal height childrens
ko.bindingHandlers.equalHeightsPanels = {
    update: function (element, valueAccessor, allBindings) {
        var min_height = ko.unwrap( valueAccessor() );        
        $(element).children().children(".panel").each(function () {
            var height = $(this).height();
            if( height > min_height ) {
                min_height = height;        
            }
        });
        $(element).children().children(".panel").css("min-height", min_height);
        $(element).children().children(".panel").children(".panel-body").css("min-height", min_height-100);
        // fix the footer
        $(element).children().children(".panel").children(".panel-footer").each(function() {
            var self = $(this);
            var width = self.parent().width();
            //self.width( parseInt( width )-1 );
            self.css('width', parseInt( width )-1 );
            self.css('position', 'absolute' );
            self.css('min-height', '54px' );
            self.css('bottom', parseInt(self.parent().css("margin-bottom"))+1 );
        });
    }    
};

ko.bindingHandlers.hidden = {
    update: function(element, valueAccessor, allBindings) {
        var val = ko.utils.unwrapObservable(valueAccessor());
        var notval = !val;
        ko.bindingHandlers.visible.update(element, function() { 
            return notval; 
        }, allBindings );
    }        
};

ko.bindingHandlers.clickToEdit = {
    init: function(element, valueAccessor) {
        var observable = valueAccessor(),
            link = document.createElement("a"),
            input = document.createElement("input");
        input.setAttribute('class', 'form-control input-sm');
        input.setAttribute('style', 'margin-top: -5px; margin-bottom: -5px;');
        element.appendChild(link);
        element.appendChild(input);

        observable.editing = ko.observable(false);

        ko.applyBindingsToNode(link, {
            text: observable,
            hidden: observable.editing,
            click: function() { observable.editing(true); }
        });

        ko.applyBindingsToNode(input, {
            value: observable,
            visible: observable.editing,
            hasfocus: observable.editing
        });
    }
};

ko.bindingHandlers.datepicker = {
    init: function(element, valueAccessor, allBindingsAccessor) {
      //initialize datepicker with some optional options
      var options = $.extend( { 
          autoclose: true,
          //format: 'yyyy-mm-dd',
          format: 'dd M yyyy',
          minView: 2
      }, allBindingsAccessor().datepickerOptions);
      var observable = valueAccessor();
        
      $(element).datetimepicker(options);

      //when a user changes the date, update the view model
      ko.utils.registerEventHandler(element, "changeDate", function(event) {
            observable.isUpdating = true;
            if ( event.date ) {
                var dateStr = event.date.toISOString();
                // remove the time part
                var posT = dateStr.indexOf("T");
                var val = dateStr.substr(0, posT );
                observable( val );                              
            } else {
                observable( "" );                
            }
            observable.isUpdating = false;
      });
      
    },
    update: function(element, valueAccessor, allBindings)   {
        if ( valueAccessor().isUpdating )
            return;
        
        var value = ko.utils.unwrapObservable(valueAccessor());
        
        if ( value === null || value === "" || value === undefined ){
            $(element).datetimepicker( 'reset' ); 
        } else {                 
            $(element).datetimepicker( 'update' , value );               
        }
    }
};

ko.bindingHandlers.datetimepicker = {
    init: function(element, valueAccessor, allBindingsAccessor) {
      //initialize datepicker with some optional options
      var options = allBindingsAccessor().datetimepickerOptions || { 
          autoclose: true,
          format: 'yyyy-mm-dd hh:ii'
      };
      var observable = valueAccessor();
        
      $(element).datetimepicker(options);

      //when a user changes the date, update the view model
      ko.utils.registerEventHandler(element, "changeDate", function(event) {
            var dateStr = event.date.toISOString();
            observable( dateStr.substr(0, 16 ) );                                  
      });
      
    },
    update: function(element, valueAccessor, allBindings)   {
        var value = ko.utils.unwrapObservable(valueAccessor());
        if ( $.type(value) !== "string" )
            $(element).val( "" );
        else { 
            var posT = value.indexOf("T");
            var date = value.substr(0, posT );
            var time = value.substr(posT+1, 5 );
            
            //var date = new Date( value );
            //$(element).val( date.getFullYear() + "-" + date.getMonth() + "-" + date.getDate() + " " + date.getHours() + ":" + date.getMinutes()  );
            $(element).val( date + " " + time );
            $(element).datetimepicker('update' );               
        }
    }
};

ko.bindingHandlers.colorpicker = {
    init: function(element, valueAccessor, allBindingsAccessor) {
      //initialize datepicker with some optional options
      var options = allBindingsAccessor().colorpickerOptions || { };
      var observable = valueAccessor();
        
      $(element).colorpicker(options);
      var timer = null;
      //when a user changes the date, update the view model
      ko.utils.registerEventHandler(element, "changeColor", function(event) {
          var hex = event.color.toHex();
          if ( timer !== null ){
            clearTimeout( timer );
          }
          if ( event.value == hex || event.value === undefined ){
            observable( hex );                                    
          } else {
            timer = setTimeout(function() { observable( hex ); }, 1000 );
          }
      });
      
    },
    update: function(element, valueAccessor, allBindings)   {
        var value = ko.utils.unwrapObservable(valueAccessor());
        var target = $(element);
        if ( target.prop("tagName") !== 'INPUT' ){
            target = $(element).children('input');
        }
        if ( value === undefined ){
            target.val( "" );
            if ( allBindings().default ){
                $(element).colorpicker('setValue', allBindings().default );
            }
        } else {
            target.val( value );
            $(element).colorpicker('setValue', value);
        }
    }
};
ko.bindingHandlers.bootstrapSwitch = {
    init: function(element, valueAccessor, allBindingsAccessor) {
      //initialize datepicker with some optional options
      var options = allBindingsAccessor().switchOptions || { };
      var observable = valueAccessor();
        
      $(element).bootstrapSwitch(options);
      
      if ( options.fit ){
        $(element).parent().parent().css('width', '100%');
        options.fit = undefined;
      }
      //when a user changes the date, update the view model
      ko.utils.registerEventHandler(element, "switchChange.bootstrapSwitch", function(event, state) {
          observable( state );
      });
      
    },
    update: function(element, valueAccessor, allBindings)   {
        var value = ko.utils.unwrapObservable(valueAccessor());
        $(element).bootstrapSwitch('state', value, true );        
    }
};
ko.bindingHandlers.iCheck = {
    init: function(element, valueAccessor, allBindingsAccessor) {
      //initialize datepicker with some optional options
      var options = allBindingsAccessor().iCheckOptions || { 
        checkboxClass: 'icheckbox_square-blue checkbox',
        radioClass: 'iradio_square-blue'
      };
      var observable = valueAccessor();
        
      $(element).iCheck(options);
 
      //when a user changes the date, update the view model
      ko.utils.registerEventHandler(element, "ifChecked", function(event) {
          observable( true );
      });
      ko.utils.registerEventHandler(element, "ifUnchecked", function(event) {
          observable( false );
      });
      if (allBindingsAccessor().disable ){
          if ( ko.isObservable(allBindingsAccessor().disable) ){
            allBindingsAccessor().disable.subscribe(function( newVal ) {
                if ( newVal ){
                    $(element).parent().addClass('disabled');
                    $(element).iCheck('disable');
                } else {
                    $(element).parent().removeClass('disabled');
                    $(element).iCheck('enable');
                }

            });
          }        
      }
      
    },
    update: function(element, valueAccessor, allBindings)   {
        var value = ko.utils.unwrapObservable(valueAccessor());
        if ( value )
            $(element).iCheck('check' );
        else
            $(element).iCheck('uncheck' );
    }
};
ko.bindingHandlers.option = {
    update: function(element, valueAccessor) {
       var value = ko.utils.unwrapObservable(valueAccessor());
       ko.selectExtensions.writeValue(element, value);   
    }        
};

ko.bindingHandlers.bootstrapSelect = {
    'after': ['options', 'foreach', 'option'],
    divider: function( select ){
        $(select).children().each( function() {
            if ( $(this).text()==='divider' )
                $(this).attr('data-divider', "true");
        });
    },
    init: function(element, valueAccessor, allBindingsAccessor) {
        //initialize datepicker with some optional options
        var options = allBindingsAccessor().selectOptions || {};

        ko.bindingHandlers.bootstrapSelect.divider( element );
        $(element).selectpicker(options);
        
        
        if (allBindingsAccessor().options && ko.isObservable(allBindingsAccessor().options)) {
            allBindingsAccessor().options.subscribe(function( ) {
                ko.bindingHandlers.bootstrapSelect.divider( element );
                setTimeout(function() {
                    // re-render the dropdown once the HTMl has been updated
                    $(element).selectpicker('refresh');
                }, 0 );                   
            });
        }
        if (allBindingsAccessor().enable && ko.isObservable(allBindingsAccessor().enable)) {
            allBindingsAccessor().enable.subscribe(function( ) {
                $(element).selectpicker('refresh');                
            });
            //allBindingsAccessor().enable = undefined;
        }
        if (allBindingsAccessor().disable && ko.isObservable(allBindingsAccessor().disable)) {
            allBindingsAccessor().disable.subscribe(function( ) {
                $(element).selectpicker('refresh');                
            });
            //allBindingsAccessor().disable = undefined;
        }
        return ko.bindingHandlers.value.init(element, valueAccessor, allBindingsAccessor);
    },
    update: function(element, valueAccessor, allBindings) {
        if ( allBindings().watch ) {            
            var watchList = allBindings().watch;
            for( var i=0; i<watchList.length; i++ ){
                var dummy = ko.utils.unwrapObservable(watchList[i]); // make sure any changes in the watched variable will trigger an update
            }
        }
        var ret = ko.bindingHandlers.value.update(element, valueAccessor, allBindings);
        $(element).selectpicker('render');
        $(element).selectpicker('refresh');
        return ret;
    }
};
ko.bindingHandlers.multiselect = {
    'after': ['options', 'foreach'],
    init: function(element, valueAccessor, allBindingsAccessor) {
        //initialize datepicker with some optional options
        var timeout = null;
        var options = $.extend( {
            buttonWidth: '100%',
            buttonText: function(options, select) {
                if (options.length === 0) {  
                    return '<span class="pull-left">' + this.nonSelectedText + '</span> <span class="caret"></span>';
                } else {
                    if (options.length > this.numberDisplayed) {
                        return '<span class="pull-left">' + options.length + ' ' + this.nSelectedText + '</span> <span class="caret"></span>';
                    }
                    else {
                        var selected = '';
                        options.each(function() {
                            var label = ($(this).attr('label') !== undefined) ? $(this).attr('label') : $(this).html();

                            selected += label + ', ';
                        });
                        return '<span class="pull-left">' + selected.substr(0, selected.length - 2) + '</span> <span class="caret"></span>';
                    }
                }
            },
            onChange: function(option, checked) {
                if ( timeout ){
                    clearTimeout( timeout );
                    timeout = null;
                }
                timeout = setTimeout( function(){
                    $(element).siblings('div').children('ul').dropdown('toggle');
                    timeout = null;
                }, 3000);
            }, 
            onDropdownHidden: function(event) {
                if ( timeout ){
                    clearTimeout( timeout );
                    timeout = null;
                }
            }
        }, allBindingsAccessor().selectOptions );

        $(element).multiselect(options);
        
        return ko.bindingHandlers.selectedOptions.init(element, valueAccessor, allBindingsAccessor);
    },
    update: function(element, valueAccessor, allBindings) {        
        var ret = ko.bindingHandlers.selectedOptions.update(element, valueAccessor, allBindings);
        var value = ko.utils.unwrapObservable(valueAccessor());        
        $(element).multiselect("refresh");
        return ret;
    }
};
ko.bindingHandlers.select2 = {
    'after': ['options', 'foreach'],
    init: function(element, valueAccessor, allBindingsAccessor) {
        //initialize datepicker with some optional options
        var options = allBindingsAccessor().selectOptions || {
            width: '100%'
        };

        $(element).select2(options);
        
        return ko.bindingHandlers.value.init(element, valueAccessor, allBindingsAccessor);
    },
    update: function(element, valueAccessor, allBindings) {
        var ret = ko.bindingHandlers.value.update(element, valueAccessor, allBindings);
        var value = ko.utils.unwrapObservable(valueAccessor());
        $(element).select2("val", value );
        return ret;
    }
};

ko.bindingHandlers.tags = {
    init: function(element, valueAccessor, allBindingsAccessor) {
        //initialize datepicker with some optional options
        var options = $.extend( { 
            width: '100%',
            maximumInputLength: 10,
            tokenSeparators: [",", " ", ";"],
            tags:['default', 'private', 'public']
        }, allBindingsAccessor().tagsOptions );
        $(element).select2(options); 
        return ko.bindingHandlers.value.init(element, valueAccessor, allBindingsAccessor);
    },
    update: function(element, valueAccessor, allBindings) {
        var ret = ko.bindingHandlers.value.update(element, valueAccessor, allBindings);
        var value = ko.utils.unwrapObservable(valueAccessor());
        $(element).val( value ).trigger("change");
        return ret;
    }
};
ko.bindingHandlers.typeahead = {
    init: function(element, valueAccessor, allBindingsAccessor) {
        //initialize datepicker with some optional options
        var observable = valueAccessor();
        var options = $.extend( { 
            highlight: true
        }, allBindingsAccessor().typeaheadOptions );
        var dataset = allBindingsAccessor().typeaheadDataset;
        $(element).typeahead( options, dataset ); 
        
        ko.utils.registerEventHandler(element, "focusout", function(event ) {                     
           observable( $(element).typeahead('val') );
        });
        ko.utils.registerEventHandler(element, 'keypress',function(e){
            var p = e.which;
            if( p === 13 ){
                observable( $(element).typeahead('val') );
            }
        });
        ko.utils.registerEventHandler(element, "typeahead:selected", function(event, sugestion, name) {
           observable( sugestion.value );
        });
        ko.utils.registerEventHandler(element, "typeahead:autocompleted", function(event, sugestion, name) {
           $(element).typeahead('close');
           observable( sugestion.value );
        });
        return ko.bindingHandlers.value.init(element, valueAccessor, allBindingsAccessor);
    },
    update: function(element, valueAccessor, allBindings) {
        var ret = ko.bindingHandlers.value.update(element, valueAccessor, allBindings);
        var value = ko.utils.unwrapObservable(valueAccessor());
        $(element).typeahead( 'val', value );
        return ret;
    }
};
ko.bindingHandlers.slider = {
    init: function(element, valueAccessor, allBindingsAccessor) {
        //initialize datepicker with some optional options
        
        var options = $.extend( {
            handle: 'square',
            tooltip: 'hide'
        }, ko.toJS( valueAccessor() ) );        
        var slider = $(element).slider( options );       
        if ( ko.isObservable( valueAccessor().value ) ){
            $(element).on('slideStop', function( ev ){                
                valueAccessor().value( ev.value );                
            });
        }
        if ( options.default !== undefined ) {
            $(element).slider('setValue', options.default );
        }
        $('.slider-horizontal').css('width', '100%');
    },
    update: function(element, valueAccessor, allBindings) {
        var options = valueAccessor();
        var val = ko.unwrap( options.value);
        if ( val || val === 0 || val === "0" ){
            $(element).slider('setValue', parseFloat( val ) );
        }
    }
};


ko.bindingHandlers.darkroom = {
    update: function(element, valueAccessor, allBindingsAccessor) {
        var value = ko.unwrap( valueAccessor() );
        var options = $.extend( { 
            minWidth: 300,
            minHeight: 300,
            maxWidth: 1920,
            maxHeight: 1920,

            // Plugins options
            plugins: {
              crop: {
                minHeight: 50,
                minWidth: 50 
              },
              save :{
              }
            }
        }, allBindingsAccessor().darkroomOptions );
        if ( allBindingsAccessor().saveUri ){
            options.plugins.save.saveCallback = function( data, mimeType ){ spxapi.media.updateMedia( ko.unwrap( allBindingsAccessor().saveUri ), data, mimeType ); };
        }
        $(element).attr( 'src', value );
        if ( !ko.bindingHandlers.darkroom._master && value ) {
            ko.bindingHandlers.darkroom._master = new Darkroom( element, options );
        }
    },
    _master : null
};

ko.bindingHandlers.duration = {
    init: function(element, valueAccessor, allBindingsAccessor) {
        //initialize datepicker with some optional options
        var obs = valueAccessor();
        if ( ko.isObservable(obs) ){
            obs.extend( { duration: true } );            
        } 
        return ko.bindingHandlers.value.init(element, function() { return obs.formated; }, allBindingsAccessor); 
    },
    update: function(element, valueAccessor, allBindings) {
        return ko.bindingHandlers.value.update(element, function() { return valueAccessor().formated; }, allBindings);        
    }
};

ko.bindingHandlers.mask = {
    init: function(element, valueAccessor, allBindingsAccessor) {
        //initialize datepicker with some optional options
        
        var mask = ko.utils.unwrapObservable( valueAccessor() );
        var options = $.extend( {}, allBindingsAccessor().maskOptions );
        $(element).inputmask( mask, options);        
    }
};

ko.bindingHandlers.paginator = {
    init: function(element, valueAccessor, allBindingsAccessor) {
        //initialize datepicker with some optional options
        var options = $.extend( {}, ko.bindingHandlers.paginator.defaultOptions );
        var observable = valueAccessor();
        if ( allBindingsAccessor().paginatorOptions )
            $.extend( options, allBindingsAccessor().paginatorOptions );
        
        $.fn.bootstrapPaginator.defaults.bootstrapMajorVersion = 3;
        
        for ( var opt in options ) {
            if ( ko.isObservable( options[opt] ) ){
                var name = opt;
                var obs = options[opt];
                options[opt] = obs();
                obs.subscribe( function( newValue ) {
                    var options = {};
                    options[name] = newValue;
                    $(element).bootstrapPaginator( options );
                });  
            }
        }
        options.onPageClicked = function(event, originalEvent, type, page) {            
            observable(page - 1);
            event.stopImmediatePropagation(); // wiil change the page using the observable
        };
        $(element).bootstrapPaginator(options);

    },
    update: function(element, valueAccessor, allBindings) {
        var observable = valueAccessor();
        $(element).bootstrapPaginator("show", observable() + 1);
    },
    defaultOptions: {
        shouldShowPage: function(type, page, current) {
                return true;
        },
        itemContainerClass: function (type, page, current) {
            return (page === current && type==='page' ) ? "active" : "";
        }
    }
};

ko.bindingHandlers.tooltip = {
    init: function(element, valueAccessor, allBindingsAccessor) {
        //initialize datepicker with some optional options
        var options = $.extend( {}, ko.bindingHandlers.tooltip.defaultOptions );
        var value = ko.utils.unwrapObservable( valueAccessor() );
        if ( $.type(value) === "string" ){
            options.title = value;
        } else {
            $.extend( options, value );
        }
        options.container = $(element).parent().parent();
        $(element).tooltip( options );        
    },
    update: function(element, valueAccessor, allBindingsAccessor) {
        var options,
            value = ko.utils.unwrapObservable( valueAccessor() );
        if ( $.type(value) === "string" ){
            $(element).data('bs.tooltip').options.title = value;
        } else {
            options = $.extend( {}, ko.bindingHandlers.tooltip.defaultOptions, value );
            $(element).data('bs.tooltip').options = options;
        }        
    },
    defaultOptions: {          
    }
};
/*
 * Binding for the jquery.fileupload 
 * <script src="js/jquery/jquery.ui.widget.js"></script>
 * <script src="js/jquery/jquery.iframe-transport.js"></script>
 * <script src="js/jquery/jquery.fileupload.js"></script>
 */
ko.bindingHandlers.jQueryFileupload = {
    init: function (element, valueAccessor, allBindings ) {
        var url = null;
        if ( allBindings.has('args') ){
            var args = ko.unwrap( allBindings.get('args') );
            if ( args.url )
                url = args.url;            
        }

        var progressBar = null;
        var namesNode = null;
        var names = "";
        var msgId = null;
        var totalSize = 0;
        var currentSize = 0;
        var nbFiles = 0;
        $(element).fileupload({
            dataType: 'json',
            url: url,
            //dropZone: $('.spx-dropzone'),
            submit: function (e, data) {                
                var filename = data.files[0].name;
                var name = filename.substr(0, filename.lastIndexOf('.') );
                data.uploadName = name;
                if ( !args.mediaOnly ){
                    data.formData = {data: "{ \"name\": \"" + name + "\"}" };
                } 
                data.formData = _spxapi_getCSRFdata(data.formData);
                data.fileLoaded = 0;
                if ( names === "" ){
                    names = name;
                } else {
                    names += "; " + name;
                }
                if ( !msgId ){
                    msgId = spxapi.ui.message({
                        title: spxapi.t('Upload started'),
                        body: spxapi.t("Uploading") + ": " + "<span class='names'>xxx</span>",
                        progress: true,
                        type: 'info',
                        sticky: true, 
                        after_close: function() {
                            msgId = null;
                        }, 
                        after_open: function( el ) {
                            progressBar = el.find('.progress-bar');
                            namesNode = el.find('.names');                            
                            namesNode.text( names );
                            
                        }
                    });  
                } else {
                    if ( namesNode ){
                        namesNode.text( names );                        
                    }                    
                }
                nbFiles++;
            },
            disableImageResize: false,
            imageMaxWidth: 1920*2,
            imageMaxHeight: 1920*2,
            imageOrientation: true,
            progress: function(e, data) {
                if ( !data.fileLoaded ){                         
                    totalSize += data.total*1.1;
                }             
                currentSize += data.loaded - data.fileLoaded;
                data.fileLoaded = data.loaded;
                if ( msgId && progressBar ) {
                    var progress = parseInt( currentSize / totalSize * 100, 10);
                    progressBar.css( 'width', progress + '%');
                }                
            },
            always: function( e, data ) {
                nbFiles--;
                currentSize += data.fileLoaded*0.1;                
                if ( nbFiles === 0 && msgId ){                
                    spxapi.ui.removeMessage( msgId );
                    msgId = null;
                    totalSize = 0;
                    currentSize = 0;
                    nbFiles = 0;
                    names = "";
                }
            },
            done: function (e, data) {          
                if ( data.result.reload ){
                    location.reload(); 
                    return;
                }
                // add the resource to the db
                data.result.model = spxapi.resources.add( data.result );
                
                valueAccessor()( data.result );
            }, 
            fail: function( e, data) {
                var r = { error : "Some error occured ("+ data.jqXHR.status + ")" };
                if ( data.jqXHR.responseText ){
                    try{
                        r = JSON.parse( data.jqXHR.responseText );
                    } catch ( e ){                        
                    }
                }
                var error = "<span>"+r.error+"</span>";
                if ( r.details && r.details.file){
                    error += "<ul>";
                    for ( var i=0; i<r.details.file.length; i++ ){
                        error += "<li>" + r.details.file[i] + "</li>";
                    }
                    error += "</ul>";
                    
                    error = "<div>" + error + "</div>";
                };
                
                spxapi.ui.message({
                    title: spxapi.t('Upload failed for {name}', { "{name}" : data.uploadName }),
                    body: error
                });
            }
        });
    }
};

ko.bindingHandlers.dataTable = {
    init: function( element, valueAccessor, allBindings, viewModel, bindingContext ) {
        
        var options = valueAccessor(),
            table = null;
        if (options.data && ko.isObservable(options.data)) {
            var dataObservable = options.data;
            options.data = dataObservable();

            // update the table if the data are modified (see http://datatables.net/dev/knockout/ )
            dataObservable.subscribe(function(changes) {
                for (var i=0; i<changes.length; i++ ){
                    var change = changes[i];
                    if ( change.status === "added" ){
                        
                    } else if ( change.status === "deleted" ){
                        
                    } 
                }
            }, null, "arrayChange");
        }
        table = $(element).dataTable(options);
        if ( allBindings.has('dataTableTarget') ){
            var target = allBindings.get('dataTableTarget');
            if ( ko.isObservable( target ) ) {
                target( table.api() );
            }
        };
        
    }
};

ko.bindingHandlers.fullCalendar = {
    init: function(element, valueAccessor, allBindingsAccessor) {
        
        var options = valueAccessor();
        
        $(element).fullCalendar(options);
        options.getEvents = function( idOrFilter ) {
            return $(element).fullCalendar( 'clientEvents', idOrFilter );
        };
        options.renderEvent = function( event , stick ) {
            return $(element).fullCalendar( 'renderEvent', event , stick );
        };
        options.updateEvent = function ( event ) {
            return $(element).fullCalendar( 'updateEvent', event );
        };
        options.removeEvents = function ( idOrFilter ) {
            return $(element).fullCalendar( 'removeEvents', idOrFilter );
        };
        options.setSelect = function ( start, end ) {
            return $(element).fullCalendar( 'select', start, end );
        };
        options.clearSelect = function ( ) {
            return $(element).fullCalendar( 'unselect' );
        };
        options.getView = function ( ) {
            return $(element).fullCalendar( 'getView' );
        };
        options.setCalendarOptions = function ( name, value ) {
            return $(element).fullCalendar( 'option', name, value );
        };
        options.changeView = function ( viewName  ) {
            return $(element).fullCalendar( 'changeView', viewName  );
        };
    },
    update: function(element, valueAccessor, allBindingsAccessor) {
        
        var options = valueAccessor();
        
        if ( options.data ) {
            $(element).fullCalendar('removeEvents');
            $(element).fullCalendar('addEventSource', ko.utils.unwrapObservable( options.data ));         
            $(element).fullCalendar('rerenderEvents' );           
        }
        
    }
};