<?php
require_once './protected/utils/MaintenanceJobs.php'; // for the reboot and other processes
require_once './protected/utils/MainInfo.php'; // for the info

function isLoggedUser()
{
    if (!isset($_COOKIE["uisess"])) {
        return false;
    }
    $id = $_COOKIE["uisess"];
    $autentication_path = ini_get('session.save_path');
    return file_exists($autentication_path . "/auth_" . $id);
}

function isWizard()
{
    $job = new MaintenanceJobs();
    return $job->getWizard();
}

if (!isWizard() && !isLoggedUser()) {
    header("HTTP/1.0 403 Forbidden");
    header('Content-Type: text/html; charset=UTF-8');
    exit();
}
$serial = "";
$model = "";
$hardware = "";
getInfoSerial($serial, $model, $hardware);
$firwmare = "";
$build = "";
getInfoFirmware($firwmare, $build);
?>
<!DOCTYPE html>
<html lang="en">
<head data-revision="$Revision: 36281 $" data-date="$Date: 2020-06-17 17:10:00 +0200 (Wed, 17 Jun 2020) $">
<meta http-equiv="Content-type" content="text/html;charset=UTF-8">
<meta name="description" content="Wi-Fi Configuration" />
<meta name="creator" content="SpinetiX" />
<meta name="viewport" content="width=device-width, initial-scale=1.0, maximum-scale=1.0,user-scalable=0">
<title>#<?php echo $serial; ?> - Wi-Fi</title>
<style>
body {margin: 0 auto; width: 90%; max-width:560px; padding:0; font-family: Tahoma,Geneva,Arial,sans-serif; font-size: 14px; color: #333; text-align:center;}
header a{cursor: help;}
main {margin: 0 auto; text-align:left;}
main p {text-align: justify;}
a {text-decoration:none;}
form {display: inline-block; width: 100%;}
legend { font-weight: bold;}
input[type=submit] {display: block;cursor: pointer;}
input[type=radio], input[type=checkbox], select{cursor: pointer;}
details {display: block; margin-top: 10px;}
summary{font-style: normal;cursor: help;}
.spacing { margin-top: 20px; }
textarea, input[type=text], input[type=password], input[type=file], select {margin:3px 0 20px; width:fit-content; display: flex;}
textarea, input[type=text], input[type=password], input[type=file] {width:96%;}
#password { margin-bottom: 5px;}
select{width: 100%;}
label{vertical-align: inherit; margin-top: 3px; }
input:invalid { color: black; box-shadow: none; }
footer {display: block; font-size:10px; text-align:center; margin:20px 0; padding-top: 10px; clear:both; color: #CCC}
footer a {color: #1468B3;}
.pointer{cursor: pointer;}

.btn:hover {
    color: #fff;
    background-color: #1b4f86;
    border-color: #153d68;
    text-decoration: none;
}
.btn-block {
    margin-left: 0px;
    display: block;
    width: 100%;
}
.btn {
    color: #fff;
    background-color: #2468b0;
    border-color: #205b9b;
    
    border-radius: 0;
    -webkit-appearance: none;
    -webkit-border-radius: 0;
    outline: none;
    margin-bottom: 5px !important;
    margin-left: 2px;
    width: 100%;
    font-size: 13px;
    padding: 7px 11px;
    box-shadow: 1px 1px 2px rgba(0, 0, 0, 0.12), 1px 1px 0 rgba(255, 255, 255, 0.2) inset;
    display: inline-block;
    padding: 6px 12px;
    margin-bottom: 0;
    font-size: 14px;
    font-weight: 400;
    line-height: 1.42857143;
    text-align: center;
    white-space: nowrap;
    vertical-align: middle;
    -ms-touch-action: manipulation;
    touch-action: manipulation;
    cursor: pointer;
    -webkit-user-select: none;
    -moz-user-select: none;
    -ms-user-select: none;
    user-select: none;
    background-image: none;
    border: 1px solid transparent;
        border-top-color: transparent;
        border-right-color: transparent;
        border-bottom-color: transparent;
        border-left-color: transparent;
    border-radius: 0;
}
.no-space-after {
    margin-bottom: 5px !important;
}
.btn-small {
    width: 44%;
}
</style>
<script>//<![CDATA[
const parser = new DOMParser(), 
      serializer = new XMLSerializer(),
      encoder = new TextEncoder(),      
      defaultXMLString = '<'+'?xml version="1.0"?><configuration version="2.1"></configuration>';
var pem = '';

window.onload = function() { 
    document.forms['data'].reset(); // prevents Firfox bug

    document.getElementById('ssidSelectGroup').style.display = 'none';
    document.getElementById('ssidTextGroup').style.display = 'block';    

    rpc("wifi_get_info", [], function(error, response){
        if (response){            
            var selectssid = document.getElementById("selectssid");
            for ( var network of response.networks ){
                var option = document.createElement("option");
                option.text = network.name;
                option.value = network.name;
                option.setAttribute("data-type", network.type)
                selectssid.add(option);
            }
            var option = document.createElement("option");
            option.text = "Other...";
            option.value = "...";            
            selectssid.add(option);
            if ( response.networks.length > 0 ){
                document.getElementById('ssidSelectGroup').style.display = 'block';
                selectSSID( response.networks[0].name );
            } else {
                selectSSID( "..." );
            }
        }         
    })

}; 
    
function rpc( command, params, callback ){
    const xhr = new XMLHttpRequest();

    var jsonRPC = {
        method: command,
        id: "1",
        params: params,
    }
    // send to RPC
    xhr.onload = () => {
        if (xhr.status >= 200 && xhr.status < 300) {
            // parse JSON
            const response = JSON.parse(xhr.responseText);
            console.log(response);
            if ( callback ) callback( response.error, response.result);                            
        }
    };
    xhr.open('POST', '/rpc');
    xhr.setRequestHeader('Content-Type', 'application/json');
    xhr.send(JSON.stringify(jsonRPC));
}
function appplyIpConfig(){
    var xmlString = '', jsonRPC = '';

    xmlString = generateConfig( true, true );
    console.debug(xmlString);

    document.getElementById('submitanyway').style.display = 'none';
    document.getElementById('footer').innerHTML = 'Applying IPv4 setup...';
    rpc("set_config", [{ "xmlconfig": xmlString }], function(error, response){
        document.getElementById('footer').innerHTML = 'IPv4 setup applied';
        if ( response && response.success ){
            document.getElementById('statusstring').innerHTML = "Restarting...";
            document.getElementById('footer').innerHTML = 'Waiting for restart...';
            setTimeout(function(){
                document.getElementById('footer').innerHTML = 'Redirecting...';
                document.getElementById('statusstring').innerHTML = "Done";
                window.location.href = "https://arya.spinetix.cloud";
            }, 20000);                
        } 
        if ( error ){
            document.getElementById('footer').innerHTML = error;
            document.getElementById('statusstring').innerHTML = "IPv4 setup not applied";            
        }
    });   
}

function escapeValue(value) {
    if (typeof value !== 'string') return value;
    return value.replace(/\\/g, '\\\\')  // backslash
                .replace(/ /g, '\\ ')    // space
                .replace(/\n/g, '\\n')   // newline
                .replace(/\r/g, '\\r')   // carriage return
                .replace(/\t/g, '\\t');  // tab
}

function generateConfig( wifiConfig, ipConfig ){
    var form = document.querySelector('form'),
        data = Object.fromEntries(new FormData(form).entries()),
        xmlDoc = parser.parseFromString(defaultXMLString, 'text/xml'),
        root = xmlDoc.getElementsByTagName('configuration')[0],
        node, param, iwd = '';

    console.debug(data);

    // Wi-Fi access point configuration    
    node = xmlDoc.createElement('wifi-ap-reset');
    root.appendChild(node);
    
    if ( wifiConfig ){
        node = xmlDoc.createElement('wifi-ap-add');
        param = xmlDoc.createElement('ssid');
        param.innerHTML = data.ssid;
        node.appendChild(param);
        param = xmlDoc.createElement('method');
        param.innerHTML = data.authentication;
        node.appendChild(param);

        if (data.hidden || data.authentication !== 'open') {
            iwd = '[Settings]\nHidden=' + (data.hidden === 'on' ? 'true' : 'false');
            if (data.authentication === 'psk') {
                iwd += '\n\n[Security]\nPassphrase=' + escapeValue(data.password);
            } else if (data.authentication === '8021x') {
                iwd += '\n\n[Security]\nEAP-Method=PEAP\nEAP-Identity=' + escapeValue(data.identity);
                iwd += '\nEAP-PEAP-Phase2-Method=MSCHAPV2\nEAP-PEAP-Phase2-Identity=' + escapeValue(data.identity);
                iwd += '\nEAP-PEAP-Phase2-Password=' + escapeValue(data.password);
                if (pem) {
                    iwd += '\nEAP-PEAP-CACert=embed:cacert\n\n[@pem@cacert]\n' + pem;
                }
            }
            iwd += '\n';
            console.debug(iwd);
            param = xmlDoc.createElement('base64-file');
            param.innerHTML = window.btoa(String.fromCharCode.apply(null, encoder.encode(iwd)));
            node.appendChild(param);
        }
        root.appendChild(node);
    }
    if (ipConfig){
        // Wi-Fi IPv4 configuration
        if (data.type == 'dhcp') {
            root.appendChild(xmlDoc.createElement('wifi-dhcp'));
        } else if (data.type == 'static') {
            node = xmlDoc.createElement('wifi-static');
            param = xmlDoc.createElement('address');
            param.innerHTML = data.ip;
            node.appendChild(param);
            param = xmlDoc.createElement('netmask');
            param.innerHTML = data.netmask;
            node.appendChild(param);
            param = xmlDoc.createElement('gateway');
            param.innerHTML = data.gateway;
            node.appendChild(param);
            root.appendChild(node);

            if (data.dns || data.dns2 || data.dns3) {
                node = xmlDoc.createElement('dns-manual');
                if (data.dns) {
                    param = xmlDoc.createElement('dns');
                    param.innerHTML = data.dns;
                    node.appendChild(param);
                }
                if (data.dns2) {
                    param = xmlDoc.createElement('dns2');
                    param.innerHTML = data.dns2;
                    node.appendChild(param);
                }
                if (data.dns3) {
                    param = xmlDoc.createElement('dns3');
                    param.innerHTML = data.dns3;
                    node.appendChild(param);
                }
                if (data.domain) {
                    param = xmlDoc.createElement('domain');
                    param.innerHTML = data.domain;
                    node.appendChild(param);
                }
            } else {
                node = xmlDoc.createElement('dns-automatic');
            }
            root.appendChild(node);
        }

        root.appendChild(xmlDoc.createElement('reboot'));
    }
    // generate the configuration file
    return serializer.serializeToString(xmlDoc);

}
const connectDelay = 2500;
function connect(retry = 0) {
    document.getElementById('footer').innerHTML = 'Checking wifi setup...';
    const ssid = document.getElementById('ssid').value;
    rpc("wifi_connect", [ssid], function(error, response){
        document.getElementById('footer').innerHTML = 'Wifi setup checked';
        if ( error ) {
            if (error === `Network '${ssid}' not found` && retry < 71) {
                setTimeout(connect, connectDelay, retry + 1);
                return;
            }
            document.getElementById('submitanyway').style.display = 'block';
            document.getElementById('footer').innerHTML = error;
            document.getElementById('statusstring').innerHTML = "Connection failed, check password";

            const xmlString = generateConfig( );
            document.getElementById('footer').innerHTML = 'Reset wifi setup...';
            rpc("set_config", [{ "xmlconfig": xmlString }], function(error, response){
                document.getElementById('footer').innerHTML = 'Wifi setup reset';
            });
        } else {
            appplyIpConfig();
        }
    });
}
function generate(){
    // generate the configuration file for wifi
    const xmlString = generateConfig( true );
    console.debug(xmlString);

    document.getElementById('status').style.display = 'block';
    document.getElementById('submitanyway').style.display = 'none';
    document.getElementById('submit').style.display = 'none';
    document.getElementById('statusstring').innerHTML = "Connecting... This may take a moment. Do not close the page.";
    document.getElementById('footer').innerHTML = 'Connecting...';
    rpc("set_config", [{ "xmlconfig": xmlString }], function(error, response){
        document.getElementById('footer').innerHTML = 'Wifi Setup send';
        if ( response && response.success ){
            // check if user cann connect to wifi
            document.getElementById('footer').innerHTML = 'Applying wifi setup...';
            setTimeout(connect, connectDelay);
        } 
        if ( error ){
            document.getElementById('footer').innerHTML = error;
            document.getElementById('statusstring').innerHTML = "Wifi setup not applied";            
        }
    });    
}
function cancel( ) {    
    document.getElementById('status').style.display = 'none';
    document.getElementById('submitanyway').style.display = 'none';
    document.getElementById('submit').style.display = 'block';
}
    
function getCertificate(event) {
    var file = event.target.files[0],
        reader = new FileReader(),
        regex = /^-----BEGIN (X509 |TRUSTED |)CERTIFICATE-----/;

    if (typeof (FileReader) != 'undefined') {
        reader.onload = function (e) {
            pem = e.target.result || '';
            if (!regex.test(pem)) {
                alert('Invalid certificate - only X509 certificates are supported.')
                pem = '';
            } else {
                pem = pem.replace(/\r\n/gi, '\n').replace(/\r/gi, '\n');
                if (!pem.endsWith('\n')) {
                    pem += '\n';
                }
            }
        }
        reader.readAsText(file);
    } else {
        alert('Cannot load the certificate, as this browser does not support HTML5 FileReader API.');
    }
}
    
function downloadFile(contentType, data, filename) {
    var link = document.createElement('A');
    link.setAttribute('href', encodeURI('data:' + contentType + ',' + data));
    link.setAttribute('style', 'display:none');
    link.setAttribute('download', filename);
    document.body.appendChild(link); //needed for firefox
    link.click();
    setTimeout(function () {
        document.body.removeChild(link); //only to remove the temporal link
    }, 1000);
}

function updateAuthFields(value){
    var passwordField = document.getElementById('passwordField'),
        userField = document.getElementById('userField'),
        certField = document.getElementById('certField'),
        identity = document.getElementById('identity'),
        password = document.getElementById('password');
    
    switch(value){
        case 'psk':
            methodFields.style.display = 'none';
            userField.style.display = 'none';
            passwordField.style.display = 'block';
            certField.style.display = 'none';
            identity.required = '';
            password.required = 'required';
            password.setAttribute('minlength', 8);
            password.setAttribute('maxlength', 63);
            break;
        case '8021x':
            methodFields.style.display = 'block';
            userField.style.display = 'block';
            passwordField.style.display = 'block';
            certField.style.display = 'block';
            identity.required = 'required';
            password.required = 'required';
            password.removeAttribute('minlength');
            password.removeAttribute('maxlength');
            break;
        default:
            methodFields.style.display = 'none';
            userField.style.display = 'none';
            passwordField.style.display = 'none';
            certField.style.display = 'none';
            identity.required = '';
            password.required = '';
            password.removeAttribute('minlength');
            password.removeAttribute('maxlength');
    }
}
    
function showPassword(checked){
    document.getElementById('password').type = ( checked ? 'text' : 'password');
}

function showIPFields(show){
    if(show){
        document.getElementById('staticIPFields').style.display = 'block';
        document.getElementById('ip').required = 'required';
        document.getElementById('netmask').required = 'required';
        document.getElementById('gateway').required = 'required';
        document.getElementById('dns').required = 'required';
    } else {
        document.getElementById('staticIPFields').style.display = 'none';
        document.getElementById('ip').required = '';
        document.getElementById('netmask').required = '';
        document.getElementById('gateway').required = '';
        document.getElementById('dns').required = '';
    }
}

function selectSSID( ssid ){
    if ( ssid === "..." ){
        ssid = "";
        document.getElementById('ssidTextGroup').style.display = 'block';
    } else {
        document.getElementById('ssidTextGroup').style.display = 'none';
    }
    var sel = document.getElementById('selectssid')
    var opt = sel.options[sel.selectedIndex];
    var type = opt.getAttribute('data-type') || "psk";
    
    document.getElementById('authentication').value = type;
    updateAuthFields(type)    
    document.getElementById('ssid').value = ssid;
    cancel();
}
//]]></script>
</head>
<body>
<main>
    <form id="data" name="data" method="post" onsubmit="generate(); return false;" autocomplete="off" >
        <div id="status" style="display:none; text-align:center;" class="spacing">
            <span id="statusstring">Success</span>
        </div>
        <div id="wifiFields" style="display: block;" class="spacing">              
            <div id="ssidSelectGroup">
                <label for="selectssid">NETWORK</label>
                <select type="text" id="selectssid" name="ssid" minlength="1" required="required" placeholder="SSID" onchange="selectSSID(this.value)">                    
                </select>
            </div>
            <div id="ssidTextGroup">
                <div>
                <label for="ssid" class="required">NETWORK NAME</label><input type="text" id="ssid" name="ssid" minlength="1" required="required" placeholder="SSID" class="no-space-after"/>
                <input type="checkbox" id="hidden" name="hidden"/> <label for="hidden" class="pointer">Connect even if network is hidden</label>
                </div>
                <div class="spacing">
                    <label for="authentication" class="spacing" >AUTHENTICATION</label>                    
                    <select id="authentication" name="authentication" onchange="updateAuthFields(this.value)">
                        <option value="open">Open</option>
                        <option value="psk" selected="selected">Personal (PSK)</option>
                        <option value="8021x">Enterprise</option>
                    </select>
                </div>
            </div>                
        </div>
        <div id="methodFields" style="display: none;">
            <label for="method">METHOD</label>
            <select name="method" id="method">
                <option value="PEAP MSCHAPv2">PEAP MSCHAPv2</option>
            </select>
        </div>
        <div id="userField" style="display: none;">
            <label for="identity">USERNAME</label>                
            <input type="text" id="identity" name="identity"/>
        </div>
        <div id="passwordField" style="display: block;">
            <label for="password" class="required">PASSWORD</label>
            <input type="password" id="password" name="password" required autocomplete="off" onchange="cancel()" oninput="cancel()"/>
            <input type="checkbox" id="sp" name="sp" class="pointer" onchange="showPassword(this.checked)" /> <label for="sp">Show password</label>
        </div>
        <div id="certField" style="display: none;" class="spacing">
            <label for="fileUpload">CERTIFICATE</label>   
            <input type="file" id="fileUpload" class="pointer" accept=".pem,.crt" onChange="getCertificate(event)" />
        </div>

        <div class="spacing">
            <label for="type1">IPv4</label><br/>  
            <input type="radio" name="type" id="type1" value="dhcp" checked="checked" onchange="showIPFields(false)"/>
            <label for="type1" class="pointer">Automatic (DHCP)</label><br/>
            <input type="radio" name="type" id="type2" value="static" onchange="showIPFields(true)"/>
            <label for="type2" class="pointer">Manual</label>            
            <div id="staticIPFields" style="display: none;" class="spacing">
                <label for="ip" class="required">IP address</label>
                <input type="text" id="ip" name="ip" minlength="7" maxlength="15" size="15" pattern="^((\d{1,2}|1\d\d|2[0-4]\d|25[0-5])\.){3}(\d{1,2}|1\d\d|2[0-4]\d|25[0-5])$" placeholder="192.168.0.10"/>
                <label for="netmask" class="required">Netmask</label>
                <input type="text" id="netmask" name="netmask" minlength="7" maxlength="15" size="15" pattern="^((\d{1,2}|1\d\d|2[0-4]\d|25[0-5])\.){3}(\d{1,2}|1\d\d|2[0-4]\d|25[0-5])$" placeholder="255.255.255.0" />
                <label for="gateway" class="required">Gateway</label>
                <input type="text" id="gateway" name="gateway" minlength="7" maxlength="15" size="15" pattern="^((\d{1,2}|1\d\d|2[0-4]\d|25[0-5])\.){3}(\d{1,2}|1\d\d|2[0-4]\d|25[0-5])$" placeholder="IP"/>
                <label for="dns" class="required">DNS server</label>
                <input type="text" id="dns" name="dns" minlength="7" maxlength="15" size="15" pattern="^((\d{1,2}|1\d\d|2[0-4]\d|25[0-5])\.){3}(\d{1,2}|1\d\d|2[0-4]\d|25[0-5])$" placeholder="IP" />
                <label for="dns2">DNS server #2</label>
                <input type="text" id="dns2" name="dns2" minlength="7" maxlength="15" size="15" pattern="^((\d{1,2}|1\d\d|2[0-4]\d|25[0-5])\.){3}(\d{1,2}|1\d\d|2[0-4]\d|25[0-5])$" placeholder="IP (optional)" />
                <label for="dns3">DNS server #3</label>
                <input type="text" id="dns3" name="dns3" minlength="7" maxlength="15" size="15" pattern="^((\d{1,2}|1\d\d|2[0-4]\d|25[0-5])\.){3}(\d{1,2}|1\d\d|2[0-4]\d|25[0-5])$" placeholder="IP (optional)" />
                <label for="domain">DNS suffix</label>
                <input type="text" id="domain" name="domain" placeholder="Domain name (optional)" />
            </div>
        </div>
        <input type="submit" id="submit" value="Apply" class="btn spacing"/>
        
        <div id="submitanyway" style="display:none;" class="spacing">
            <input onclick="appplyIpConfig(); return false;"  value="Apply Anyway" class="btn"/>
            <input onclick="cancel();" value="Cancel" class="btn"/>
        </div>
    </form>
</main>

</body>
<footer id="footer">
<?php
echo $serial .
    "<br/>" .
    $firwmare .
    "-" .
    $build .
    "<br/>\n";

echo "Wizard: " .
    (isWizard() ? "yes" : "no") .
    "; Logged: " .
    (isLoggedUser() ? "yes" : "no") .
    "\n";
?>
    </footer>
</html>
