<?php

/*
 * Automatic test
 */
include_once "Helpers.php";

class PlaylistTest extends CDbTestCase {
    
    public function checkListDesc( $desc, $data=null ){
        
        $this->assertArrayHasKey( 'id', $desc, print_r( $desc, true ) );
        $name = "\nid: ".$desc['id'];
        
        $this->assertArrayHasKey( 'name', $desc, print_r( $desc, true ) );
        $this->assertArrayHasKey( 'type', $desc, print_r( $desc, true ) );
        $this->assertEquals($desc['type'], "playlist" );
        Helpers::checkKeywords( $this, $desc, $data, $name );
        
        $this->assertArrayHasKey( 'href', $desc, print_r( $desc, true ) );
        $this->assertArrayHasKey( 'manage', $desc, print_r( $desc, true ) );
        $this->assertArrayHasKey( 'previews', $desc, print_r( $desc, true ) );
        Helpers::checkPreviews( $this, $desc['previews'] );
        
        if ( $data ) {
            $this->assertEquals($data['id'], $desc['id'] );
            $this->assertEquals($data['name'], $desc['name'] );        
            $this->assertEquals(
                    GlobalSettings::$uriBase."playlist/".$data['id']."/", 
                    $desc['manage'] );
            $this->assertEquals(
                    GlobalSettings::$hrefBase."playlist/".$data['id']."/playlist.svg", 
                    $desc['href'] );
        }
        // check that the file exist
        $len = strlen( GlobalSettings::$hrefBase );
        $path = GlobalSettings::$fileBase . substr($desc['href'], $len );
        $this->assertTrue( file_exists( $path ), 
                "file $path do not exist\n" );
    }
    
    public function checkDesc( $desc, $data=null ){
        $name = $desc['id'];
        $this->checkListDesc( $desc, $data );
        
        if ( isset( $desc['parents'] )){
            foreach ( $desc['parents'] as $parent )
                Helpers::checkParent( $this, $parent, $name );
        }  
        Helpers::checkPlaylist( $this, $desc, $name );       
    }
    
    public function testPrepareMedia(  ) {
        $nbMedia = 2;
        $nbSlide = 2;
        $options = array( 'format' => 'jpg', 'width'=>100, 'height'=>100, );
        
        $media = array();
        for( $i=0; $i<$nbMedia; $i++ )
            $media[] = Helpers::createMedia( $this, "media $i", $options );
        return $media;
    }
    /**
     * @depends testPrepareMedia
     */
    public function testCreate( $media_id ) {
        $media = array();
        foreach ( $media_id as $id ){
            $media[] = array (
                'id' => $id,
                'type' => 'media',
                'dur' => 10,
                'schedule' => array(
                    'beginDate' => '2010-01-01T00:00:00',
                    'endDate' => '2020-12-31T23:59:59',
                    'validityZones' => array (
                        array(
                            'beginTime' => '00:00:00',
                            'endTime' => '23:59:59',
                            'beginDay' => 0,
                            'endDay' => 1,
                            ),
                        array(
                            'beginTime' => '00:00:00',
                            'endTime' => '23:59:59',
                            'beginDay' => 2,
                            'endDay' => 6,
                            )
                    )
                ),
            );
        }
        $data = array (
            'name' => 'test',
            'keywords' => array( 'test', 'auto' ),
            'options' => array (
                'defaultDur' => 30,
                'transition' => array (
                    'ctor'=> 'random',
                    'args' => array (
                        'dur' => 1
                    )
                ),
                'looping' => false,
                'shuffle' => false
            ),
            'media' => $media
        );
        
        $model = new Playlist;
        $model->attributes = $data;
        $ok = $model->save();
        $this->assertTrue( $ok, print_r( $model->getErrors(), true ) );
        
        $data['id'] = $model->id;
        
        $this->checkListDesc( $model->listDesc, $data );
        $this->checkDesc( $model->desc, $data );        
        
        return $data;
    }
    
    /**
     * @depends testCreate
     */
    public function testGet( $data ) {
        
        $id = $data['id'];
        // verify that the resource has been created, by re-loading it from the db

        $model = Playlist::model()->findByPk( $id );
        $this->assertNotSame( null, $model );
        $this->assertInstanceOf( 'Playlist', $model );
        
        $this->checkListDesc( $model->listDesc, $data );
        $this->checkDesc( $model->desc, $data );     
        
    }
    
    /**
     * @depends testCreate
     */
    public function testList( $data ) {
        
        $id = $data['id'];
        // verify that the resource has been created, by re-loading it from the db
        $models = Playlist::model()->findAll();
        
        $this->assertTrue( is_array($models) );
        $this->assertTrue( count($models)>0 );
        $has_id = false;
        foreach ( $models as $model ){
            $this->assertTrue($model instanceof Playlist);
            if ( $model->id==$id )
                $has_id = true;
            $this->checkDesc( $model->desc );        
            $this->checkListDesc( $model->listDesc );
        }
        $this->assertTrue( $has_id );
    }
    /**
     * @depends testCreate
     */
    public function testDelete( $data ) {
        
        $id = $data['id'];
        $model = Playlist::model()->findByPk( $id );
        $this->assertInstanceOf( 'Playlist', $model );
        
        $folder = $model->folder;
        
        $this->assertTrue( $model->delete() );
        
        $new_model = Media::model()->findByPk( $id );
        $this->assertNull( $new_model );
        
        $this->assertFalse( file_exists( $folder ) );
    }
    /**
     * @depends testPrepareMedia
     */
    public function testRemoveMedia( $media_id ) {
        foreach ( $media_id as $id ){
            Helpers::removeMedia( $this, $id );
        }        
    }
    
    public function testDependencyDelete(  ) {
        $options = array( 'format' => 'jpg', 'width'=>100, 'height'=>100, );
        $nbMedia = 3;
        $ids = array();
        $data = array (
            'name' => "some name",
            'keywords' => array( 'test', 'auto', 'delete' ),
            'media' => array() 
        );
        for( $i=0; $i<$nbMedia; $i++ ){
            $id = Helpers::createMedia( $this, "media $i", $options );
            $data['media'][]=array(
                'id'=> $id,
                'type' => 'media'
            );
            $ids[] = $id;
        }
        
        $model = new Playlist;
        $model->attributes = $data;
        $this->assertTrue( $model->save() );
        $this->assertFalse( $model->hasErrors() );

        $data['id'] = $model->id;
        $this->checkDesc( $model->desc, $data );        
        $this->checkListDesc( $model->listDesc, $data );
        $media =  $model->media;
        $this->assertEquals( count($ids), count($media) );
        foreach( $ids as $idx=>$id ){
            $this->assertArrayHasKey( 'id', $media[$idx] );
            $this->assertEquals( $id, $media[$idx]['id'] );
            
            
        }
        
        // delete the media
        while ( count( $ids )>0 ){
            $id = array_pop($ids);
            $m = Media::model()->findByPk($id );
            $this->assertInstanceOf( 'Media', $m );
             // check that the media has some parents
            Helpers::checkMediaParents( $this, $m->desc, $model->id );
            $this->assertTrue( $m->delete() );
            
            $new_model =  Playlist::model()->findByPk( $model->id );
            $this->assertInstanceOf( 'Playlist', $new_model );           
            $this->assertEquals( count($ids), count($new_model->media) );
            foreach( $ids as $idx=>$id ){
                $this->assertArrayHasKey( 'id', $new_model->media[$idx] );
                $this->assertEquals( $id, $new_model->media[$idx]['id'] );
            }
        }
        
        $this->assertTrue( $model->delete() );
    }
    
    public function testDependencyCreate(  ) {
        $options = array( 'format' => 'jpg', 'width'=>100, 'height'=>100, );
        $nbMedia = 3;
        $ids = array();
        $data = array (
            'name' => "some name",
            'keywords' => array( 'test', 'auto', 'create' )
        );
        $model = new Playlist;
        $model->attributes = $data;
        $this->assertTrue( $model->save() );
        $this->assertFalse( $model->hasErrors() );
        
        $data['id'] = $model->id;
        $this->checkDesc( $model->desc, $data );        
        $this->checkListDesc( $model->listDesc, $data );
        
        $media = $model->media;
        $this->assertEquals( 0, count($media) );
        
        $data2 = array();
        for( $i=0; $i<$nbMedia; $i++ ){
            $id = Helpers::createMedia( $this, "media $i", $options );
            $data2['media'][]=array(
                'id' => $id,
                'type' => 'media'
            );
            $ids[] = $id;
            
            $model->attributes = $data2;
            $this->assertTrue( $model->save() );
            $this->assertFalse( $model->hasErrors() );
            
            $media =  $model->media;
            $this->assertEquals( count($ids), count($media) );
            foreach( $ids as $idx=>$id ){
                $this->assertArrayHasKey( 'id', $media[$idx] );
                $this->assertEquals( $id, $media[$idx]['id'] );
            }
            
            $new_model =  Playlist::model()->findByPk( $model->id );
            $this->assertInstanceOf( 'Playlist', $new_model );
            
            $this->checkDesc( $new_model->desc, $data );        
            $this->checkListDesc( $new_model->listDesc, $data );
            $this->assertEquals( count($ids), count($new_model->media) );
            
            $m = Media::model()->findByPk( $id );
            $this->assertInstanceOf( 'Media', $m );
            Helpers::checkMediaParents( $this, $m->desc, $model->id );
            
        }
        // delete the playout without deleting children first
        $this->assertTrue( $model->delete() );
        
        // delete the media
        while ( count( $ids )>0 ){
            $id = array_pop($ids);
            $m = Media::model()->findByPk( $id );
            $this->assertInstanceOf( 'Media', $m );            
             // check that the media do not have parents
            $this->assertArrayNotHasKey( 'parents', $m->desc );
            $this->assertTrue( $m->delete() );            
        }
    }
    
    
    public function createErrorsProvider()
    {
        return array(
            array( array( // just name
                        'name' => 'utf8ä中企',
                        'keywords' => array( 'test', 'auto', 'x-utf8ä中企' )
                    ), null, true ),
            array( array( // name and option
                        'name' => 'simple',
                        'options' => array (
                            'defaultDur' => 1,                                                        
                        )
                    ), null, true ),
            array( array( // transition
                        'name' => 'simple',
                        'options' => array (
                            'transition' => array (
                                'ctor'=> 'random',
                                'args' => array (
                                    'dur' => 1
                                )
                            ),                            
                        )
                    ), null, true ),
            array( array( // one media
                        'name' => 'simple',
                ), array( 
                        array() 
                ), true ),
            array( array( // 3 media
                        'name' => 'simple',
                ), array( 
                        array( 'dur' => 1  
                     ), array( 'schedule' => array(
                                'beginDate' => '2010-01-01T00:00:00',
                                'endDate' => '2020-12-31T23:59:59',                                    
                                )
                     ), array( 'schedule' => array(
                                'validityZones' => array (
                                    array(
                                        'beginTime' => '00:00:00',
                                        'endTime' => '23:59:59',
                                        'beginDay' => 0,
                                        'endDay' => 1,
                                        ),
                                )
                    ))
                ), true ),
            array( array( 
                        'name' => 'simple',
                ), array( 
                        array( 'schedule' => array(
                                'beginDate' => '2010-01-01T00:00:00.000',
                                'endDate' => '2020-12-31T23:59Z',                                    
                                )
                        )
                ), true ),
            array( array( // no name
                    ), null, false ),
            array( array( // duration not a number
                        'name' => 'simple',
                        'options' => array (
                            'defaultDur' => "24s",                                                        
                        )
                    ), null, false ),
            array( array( // missing params for transitions
                        'name' => 'simple',
                        'options' => array (
                            'transition' => array (
                                'ctor'=> 'random',                                
                            ),                            
                        )
                    ), null, false ),
            array( array( // wrong options
                        'name' => 'simple',
                        'options' => "dummy",                                                    
                    ), null, false ),
            array( array( 'name' => 'simple',
                ), array( // not an ID
                        array( 'id' => 'wrong' ) 
                ), false ),
            array( array( 'name' => 'simple',
                ), array( // not existing id
                        array( 'id' => 123456789 ) 
                ), false ),
            array( array( 'name' => 'simple',
                ), array( 
                        array( 'schedule' => "dummy"
                     )
                ), false ),
            array( array( 'name' => 'simple',
                ), array( 
                        array( 'schedule' => array(
                                'beginDate' => 'wrong',                                    
                                )
                     )
                ), false ),
            array( array( 'name' => 'simple',
                ), array( 
                        array( 'schedule' => array(
                                'endDate' => 'wrong',                                    
                                )
                     )
                ), false ),
            array( array( 'name' => 'simple',
                ), array( 
                        array( 'schedule' => array(
                                'validityZones' => "dummy"                                   
                                )
                     )
                ), false ),
            array( array( 'name' => 'simple',
                ), array( 
                        array( 'schedule' => array(
                                'validityZones' => array (
                                    array(
                                        'beginTime' => 'dummy',                                        
                                        ),
                                 )                                    
                                )
                     )
                ), false ),
            array( array( 'name' => 'simple',
                ), array( 
                        array( 'schedule' => array(
                                'validityZones' => array (
                                    array(
                                        'endTime' => 'dummy',
                                        ),
                                 )                                    
                                )
                     )
                ), false ),
            array( array( 'name' => 'simple',
                ), array( 
                        array( 'schedule' => array(
                                'validityZones' => array (
                                    array(
                                        'beginDay' => 'dummy',
                                        ),
                                 )                                    
                                )
                     )
                ), false ),
            array( array( 'name' => 'simple',
                ), array( 
                        array( 'schedule' => array(
                                'validityZones' => array (
                                    array(
                                        'endDay' => 'dummy',
                                        ),
                                 )                                    
                                )
                     )
                ), false ),
            array( array( 'name' => 'simple',
                ), array( 
                        array( 'schedule' => array(
                                'validityZones' => array (
                                    array( ),
                                 )                                    
                                )
                     )
                ), true ),
            );
    }
    /**
     * @dataProvider createErrorsProvider
     * @depends testDelete
     */
    public function testCreateErrors( $data, $media, $success ) {
        $options = array( 'format' => 'jpg', 'width'=>100, 'height'=>100, );
        $ids = array();
        if ( $media ){
            $i = 0;
            for( $i=0; $i<count($media); $i++ ){
                if ( !isset($media[$i]['id']) ){
                    $media[$i]['id'] = Helpers::createMedia( $this, "media $i", $options ); 
                    $media[$i]['type'] = 'media';
                    $ids[] = $media[$i]['id'];
                }
            }
            $data['media'] = $media;
        }        
        
        $model = new Playlist;
        $model->attributes = $data;
        
        $ok = $model->save();
        
        if ( $success ){
            $this->assertTrue( $ok, print_r( $model->getErrors(), true ) );
            $this->assertFalse( $model->hasErrors() );
        
            $data['id'] = $model->id;
            $this->checkDesc( $model->desc, $data );        
            $this->checkListDesc( $model->listDesc, $data );            
            $this->assertTrue( $model->delete() );
            
        } else {
            $this->assertFalse( $model->save() );        
            $this->assertTrue ( $model->hasErrors() );            
        }
        if ( $media ){
            foreach ( $ids as $id ){                
                $model = Media::model()->findByPk($id );
                $this->assertInstanceOf( 'Media', $model );                
                $this->assertTrue( $model->delete() );
            }
        }
    }
}
