<?php
/* @var $this ConfigController */


$formConfig = $this->beginWidget('SimpleForm', array( 
    'title' => "Scheduled Download",
    'id' => "Download",
    'button' => "Apply",
    'action' => array ( 'post' => array() )
) );
    $formConfig->errorSummary( $pullModeConfig );
    echo CHtml::tag("div", array("data-bind"=> "visible: canSimple"), 
        $formConfig->items("Settings", array( CHtml::dropDownList( "", "", array( 'simple' => 'Simple', 'advanced' => 'Advanced' ), $formConfig->itemOptions( array(
            "data-bind" => "bootstrapSelect: scheduledMode",        
        ) ) ) ) )
    );
    $ns = new SyncSource;
    $headers = array( 
        //$ns->getAttributeLabel( "dest"),
        $ns->getAttributeLabel( "uri"),
        $ns->getAttributeLabel( "update"),        
        "",
        ""
    );
    $options = array(
        "data-bind" => "foreach: syncSources",
        "sizes" => array( "col-sm-8", "col-sm-2", "col-sm-1", "col-sm-1" ),
        'class' => 'spx-multirow-table'
    );
    $row = array();
    /*
    $row[] = CHtml::textField( "", "", $formConfig->itemOptions( array(
        "data-bind" => "value: dest, attr: { name: 'SyncSource['+\$index()+'][dest]'}"
    ) ) );         
     */
    $row[] = CHtml::textField( "", "", $formConfig->itemOptions( array(
                "data-bind" => "value: uri, attr: { name: 'SyncSource['+\$index()+'][uri]'}",
                'placeholder' => "http://SomeServer/SomePath/"
            ) ) ). 
            $this->widget('BsRow', array( 
                'options' => array( "style" => "margin-top: 7px;", "data-bind" => "visible: \$parent.scheduledMode() === 'advanced' "  ),
                'cols' => array(
                array( 'size' => 4, 'content'=>CHtml::checkBox("", "", $formConfig->itemOptions( array(
                    "data-bind" => "iCheck: norecurs, attr: { name: 'SyncSource['+\$index()+'][norecurs]'}",                
                ) ) ) . " " .$ns->getAttributeLabel( "norecurs" ) ),
                array( 'size' => 8, 'content'=>CHtml::textField( "", "", $formConfig->itemOptions( array(
                    "data-bind" => "value: dest, attr: { name: 'SyncSource['+\$index()+'][dest]'}",
                    'placeholder' => $ns->getAttributeLabel( "dest")
                ) ) ) ), 
                
            )), true );
    
    $row[] = CHtml::dropDownList( "", "", array( 'manual' => 'Manual', 'hourly' => 'Hourly', 'daily' => 'Daily' ), $formConfig->itemOptions( array(
                "class" => "selectpicker",
                "data-bind" => "value: update, attr: { name: 'SyncSource['+\$index()+'][update]'}",
            ) ) ) . 
            "<br/>" . 
            CHtml::textField( "", "", $formConfig->itemOptions( array(
                "data-bind" => "value: time, attr: { name: 'SyncSource['+\$index()+'][time]'}, hidden: update()!='daily'",
                'placeholder' => "00:00",
                "style" => "margin-top: 7px;"
            ) ) );
    $row[] = CHtml::link( CHtml::tag("i", array( "class" => "fa fa-refresh"), "" ), array( 'operation/httpPublish'), array(
        "data-bind" => "click: \$parent.syncNow, css: { disabled: uri() == ''}",
        "class" => "btn btn-sm btn-default btn-block"
    ) );
    $row[] = CHtml::link( CHtml::tag("i", array( "class" => "fa fa-times"), "" ), "#", array(
        "data-bind" => "click: \$parent.removeSyncSource, css: { disabled: \$parent.syncSources().length === 1 && obs === true && dest() === '' && uri() == ''}",
        "class" => "btn btn-sm btn-warning btn-block"
    ) );
    $this->widget('BsRow', array( 
        'options' => array( 'class' => 'form-group'),
        'content' => $formConfig->table( $headers, array( $row ), $options) 
    ));    
    $this->widget('BsRow', array( 'cols' => array( 
        array( 'size' => 3, 
            'content' => CHtml::link( "Add", "#", array(
                            "data-bind" => "click: addSyncSource, visible: scheduledMode() === 'advanced' ",
                            "class" => "btn btn-sm btn-default btn-block"
                        ))
            )
    )));
    
$this->endWidget();


?>
<script type="text/javascript" >
//<![CDATA[


yiiModel.addSyncSource = function() {
    yiiModel.syncSources.push({ dest: ko.observable(''), norecurs: ko.observable( 0 ), uri:ko.observable(''), update:ko.observable(''), time:ko.observable(''), obs: true });
};
yiiModel.syncSources = ko.observableArray( <?php
    $syncSources = array();
    $simple = true;
    foreach ($pullModeConfig->syncSources as $i => $source ){
        $syncSources[] = array(
            "dest" => "js:ko.observable('".$source->dest."')",
            "norecurs" => "js:ko.observable(".$source->norecurs.")",
            "uri" =>  "js:ko.observable('".$source->uri."')",
            "update" => "js:ko.observable('".$source->update."')",
            "time" => $source->time,
            "obs" => false
        );
        if ( $i>1 || $source->norecurs || $source->dest != "" ){
            $simple = false;
        }
    }
    if ( count($pullModeConfig->syncSources) == 0 ){
        $syncSources[] = array(
            "dest" => "js:ko.observable('')",
            "norecurs" => "js:ko.observable( 0 )",
            "uri" => "js:ko.observable('')",
            "update" => "js:ko.observable('')",
            "time" => "js:ko.observable('')",
            "obs" => true
        );
    }
    echo CJavaScript::encode( $syncSources );
?> );

yiiModel.removeSyncSource = function() {
    if ( yiiModel.syncSources().length > 1 ){
        yiiModel.syncSources.remove(this);
    } else {
        yiiModel.syncSources( [ { dest: ko.observable(''), norecurs: ko.observable( 0 ), uri:ko.observable(''), update:ko.observable(''), time:ko.observable(''), obs: true} ] );
    }
};
yiiModel.canSimple = ko.computed( function() {
    if ( yiiModel.syncSources().length>1 ){
        return false;
    } else if ( yiiModel.syncSources().length === 1 ){
        var src = yiiModel.syncSources()[0];
        if ( src.dest() !== "" || src.norecurs()  ){
            return false;
        } 
    } 
    return true;
});
yiiModel.scheduledMode = ko.observable( yiiModel.canSimple()?'simple':'advanced' );

yiiModel.syncNow = function(model, ev) {
    var btn = $(ev.currentTarget);
    var source = ko.unwrap( this.uri );
    var options = {
        url: btn.attr("href"),
        type: 'POST',
        data: {
            action: 'publish',
            uri : ko.unwrap( this.uri ),
            dest : ko.unwrap( this.dest ),
            norecurs: ko.unwrap( this.norecurs )?1:0
        }
    };
    var publishId = null;
    var publishInfoId = null;
    function checkPublish(){
        options.data.action = 'status';
        options.data.id = publishId;
        yiiModel.doAjax( yiiModel, ev, options, function( ev, response ){
            if ( response.data.state === 'finished' ) {
                spxapi.ui.removeMessage( publishInfoId );
                var txt = "Statistics:<ul>";
                txt += "<li>Uploaded: " + response.data.file_cnt.new +" file(s)</li>"; 
                txt += "<li>Modified: " + response.data.file_cnt.modified +" file(s)</li>";
                txt += "<li>Deleted: " + response.data.file_cnt.deleted +" file(s)</li>";
                txt += "<li>Total transfered: " + response.data.total_bytes/1000 +" Kbytes</li>";
                txt += "</ul>";
                publishInfoId = spxapi.ui.message( { 
                    title: "Download Finished", 
                    type: "info", 
                    sticky: false,
                    text: txt
                } );
            } else {
                setTimeout( checkPublish ,10000);
            }
        }, function() {
            spxapi.ui.removeMessage( publishInfoId );
        });
    }
    yiiModel.doAjax( yiiModel, ev, options, function( ev, response ){
        publishId = response.data;
        publishInfoId = spxapi.ui.message( { 
            type: 'info', 
            sticky: true,
            text: "Download Started"
        } );
        setTimeout( checkPublish ,10000);
    });
    return false;
};

//]]></script>
