<?php
/* @var $this ConfigController */


$touchConfig = $this->beginWidget('SimpleForm', array( 
    'title' => "Touchscreen",
    'id' => "Touchscreen",
    'button' => array( "Apply", array( 'data-bind' => 'visible: events') ),
    'action' => array ( 'post' => array(  ) )
) );
    $touchConfig->errorSummary( $touchCalibration ); 
    echo CHtml::openTag("div", array( 'data-bind' => 'visible: events') );
    $this->widget( 'DialogButton' , array(
        'rowOptions' => array('data-bind' => 'hidden: calibration'),
        'label' =>'Start Calibration',
        'link' => array("operation/calibration", "start" => 1 ),
        'ko' => 'doCalibration',
        'level' => BsHtml::ALERT_COLOR_INFO,
        'content' => "You can automatically configure the parameters bellow using the automatic touchscreen calibration procedure.",
    ));
    $this->widget( 'DialogButton' , array(
        'rowOptions' => array('data-bind' => 'visible: calibration'),
        'label' =>'Stop Calibration',
        'link' => array("operation/calibration", "stop" => 1 ),
        'ko' => 'doCalibration',
        'level' => BsHtml::ALERT_COLOR_INFO,
        'content' => BsHtml::bold("Touchscreen calibration in progress."). " " .
                                "Please follow the instruction on the screen."
    ));      
    echo $touchConfig->items( null, array(        
        $touchConfig->activeTextField($touchCalibration, "xx", array(), true ),
        $touchConfig->activeTextField($touchCalibration, "xy", array(), true ),
        $touchConfig->activeTextField($touchCalibration, "tx", array(), true ),
    ),array( "col-md-offset-6 col-md-2 col-xs-4", "col-md-2 col-xs-4", "col-md-2 col-xs-4" ) );
    echo $touchConfig->items( null, array(
        $touchConfig->activeTextField($touchCalibration, "yx", array(), true ),
        $touchConfig->activeTextField($touchCalibration, "yy", array(), true ),
        $touchConfig->activeTextField($touchCalibration, "ty", array(), true ),
    ),array( "col-md-offset-6 col-md-2 col-xs-4", "col-md-2 col-xs-4", "col-md-2 col-xs-4" ) );
    echo CHtml::closeTag("div");
    
    echo BsHtml::alert( BsHtml::ALERT_COLOR_INFO, "Events must be enabled (above) to use touchscreens.", array( 'data-bind' => 'hidden: events'));
    
$this->endWidget();



$this->observable("calibration", $touchCalibration->isCalibrationOn() );

?>
<script type="text/javascript" >
//<![CDATA[

yiiModel.doCalibration = function( model, ev ) {
    yiiModel.doAjaxButton( model, ev, 
        function( ev, response ) {
            yiiModel.calibration( response.data );
        }
    );
};
//]]></script>