<?php
/* @var $this ConfigController */

$formConfig = $this->beginWidget('SimpleForm', array(
    'title' => 'Output Streaming',
    'id' => 'Streaming',
    'button' => 'Apply',
    'action' => array('post' => array('enctype' => 'multipart/form-data'))
));
    $formConfig->errorSummary($streaming);
    echo $formConfig->activeDropDownList($streaming, 'protocol', $streaming->getProtocols(), array(), true);
    echo CHtml::openTag('div', array('data-bind' => 'visible: protocol() != "' . Streaming::DISABLED . '" && protocol() != "' . Streaming::CUSTOM . '"'));
        echo $formConfig->activeDropDownList($streaming, 'resolution', $streaming->getResolutions());
        echo $formConfig->activeDropDownList($streaming, 'frameRate', $streaming->getFrameRates());
        echo $formConfig->activeDropDownList($streaming, 'quality', $streaming->getQualities());
    echo CHtml::closeTag('div');
    echo CHtml::openTag('div', array('data-bind' => 'visible: protocol() == "' . Streaming::IPTV . '"'));
        echo $formConfig->activeDropDownList($streaming, 'codec', $streaming->getCodecs());
        echo $formConfig->activeCheckBox($streaming, 'RTP');
        echo $formConfig->activeTextField($streaming, 'IP');
        echo $formConfig->activeTextField($streaming, 'port');
    echo CHtml::closeTag('div');
    echo CHtml::openTag('div', array('data-bind' => 'visible: protocol() == "' . Streaming::RTSP . '"'));
        echo $formConfig->activeCheckBox($streaming, 'multicast', array(), true);
        echo CHtml::openTag('div', array('data-bind' => 'visible: multicast()'));
            echo $formConfig->activeTextField($streaming, 'group');
        echo CHtml::closeTag('div');
        echo $formConfig->activeTextField($streaming, 'serverURL', array('readonly' => true));
    echo CHtml::closeTag('div');
    echo CHtml::openTag('div', array('data-bind' => 'visible: protocol() == "' . Streaming::RTMP . '"'));
        echo $formConfig->activeTextField($streaming, 'URL');
    echo CHtml::closeTag('div');
    echo CHtml::openTag('div', array('data-bind' => 'visible: protocol() == "' . Streaming::CUSTOM . '"'));
        echo $formConfig->activeFileField($streaming, 'file');
        if ($hasXML) {
            $this->widget('SimpleForm', array(
                'nbBox' => null,
                'defaultClass' => 'btn',
                'button' => 'Get Current Config',
                'action' => array('link' => array('StreamingDownloadXML'))
            ));
        }
    echo CHtml::closeTag('div');
$this->endWidget();
