<?php
class BackupStreaming extends Streaming {

    public function attributeNames() {
        $names = parent::attributeNames();
        $names[] = 'base64XML';
        return $names;
    }

    public function rules() {
        $rules = parent::rules();
        $rules[] = array('base64XML', 'validateBase64XML', 'on' => self::CUSTOM);
        return $rules;
    }

    public function validateBase64XML($attribute, $params) {
        if ($this->getXML() === false)
            $this->addError('XML', 'Invalid Base64 XML.');
    }

    public function save() {
        parent::save();
        Tools::addReason( 'streaming configuration change' );
    }

    public function getBase64XML() {
        return base64_encode($this->getXML());
    }

    public function setBase64XML($base64XML) {
        $this->_XML = base64_decode($base64XML);
    }
}
