<?php

require_once 'protected/utils/MainInfo.php';

class ARYAMode extends CFormModel
{
    public function rules()
    {
        $res = array(
            array("enabled", 'safe'),
        );
        return $res;
    }
    public function attributeLabels()
    {
        $labels = array(
            'enable' => "Enabled",
        );
        return $labels;
    }
    public function resetArya($enableCloudConnection = null)
    {
        $wizard = new Wizard();
        $maintenance = new Maintenance();

        $wizard->clearConfigured();
        $maintenance->resetPublishedContent();
        $maintenance->clearWebstorage();

        MaintenanceJobs::enableARYAMode();
        MaintenanceJobs::enableCloudConnection($enableCloudConnection);

        Tools::addReason("arya mode reset");
    }

    public function getEnabled()
    {
        $satus = getAryaStatus();
        return $satus == "yes";
    }

    public function isEnableUnknown()
    {
        $satus = getAryaStatus();
        return $satus == "unknown";
    }

    public function setEnabled($enabled = true)
    {
        if ($enabled) {
            MaintenanceJobs::enableCloudConnection($enabled);
        }
        MaintenanceJobs::enableARYAMode($enabled);
    }
}
