<?php

class checkNetmask extends CValidator  {
    public $allowEmpty = true;
    
    public function validateAttribute( $object, $attribute ){
        $value = $object->$attribute;
        if ( $this->allowEmpty && empty($value) ){
            return true;
        }
        $len = $this->net_mask_to_prefix( $value );
        if ( $len !== false && $len > 0 && $len < 32 ){
        } else {
            $object->addError($attribute,'Netmask format non valid or blank.');
        }
    }
    
    protected function net_mask_to_prefix($netmask)
    {
        $length = 0;
        $vals = explode('.', $netmask);
        if ( count($vals) != 4 )
            return false;
        $expect_zero = false;
        foreach ($vals as $val) {
            if ( ! is_numeric($val) || $val < 0 || $val > 255 )
                return false;
            if ($expect_zero) {
                if ($val != 0)
                    return false;
                else
                    continue;
            }
            switch ($val) {
            case 255:
                $length += 8; break;
            case 254:
                $length += 7; break;
            case 252:
                $length += 6; break;
            case 248:
                $length += 5; break;
            case 240:
                $length += 4; break;
            case 224:
                $length += 3; break;
            case 192:
                $length += 2; break;
            case 128:
                $length += 1; break;
            case 0:
                $length += 0; break;
            default:
                return false;
            }
            if ($val != 255)
                $expect_zero = true;
        }
        return $length;
    }
 
}