#
# spxmanage configuration file for the admin vhost
#
# this file is included from the <VirtualHost> declarations for the
# admin virtual host
#

DocumentRoot /usr/share/spxmanage/www

# We make use of RewriteRule, make sure it is enabled.
RewriteEngine on

# Add a rule to redirect all non-local plain HTTP accesses to HTTPS if
# configured and SSL is enabled and neither non-SSL nor SSL ports are
# limited to localhost.
<IfDefine NOSSL_REDIRECT>
    <IfDefine SSL>
        <IfDefine !NOSSL_LOCALHOST_ONLY>
            <IfDefine !SSL_LOCALHOST_ONLY>
                RewriteCond %{HTTPS} !=on
                RewriteCond %{SERVER_ADDR} !=127.0.0.1
                RewriteCond %{SERVER_ADDR} !=::1
                RewriteRule ^ https://${SSL_SUBJECT_NAME}%{REQUEST_URI} [NS,R,L]
            </IfDefine>
        </IfDefine>
    </IfDefine>
</IfDefine>

# Provide a default favicon to avoid repeated requests with 404 when
# accessing non-html resources with no explicit favicon link.
Alias /favicon.ico /usr/share/spxmanage/www/images/favicon.ico

# Access to logs via web interface
Alias /log/ /srv/raperca/log/

# This is the boot indicator, allows to detect the end of reboot
Alias /boot-id /var/cache/spxmanage/www/docs/boot-id

Alias /content/ /srv/raperca/content/
# Some WebDAV clients always chop off the trailing / in the initial request
# so we need to provide a redirect for them to work correctly. Note that
# redirect directives are always evaluated before alias directives.
RedirectMatch permanent ^/content$ /content/

Alias /capture/ /srv/raperca/capture/

# The official path for the RPC server is /rpc, so that we
# may move away from php if we desire.
Alias /rpc /usr/share/spxmanage/www/rpc.php

# Also to retrive the XML based info the official path is /info,
# so that we may move away from PHP if we desire.
Alias /info /usr/share/spxmanage/www/info.php

# The official path for the setup endpoint in /setup, so that we
# may move away from php if we desire.
Alias /setup /usr/share/spxmanage/www/setup.php

# The official path for the getconfig endpoint is /getconfig, so that we
# may move away from php if we desire.
Alias /getconfig /usr/share/spxmanage/www/getconfig.php

# The official path for the webstorage endpoint in /webstorage, so that we
# may move away from php if we desire.
Alias /webstorage /usr/share/spxmanage/www/webstorage.php

# The automatic redirect for automatic accesses via the embedded Wi-Fi
# configuration access point.
Alias /wifi /usr/share/spxmanage/www/wifi.php

# Aliases for the status / monitoring location
Alias /status/info /usr/share/spxmanage/www-status/info.php
Alias /status/snapshot /usr/share/spxmanage/www-status/snapshot.php
Alias /status/ /usr/share/spxmanage/www-status/

# Backwards compatibility aliases for the status / monitoring location
# NOTE: the /snapshot/ URL path is broken, as we have a /snapshot URL
# path which is another thing.
Alias /snapshot/info /usr/share/spxmanage/www-status/info.php
Alias /snapshot/snapshot /usr/share/spxmanage/www-status/snapshot.php
Alias /snapshot/ /usr/share/spxmanage/www-status/

# To retrive the snapshot the official path is /snapshot,
# so that we may move away from PHP if we desire.
Alias /snapshot /usr/share/spxmanage/www/snapshot.php

# Place the spxjslibs space in the admin server
# Note that spxjslibs are not necessarily installed;
# as aliases in the main server config are inherited by
# *all* vservers and there can only be a VirtualHost
# section for each vserver in the config we need to
# define this here.
Alias /spxjslibs /usr/share/spxjslibs/libs

# Override the DAV lock DB to use our own
DavLockDB /var/cache/spxmanage/dav/lockdb

# Unconditionally set the which_vhost environment variable
# so that other config files can do per-vhost conditional
# processing reliably (SetEnv cannot be used because it
# occurs late in request processing)
SetEnvIf Request_URI ^ which_vhost=main

# Internet Explorer does not display text/plain MIME type inline, or
# at least not for URLs ending in .log or .log.gz and it starts an
# external viewer based on URL extension and not the MIME type.
# The .log.gz files (compressed) are served with "Content-Type text/plain"
# and "Content-Encoding gzip", which is the right way. However, because
# of the above, IE will try to open it with an application like
# WinZip although it is a plain text file (because the browser has to
# undo the Content-Encoding). The rewrite rules below work around this
# by making IE access the .log.gz files via .log URLs while still being
# sent using "Content-Encoding gzip".

# When executing requests via fcgi an internal URL /.fcgi-bin/ is
# generated, stop any rewriting on that early on so as to avoid
# bogus matches in subsequent rewrite rules
RewriteRule ^/.fcgi-bin/ - [L]
    
# Forbid all direct access to admin.php, this script should not be
# accessed externally, it is instead accessed via a rewrite rule.
RewriteRule ^/admin.php - [F,L,NS]

# Forward the TLS-SRP authentication user name, if any, as HTTP
# authentication user for scripts to make use of it transparently. If there
# is true HTTP authentication required in the server config for a resource,
# then the REMOTE_USER value set here will be overwritten when HTTP
# authentication is verified because that is done after all rewrite rules
# in per-server context have been evaluated (but before rewrite rules in
# per-directory context).
RewriteCond %{SSL:SSL_SRP_USER} (.+)
RewriteRule ^ - [E=REMOTE_USER:%1,NS]

# Map a .log URL in the logs folder to the .log.gz file if the .log
# file does not exist but the .log.gz file does. Note that this rule
# cannot be in a <Directory> not .htaccess section because it is
# otherwise re-injected into URL processing and would match the rule
# below, causing an infinite number of redirects.
RewriteCond /srv/raperca/$1 !-f
RewriteCond /srv/raperca/$1.gz -f
RewriteRule ^/(log/.*\.log)$		/srv/raperca/$1.gz [NS]

# For IE redirect all accesses to exising .log.gz files to a .log URL
# so that IE sees an extension that matches the MIME type
RewriteCond %{HTTP_USER_AGENT} "\bMSIE [0-9]"
RewriteCond /srv/raperca/$1.gz -f
RewriteRule ^/(log/.*\.log)\.gz$	$1 [R,L,NS]

# Some users mistakenly type just the device hostname on the URL bar
# of HMD to access the content (WebDAV) server, instead of properly
# specifying the WebDAV server on port 81 below. To help these users
# we redirect them to the proper server when receiving a PROPFIND
# (the only WebDAV specific request which has no side-effects).
# We need to handle the case where the host header has a port number
# in it, although normally it will not. We also handle literal IPv4 and
# IPv6 addresses in addition to host names. The result is not
# guaranteed to work when accessed via a reverse proxy or via a
# port mapping device, but at least it works in the general case and
# provides a clue otherwise.
RewriteCond %{REQUEST_METHOD} =PROPFIND
RewriteCond %{HTTPS} =off
RewriteCond %{REQUEST_URI} !^/content(?:/|$)
RewriteCond %{HTTP_HOST} ^(\[[^]]+\]|[^][:]+)(?::[0-9]+|$) [NV]
RewriteRule ^((?!/content).*)$ http://%1:81$1 [R=permanent,L,NS]

# Allow LOCK requests under the DAV enabled part to existing files only,
# see analogous definition under the content virtual server for rationale.
RewriteCond %{REQUEST_METHOD} =LOCK
RewriteCond /srv/raperca%{REQUEST_URI} !-f
RewriteRule ^/content(?:/|$) - [F,NS]

# Accesses to the controlcenter module need to be handled by the
# admin PHP instance. The PT flag is needed for the CGI handler to
# correctly process the new URI as otherwise it uses the original
# URI.
RewriteRule ^(/controlcenter/.*) /admin.php$1 [L,NS,H=${SPXMANAGE_ADMIN_PHP_HANDLER},PT]

# The webstorage endpoint can also be authenticated via a Bearer authorization
# token or an "access_token" field in the query string; both according
# to RFC 6750. The "has_webstorage_auth" variable is set when successfully
# authenticated, otherwhise the "bad_webstorage_auth" is set to a non-empty
# value if an incorrect token is present.
# The token must be in the set [-a-zA-Z0-9._+@] with a maximum length of 64 characters.
RewriteCond %{HTTP:Authorization} '^Bearer +([-a-zA-Z0-9._+@]{1,64})$' [OR]
RewriteCond %{QUERY_STRING} (?:^|&)access_token=([-a-zA-Z0-9._+@]{1,64})(?:&|$)
RewriteCond /var/lib/spxmanage/api-keys/webstorage-%1 -f
RewriteRule ^/webstorage(?:$|/) - [E=has_webstorage_auth,S=1]
RewriteCond %{HTTP:Authorization} '^Bearer ' [OR]
RewriteCond %{QUERY_STRING} (?:^|&)access_token=
RewriteRule ^/webstorage(?:$|/) - [E=bad_webstorage_auth:1]

# In a similar way admin access to some endpoints can also be authenticated
# via an temporary (i.e. not part of the configuration) Bearer authorization token.
# Only the header mechanism is accepted in this case.
RewriteCond %{HTTP:Authorization} '^Bearer +([-a-zA-Z0-9._+@]{1,64})$'
RewriteCond /var/run/spxmanage/www-auth/admin_auth-%1 -f
RewriteRule ^/getconfig(?:|\.php)$ - [E=has_admin_bearer_auth]

# Only allow CORS requests when the client passes a valid spx-api-key field
# in the query string with a value matching a valid key. The key must be in
# the set [-a-zA-Z0-9._+@] with a maximum length of 64 characters.
# CORS requests are identified by the presence of the Origin header and
# checking that comparing the value of the Origin header
# against the Host header, as the Origin header may be included on same
# origin requests.
# An exception to the above rule is the "setup" endpoint, which is open for
# CORS requests without requiring a key.
RewriteRule ^/setup(?:|\.php)$ - [NS,S=3]
RewriteCond %{HTTP:Origin} !. [OR]
RewriteCond expr "req('Origin') in { 'http://%{HTTP_HOST}', 'https://%{HTTP_HOST}' }"
RewriteRule ^ - [NS,S=2]
RewriteCond %{QUERY_STRING} (?:^|&)spx-api-key=([-a-zA-Z0-9._+@]{1,64})(?:&|$)
RewriteCond /var/lib/spxmanage/api-keys/cors-%1 -f
RewriteRule ^ - [NS,S=1]
RewriteRule ^ - [NS,F,L]

# For info, rpc, setup, webstorage and boot-id we need to add CORS headers so that responses
# generated by httpd itself do set the headers. We signal this by
# adding the "use_cors_*" environment variables with the value of
# the Origin header and flags for appropriate HTTP methods.
# For the OPTIONS method we need to bypass authentication and return
# a 200 for pre-flight requests to work, so we use a redirect rewrite
# rule but forcing a 200 code.
# NOTE: we do purposefully accept the "null" origin and use it for
# Access-Control-Allow-Origin (ACAO) as CORS requests are only allowed for
# requests with a valid spx-api-key above and we do not check for a
# particular origin. This allows to do CORS from local files and other
# documents without a hierarchical origin as long as browsers compare
# "null" as equal to "null", which may change in the future. We cannot
# use * for ACAO as that prevents the use of credentials.
RewriteCond %{HTTP:Origin} .
RewriteRule ^/(?:(info|rpc|setup|webstorage|snapshot|status/info|status/snapshot)(?:$|/|\.php)|boot-id$) - [NS,E=use_cors_origin:%{HTTP:Origin}]
RewriteCond %{HTTP:Origin} .
RewriteCond %{REQUEST_METHOD} =OPTIONS
RewriteRule ^/(?:(info|rpc|setup|webstorage|snapshot|status/info|status/snapshot)(?:$|/|\.php)|boot-id$) - [NS,E=use_cors]
RewriteCond %{HTTP:Origin} .
RewriteCond %{REQUEST_METHOD} =OPTIONS
RewriteRule ^/(?:(info|setup|snapshot|status/info|status/snapshot)(?:$|/|\.php)|boot-id$) - [NS,E=use_cors_ro_methods,R=200,L]
RewriteCond %{HTTP:Origin} .
RewriteCond %{REQUEST_METHOD} =OPTIONS
RewriteRule ^/rpc(?:$|/|\.php) - [NS,E=use_cors_rw_methods,R=200,L]
RewriteCond %{HTTP:Origin} .
RewriteCond %{REQUEST_METHOD} =OPTIONS
RewriteRule ^/webstorage(?:$|/|\.php) - [NS,E=use_cors_all_methods,R=200,L]

# PHP scripts undergo multiple rewrite, hence environment variables
# set in the first round are prefixed with REDIRECT_, recover the
# value of "use_cors_*" if that is the case and is not empty.
SetEnvIf REDIRECT_use_cors_origin "(.+)" use_cors_origin=$1
SetEnvIf REDIRECT_use_cors "(.+)" use_cors=$1
SetEnvIf REDIRECT_use_cors_ro_methods "(.+)" use_cors_ro_methods=$1
SetEnvIf REDIRECT_use_cors_rw_methods "(.+)" use_cors_rw_methods=$1
SetEnvIf REDIRECT_use_cors_all_methods "(.+)" use_cors_all_methods=$1

# Add the CORS headers if use_cors_origin is set
Header always set Access-Control-Allow-Origin %{use_cors_origin}e env=use_cors_origin
Header always set Access-Control-Allow-Credentials "true" env=use_cors_origin
Header always set Access-Control-Max-Age "86400" env=use_cors
Header always set Access-Control-Allow-Methods "GET, HEAD, OPTIONS" env=use_cors_ro_methods
Header always set Access-Control-Allow-Methods "GET, HEAD, POST, OPTIONS" env=use_cors_rw_methods
Header always set Access-Control-Allow-Methods "*" env=use_cors_all_methods
# Allow authentication via AJAX, to avoid browser pop-up, anyhow an api key is required on top
Header always set Access-Control-Allow-Headers "authorization" env=use_cors
# In CORS content-type is a simple header only for a very restricted set
# of values, so we need to add it to the allowed headers in the response
# when POST is allowed as a method on the resource.
Header always append Access-Control-Allow-Headers "content-type" env=use_cors_rw_methods

# Make the info.php, rpc.php, snapshot.php, report.php, getconfig.php run via the admin
# handler.  The PT flag is not necessary since these URIs already
# point to the script or their alias.
RewriteRule ^/(info|rpc|snapshot|report|getconfig)(?:$|/|\.php) /usr/share/spxmanage/www/$1.php [NS,H=${SPXMANAGE_ADMIN_PHP_HANDLER}]

# Serve system fonts under the /api/fonts/system path
RewriteRule ^/api/fonts/system/font-faces.css /var/cache/spxmanage/www/docs/font-faces.css [NS]
RewriteRule ^/api/fonts/system/(.*) /usr/share/fonts/$1 [NS]

# Bypass PHP script and serve files directly
RewriteCond /srv/raperca/interface/public/$1 -f
RewriteRule ^/api/(.*) /srv/raperca/interface/public/$1 [NS]

# Bypass PHP script and serve files directly for the apps
RewriteCond /srv/raperca/interface/public/apps/$1/interface/$2 -f
RewriteRule ^/assets/apps/edit/(\w*)/(.*) /srv/raperca/interface/public/apps/$1/interface/$2 [NS]

# Send all URIs corresponding to modules or controllers of
# index.php to index.php, also send a bare / or empty URI-path to
# index.php. The PT flag is needed for the CGI handler to
# correctly process the new URI as otherwise it uses the original
# URI.
RewriteRule ^(/(?:api|assets|main|error|user)/.*|/|)$ /index.php$1 [L,NS,PT]

# Support for transparent authentication to content and scripts to
# not require HTTP authentication for clients already
# authenticated with the web interface via forms.
#
# The interface authentication works via PHP session with the
# "uisess" cookie. On login the interface creates the auth_$sessid
# file which it removes on logout. auth_$sessid also contains a 
# timestamp with the end of session validity time. The timestamp has the following format: 
# YearMonthDayHourMinutesSeconds.
# The session storage file (sess_$sessid) exists even for non logged in users.
# This part retrive the $sessid in the "uiauth_cookie" and sets the 
# "has_uiauth" environment variable which is then checked in the directory 
# access rules to bypass password authentication.
# If the session exceeds the validity time, a password authentication
# is requested again.
# Note that PHP session IDs for the file handler allows all
# alphanumeric characters, the comma and the minus.
RewriteCond %{HTTP_COOKIE} 'uisess="?([-,a-zA-Z0-9]+)"?' [NV]
RewriteRule ^ - [E=uiauth_cookie:%1]

RewriteCond expr "-f '/var/cache/php/session/auth_%{reqenv:uiauth_cookie}'"
RewriteCond expr "-s '/var/cache/php/session/sess_%{reqenv:uiauth_cookie}'"
RewriteCond expr "filesize('/var/cache/php/session/auth_%{reqenv:uiauth_cookie}') -eq 0 || %{TIME} < file('/var/cache/php/session/auth_%{reqenv:uiauth_cookie}')"
RewriteRule ^ - [E=has_uiauth:1]

# Likewise for the admin role, the "has_admin_uiauth" environment
# variable is set.
RewriteCond expr "-f '/var/cache/php/session/auth_admin_%{reqenv:uiauth_cookie}'"
RewriteCond expr "%{reqenv:has_uiauth} -eq 1"
RewriteRule ^ - [E=has_admin_uiauth:1]

# Likewise for the content role, the "has_content_uiauth" environment
# variable is set.
RewriteCond expr "-f '/var/cache/php/session/auth_content_%{reqenv:uiauth_cookie}'"
RewriteCond expr "%{reqenv:has_uiauth} -eq 1"
RewriteRule ^ - [E=has_content_uiauth:1]

# Likewise for the monitoring role, the "has_monitoring_uiauth"
# environment variable is set.
RewriteCond expr "-f '/var/cache/php/session/auth_monitoring_%{reqenv:uiauth_cookie}'"
RewriteCond expr "%{reqenv:has_uiauth} -eq 1"
RewriteRule ^ - [E=has_monitoring_uiauth:1]

# Require any access under /uiauth/ to have UI authentication, otherwise
# redirect to /main/go to prompt for form based authentication
RewriteCond expr "-z reqenv('has_uiauth')"
RewriteRule ^/uiauth/(.*) /main/go/$1 [R,L]

# UI authentication is available, map to correct place if supported and
# respond with an explicit 404 if not.
RewriteRule ^/uiauth(/content/.*) /srv/raperca/$1 [S=1]
RewriteRule ^/uiauth/ - [R=404,L]

# Allow all rewrites from the main server definition to apply
# to this pseudo-virtual server
RewriteOptions Inherit

# Use normal request log file but with extended format
CustomLog /var/log/apache2/access_log common_extended
