# Secure Boot Key Exchange Key (KEK) database for SpinetiX products

"KEK" directory contains the signed KEK certificates, one per file, signed
with the SpinetiX PK. See README in this directory for general
information.

The owner GUID for Microsoft KEKs is as specified in [Windows Secure Boot
Key Creation and Management
Guidance](https://docs.microsoft.com/en-us/windows-hardware/manufacture/desktop/windows-secure-boot-key-creation-and-management-guidance),
which currently is `77fa9abd-0359-4d32-bd60-28f4e78f784b` for all.

The owner GUID for SpinetiX KEKs is `012af9b0-238f-462b-962b-269052b49c4a`.

The procedure to generate the signed EFI variable update file (i.e., the
`*.siglist.signed` files) for each KEK certificate, using `sbsigntools` and
`openssl`, is as follows.

1. Get the KEK certificate in DER form, if the certificate was in PEM form
   convert it.
```
openssl x509 -in kek-cert.pem -outform DER -out kek-cert.der
```

2. Verify the KEK certificate.
```
openssl x509 -in kek-cert.der -inform DER -noout -text
```

3. Create the `EFI_SIGNATURE_LIST` structure with `sbsiglist`, where
   `OWNER_GUID` is the owner GUID that should appear in the EFI variable
   update file.
```
sbsiglist --owner OWNER_GUID --type x509 --output kek-cert.der.siglist kek-cert.der
```

4. Sign the `EFI_SIGNATURE_LIST` structure with `sbvarsign`, where
   `pk-cert.pem` is the PK certificate and `pk-cert-key.pem` its private
   key, both in PEM format.
```
sbvarsign --cert pk-cert.pem --key pk-cert-key.pem \
        --attr NON_VOLATILE,BOOTSERVICE_ACCESS,RUNTIME_ACCESS,TIME_BASED_AUTHENTICATED_WRITE_ACCESS,APPEND_WRITE \
        --output kek-cert.der.siglist.signed \
        KEK kek-cert.der.siglist
```
