<?php

class LogsInfo extends CModel {
	
	var $accounting= array();
    var $current= array();
    var $backup= array();
    var $streaming= array();
    var $base="log/";
    
    
    public function attributeNames() {
        return array("accounting", "current", "backup", "streaming" );
    }
    public function safeAttributes() {
        return array();
    }
    public function load() {
        $logPath='/srv/raperca/log';
        if ( !file_exists($logPath) ){
            return;
        }
        $filelist=scandir($logPath);
        natsort($filelist);
        if ( in_array("accounting.log", $filelist ) ) {
            $info = stat($logPath."/"."accounting.log" );
            $this->accounting[] = array( "accounting.log", $info['size'], $info['mtime'] );
        }
        
        foreach($filelist as $file){
            if ($file[0]=='.') continue;
            if ( strcmp($file,"accounting.log")==0 ) continue;
            $info = stat( $logPath."/".$file );
            if (strncmp($file,"accounting",10)==0 ) {
                $this->accounting[] = array( substr($file,0, -3), $info['size'], $info['mtime']-60 ); 
            } else if (strncmp(substr($file,-3),".gz",3)==0) {
                $this->backup[] = array( substr($file,0, -3), $info['size'], $info['mtime']-60 ); 
            } else
                $this->current[] = array( $file, $info['size'], $info['mtime'] ); 
        }
    }    
    public function loadStreaming() {
        $streamPath='/srv/raperca/capture';
        if ( file_exists($streamPath) ) {
            $filelist=scandir($streamPath);
            foreach($filelist as $file){
                if ($file[0]=='.') continue;
                $this->streaming[] = $file; 
            }
        }
    }
}