<?php
class PeripheralsAction extends CAction
{
    

    protected function serial( ){
        if ( !Yii::app()->branding->hasRight('peripheralsSerial') &&
             !Yii::app()->branding->hasRight('peripheralsFSM')){
            return array();
        }
        $serialConfig = new SerialConfig;
        $serialConfig->load();
        if (Yii::app()->device->model !== 'ikebana') {
            $serialConfig->loadDevices();
        }
        
        if ( isset($_POST['SerialConfig']) ){
            $serialConfig->setScenario('io');
            $serialConfig->setAttributes( $_POST['SerialConfig'] );
            if ( $serialConfig->validate() )
                $serialConfig->save();
        }
        
		return array( 
            'serialConfig' => $serialConfig
        );
	}
    
    protected function usb( $playerConfig = null, $simpleFormId = "USB" )
	{
        if ( !$playerConfig ){
            $playerConfig = new PlayerConfig;
        }	
        if( $simpleFormId == "USB" && isset($_POST['PlayerConfig']) ) {
            $playerConfig->setScenario( 'inter'  );
            $playerConfig->setAttributes( $_POST['PlayerConfig'] );
            if ( $playerConfig->validate() )
                $playerConfig->saveConfig();
        }
        
        $sourceConfig = new SourceConfig;
        $sourceConfig->load();
        
        if ( isset($_POST['SourceConfig']) ){
            $sourceConfig->setAttributes(  $_POST['SourceConfig'] );
            if ( $sourceConfig->validate() ) 
                $sourceConfig->save();            
        }
        
        $usbStorageInfo = new USBStorageInfo;
        $usbStorageInfo->load();
        return array(
            'sourceConfig' => $sourceConfig,
            'playerConfig' => $playerConfig,
            'usbStorageInfo' => $usbStorageInfo
        );
	}

    protected function capture()
    {
        if (!Yii::app()->branding->hasRight('peripheralsCapture')) {
            return array();
        }        
        $capture = new Capture();
        $capture->load();
        if (isset($_POST['CaptureDevice'])) {
            foreach ($capture->devices as $path => $device) {
                if (isset($_POST['CaptureDevice'][$path])) {
                    $device->attributes=$_POST['CaptureDevice'][$path];
                }
            }
            if($capture->validate()) {
                $capture->save();
            }
        }
        return array(
            'capture' => $capture
        );
    }

    public function run()
    {
        $simpleFormId = isset($_POST['SimpleFormId'])?$_POST['SimpleFormId']:"";
        
        $options = array( );
        $options += self::serial( );        
        $options += self::usb(  );
        $options += self::capture();

        $this->controller->render( 'peripherals', $options );
    }
}