<?php

class UserController extends ControlCenterController
{
    public function init()
    {     
        parent::init();
        
        $this->pages = array(  
            array( 'label' => 'Profile', 'url'  => array( 'user/profile' ) ),
            array( 'label' => 'User Management ', 'url'  => array( 'user/admin' ), 'visible' => Yii::app()->user->checkAccess('viewUser') ),
            array( 'label' => 'Security ', 'url'  => array( 'user/security' ), 'visible' => Yii::app()->branding->hasRight('security') && Yii::app()->user->checkAccess('useControlCenter') ),
        );

        
    }
    public function accessRules()
    {
        $rules = array(      
            array('allow',  
                'actions' => array( "profile", "selfUpdate" ),
                'users'=>array('@'),
            ),
            array('allow',  
                'actions' => array( "admin" ),
                'roles'=>array('viewUser'),
            ),
            array('allow',  
                'actions' => array( "update" ),
                'roles'=>array('manageUser'),
            ),
            array('allow',  
                'actions' => array( "delete" ),
                'roles'=>array('deleteUser'),
            )
        );
        if ( !Yii::app()->branding->hasRight('security') ){
            $rules[] =  array('deny',  
                'actions' => array( "security" ),
                'users'=>array('*')
            );
        }
        return array_merge( $rules, parent::accessRules() ); 
    }
    
	public function actionAdmin()
	{
        $users = User::model()->findAll();
        
		$this->render('admin', array( 
            'users' => $users
        ));
	}
    public function actionUpdate()
	{
        $this->ajaxOnly(); 
        $errors = array();
        $data = null;
        if ( isset($_POST['User']) ){
            
            $userData = $_POST['User'];
            if ( isset($userData['id']) && !empty($userData['id']) ){
                $user = User::model()->findByPk( $userData['id'] );                
            } else {
                $user = new User();
            } 
            if ( $user && ( $user->id != 1 || Yii::app()->user->id == $user->id ) ){
                $transaction = $user->getDbConnection()->beginTransaction();
                try {
                    $user->attributes = $userData;
                    if ( $user->save() ){
                        $data = array( 
                            'username' => $user->username,
                            'id' => $user->id
                        );
                        if ( isset($_POST['UserRights']) && $user->id != 1 ){
                            $user->userRights->attributes = $_POST['UserRights'];
                            if ( $user->userRights->save() ) {
                                $data += $user->userRights->getUserRights();                                
                            } else {
                                $errors = $this->updateErrors($user->userRights, $errors);
                                throw new Exception("Save user rights failed");
                            }
                        } 
                        if ( !$user->updateHttpdSecurity() ) {                                    
                            throw new Exception("Update user failed");
                        }
                        Tools::addMessage( "User updated with success" );
                    } else {
                        $errors = $this->updateErrors($user, $errors);
                        throw new Exception("Save user failed");
                    }
                    $transaction->commit();
                } catch(Exception $e) { // an exception is raised if a query fails
                    $errors[] = $e->getMessage();
                    $transaction->rollback();                
                }
            } else {
                $errors[] = 'Wrong id'; 
            }

            
        } else {
            $errors[] = "Missing data";
        }      
        
        $this->render('/layouts/ajax', array(
            'errors' => $errors,
            'data' => $data
        ));
        
        if ( $user ){
            $user->reloadConfig();
        }
    }
    public function actionSelfUpdate( )
	{
        $this->ajaxOnly(); 
        $errors = array();
        $data = null;
        if ( !isset($_POST['User']) ){
            $this->render('/layouts/ajax', array(
                'errors' => "Missing data"
            ));
            return;
        }
        $currentUser = User::model()->findByPk( Yii::app()->user->id );

        $transaction = $currentUser->getDbConnection()->beginTransaction();
        try {
            $currentUser->attributes = $_POST['User'];
            if ( $currentUser->save() ){
                $data = array( 
                    'username' => $currentUser->username,
                    'id' => $currentUser->id
                );                        
                if ( !$currentUser->updateHttpdSecurity() ) {                                    
                    throw new Exception("Update user failed");
                }
                Tools::addMessage( "User updated with success" );
            } else {
                $errors = $this->updateErrors($currentUser, $errors);
                throw new Exception("Save user failed");
            }
            $transaction->commit();
        } catch(Exception $e) { // an exception is raised if a query fails
            $errors[] = $e->getMessage();
            $transaction->rollback();                
        }            
        $this->render('/layouts/ajax', array(
            'errors' => $errors,
            'data' => $data
        ));
        if ( $currentUser ){
            $currentUser->reloadConfig();
        }
    }
    public function actionDelete()
	{
        $this->ajaxOnly();
                
        $errors = array();
        if( isset($_POST['id']) ){
            $id = $_POST['id'];
            if ( $id == Yii::app()->user->id ) {
                $errors[] = 'Cannot delete current user'; 
            } else if ( $id == 1 ) {
                $errors[] = 'Cannot delete admin user'; 
            }else {
                $user = User::model()->findByPk( $id );
                if ( !$user ){
                    $errors[] = 'Wrong id'; 
                } else {
                    $transaction = $user->getDbConnection()->beginTransaction();
                    try {
                        if ( !$user->delete() ){
                            throw new Exception("Cannot delete user"); 
                        } else {                            
                            if ( !$user->updateHttpdSecurity() ) {                                    
                                throw new Exception("Update user failed");
                            }
                        }
                        $transaction->commit();
                    } catch(Exception $e) { // an exception is raised if a query fails
                        $errors[] = $e->getMessage();
                        $transaction->rollback();                
                    }
                }
            }
        } else {
            $errors[] = 'Missing id'; 
        }
        
        $this->render('/layouts/ajax', array(
            'errors' => $errors
        ));
        if ( $user ){
            $user->reloadConfig();
        }
	}
	
	public function actionProfile()
	{
        $user = User::model()->findByPk( Yii::app()->user->id );       
        if ( !$user ){
            throw new CHttpException(404,'The specified user cannot be found');
        }
        $user->password = "";
		$this->render('profile', array( 
            'user' => $user,            
        ));
	}
    public function actionSecurity()
	{
        $securitySettings = new SecuritySettings();
        if ( isset($_POST['SecuritySettings']) ){
            $securitySettings->attributes = $_POST['SecuritySettings'];            
        }
        
        $this->render('security', array( 
            'securitySettings' => $securitySettings,            
        ));
        
        $securitySettings->reloadConfig();
	}

}