<?php

include_once dirname(__FILE__) . '/../utils/MaintenanceJobs.php';

// This class handle tools function to be derived by many classes
class Tools
{
    public static $shutdownReason = "";
    public static $installationmode = null;
    public static $pendingChangeList = null;
    public static $messages = array();
    public static $reboot = false;
    public static $redirect = false;
    public static $reload = false;
    public static $hasHeader = false;
    static function save_file(
        $name,
        $data,
        $secret = false,
        $group = 'raperca',
        $ignore_empty = true
    ) {
        $ret = MaintenanceJobs::saveFile(
            $name,
            $data,
            $secret,
            $group,
            $ignore_empty
        );
        if ($ret !== true && $ret !== false) {
            return false;
        }
        return $ret;
    }

    static function get_my_host()
    {
        if (isset($_SERVER['HTTP_HOST'])) {
            $name = $_SERVER['HTTP_HOST'];
            if (count(explode(":", $name)) > 2) {
                // its ipv6
                if ($name[0] != "[") {
                    $name = "[" . $name . "]";
                }
            }
        } else {
            if (isset($_SERVER['SERVER_NAME'])) {
                $name = $_SERVER['SERVER_NAME'];
            } else {
                $name = $_SERVER['SERVER_ADDR'];
            }
            if (strpos($name, ":")) {
                $name = "[" . $name . "]";
            }
        }
        return $name;
    }
    # Converts a duration string formatted as an integer and
    # a unit suffix into an integer number of seconds, default
    # unit is seconds.
    static function timestr_to_secs($s)
    {
        $s = trim($s);
        if (strcasecmp(substr($s, -5), 'hours') == 0) {
            $m = 3600;
            $o = 5;
        } elseif (strcasecmp(substr($s, -4), 'secs') == 0) {
            $m = 1;
            $o = 4;
        } elseif (strcasecmp(substr($s, -4), 'mins') == 0) {
            $m = 60;
            $o = 4;
        } elseif (strcasecmp(substr($s, -4), 'hour') == 0) {
            $m = 3600;
            $o = 4;
        } elseif (strcasecmp(substr($s, -3), 'sec') == 0) {
            $m = 1;
            $o = 3;
        } elseif (strcasecmp(substr($s, -3), 'min') == 0) {
            $m = 60;
            $o = 3;
        } elseif (strcasecmp(substr($s, -3), 'hrs') == 0) {
            $m = 3600;
            $o = 3;
        } elseif (strcasecmp(substr($s, -2), 'hr') == 0) {
            $m = 3600;
            $o = 2;
        } elseif (strcasecmp(substr($s, -1), 's') == 0) {
            $m = 1;
            $o = 1;
        } elseif (strcasecmp(substr($s, -1), 'm') == 0) {
            $m = 60;
            $o = 1;
        } elseif (strcasecmp(substr($s, -1), 'h') == 0) {
            $m = 3600;
            $o = 1;
        } else {
            $m = 1;
            $o = 0;
        }
        if ($o != 0) {
            $s = substr($s, 0, -$o);
        }
        if (is_numeric($s)) {
            return intval(floatval($s) * $m);
        } else {
            return false;
        }
    }

    # Converts a duration in seconds to a string as an integer
    # and a unit suffix, the unit is chosen so as to have the
    # smallest integer quantity
    static function secs_to_timestr($v)
    {
        if ($v != 0 && $v % 3600 == 0) {
            return $v / 3600 . 'h';
        } elseif ($v != 0 && $v % 60 == 0) {
            return $v / 60 . 'm';
        } else {
            return $v . 's';
        }
    }

    static function reconfig_player()
    {
        if (file_exists('/var/run/raperca.pid')) {
            $pid = trim(file_get_contents('/var/run/raperca.pid'));
            if (PHP_OS != "WINNT") {
                posix_kill($pid, SIGHUP);
            }
        }
    }
    static function restart_content()
    {
        if (file_exists("/srv/raperca/content/index.svg")) {
            @touch("/srv/raperca/content/index.svg");
        }
        if (file_exists("/srv/raperca/interface/public/index.svg")) {
            @touch("/srv/raperca/interface/public/index.svg");
        }
    }
    static function reload_mdns()
    {
        if (PHP_OS != "WINNT") {
            if (file_exists('/etc/init.d/spxmanage-mdns')) {
                exec('/etc/init.d/spxmanage-mdns reload');
            } else {
                exec('/etc/init.d/raperca-mdns reload');
            }
        }
    }
    static function doShutdown()
    {
        return self::$shutdownReason != "";
    }
    static function addReason($str)
    {
        if (self::$shutdownReason != "") {
            self::$shutdownReason .= "; ";
        }
        self::$shutdownReason .= $str;
    }

    static function addMessage($str)
    {
        self::$messages[] = $str;
    }
    static function getMessages()
    {
        return self::$messages;
    }
    static function checkReboot()
    {
        return self::$reboot == 1 || self::$reboot == 2;
    }
    static function checkRecoveryMode()
    {
        return self::$reboot == 2;
    }
    static function checkShutdown()
    {
        return self::$reboot == 3;
    }
    static function checkInstallationmode()
    {
        if (self::$installationmode === null) {
            self::$installationmode = file_exists("/var/run/reboot-pending");
        }
        return self::$installationmode;
    }
    static function clearInstalationMode()
    {
        $pending = null;
        if (file_exists("/var/run/reboot-pending")) {
            $pending = file_get_contents("/var/run/reboot-pending");
            $pending = implode(", ", explode("\n", $pending));
            unlink("/var/run/reboot-pending");
        }
        self::$installationmode = false;
        self::$pendingChangeList = array();
        return $pending;
    }
    static function addToPendingChangeList($str)
    {
        self::getPendingChangeList();
        self::$pendingChangeList[] = $str;

        file_put_contents(
            "/var/run/reboot-pending",
            implode("\n", self::$pendingChangeList)
        );
        self::$installationmode = true;
    }

    static function getPendingChangeList()
    {
        if (self::$pendingChangeList === null) {
            if (file_exists("/var/run/reboot-pending")) {
                self::$installationmode = true;
                $pending = file_get_contents("/var/run/reboot-pending");
                self::$pendingChangeList = explode("\n", $pending);
            } else {
                self::$installationmode = false;
                self::$pendingChangeList = array();
            }
        }
        return self::$pendingChangeList;
    }
    static function shutdown(
        $forcereboot = false,
        $recovery = false,
        $delay = false,
        $halt = false
    ) {
        if (self::$reboot) {
            return;
        }

        if (!$forcereboot) {
            $msg = self::$shutdownReason;
            if ($msg == "") {
                $msg = "unknown reason";
            }
            self::addToPendingChangeList($msg);
            syslog(LOG_NOTICE, "configuration change:" . $msg);
            self::$shutdownReason = "";
        } else {
            $msg = self::clearInstalationMode();
            self::$shutdownReason = $msg ? $msg : "unknown reason";
            $msg = "user initiated shutdown" . ($msg ? ": " . $msg : '');

            if ($halt) {
                self::$reboot = 3;
            } elseif ($recovery) {
                self::$reboot = 2;
            } else {
                self::$reboot = 1;
            }
            MaintenanceJobs::shutdown($msg, $recovery, $delay, $halt);
        }
    }

    static function setSafeModeData($dstfile, $srcdata, $isfile = true)
    {
        return MaintenanceJobs::setSafeModeData($dstfile, $srcdata, $isfile);
    }
    static function setSafeModeDataExt($commands)
    {
        return MaintenanceJobs::setSafeModeDataExt($commands);
    }

    static function save_symlink($target, $link)
    {
        $ret = MaintenanceJobs::saveSymlink($target, $link);
        if ($ret !== true && $ret !== false) {
            return false;
        }
        return $ret;
    }
    static function recovery_version()
    {
        $info = file_get_contents("/proc/mtd");

        foreach (explode("\n", $info) as $str) {
            if (strpos($str, "failsafe-fs") === false) {
                continue;
            }
            $max = strpos($str, ":");
            $mtd = substr($str, 0, $max);
            if (!file_exists("/dev/" . $mtd . "ro")) {
                return "[dev]";
            }
            $f = fopen("/dev/" . $mtd . "ro", 'r');

            if ($f === false) {
                return "[ro]";
            }
            $data = fread($f, 64);
            if ($data === false) {
                return "[read]";
            }

            if (
                ord(substr($data, 0, 1)) != 0x27 ||
                ord(substr($data, 1, 1)) != 0x05 ||
                ord(substr($data, 2, 1)) != 0x19 ||
                ord(substr($data, 3, 1)) != 0x56
            ) {
                return "[magic]";
            }
            $values = explode(" ", substr($data, 32));
            if (count($values) == 0) {
                return "[data]";
            }
            return $values[count($values) - 1];
        }
        return "[not found]";
    }

    static function checkRecoverySate()
    {
        if (Yii::app()->branding->product != "HMP100") {
            return "bonjour";
        }

        $version = self::recovery_version();
        $ver = explode(".", $version);
        if (count($ver) >= 2 && (intval($ver[0]) > 1 || intval($ver[1]) >= 1)) {
            return "bonjour";
        } else {
            $conf = file_get_contents("/etc/network/interfaces");
            $default = true;
            if (strpos($conf, "# Factory default") === false) {
                return "current";
            } else {
                return "fixed";
            }
        }
    }
    static function getBootID()
    {
        return MaintenanceJobs::bootID();
    }
    static function reloadHttpd()
    {
        return MaintenanceJobs::reloadHttpd();
    }

    static function queryEnrollment()
    {
        return MaintenanceJobs::queryEnrollment();
    }
}
