<?php
class BsRow extends CWidget
{
    var $cols = array();
    var $content = null;
    var $options = array();
    protected $col;

    public function addCol( $col )
    {
        $this->cols[] = $col;
    }
    public function beginCol( $size = 0, $options = array() )
    {     
        $col = array ( );
        if ( is_array( $size) ){
            if ( isset($size['pushs']) ){
                $col['pushs'] = $size['pushs'];
            }
            if ( isset($size['pulls']) ){
                $col['pulls'] = $size['pulls'];
            }
            if ( isset($size['sizes']) ){
                $col['sizes'] = $size['sizes'];
            }
            if ( isset($size['offsets']) ){
                $col['offsets'] = $size['offsets'];
            }
            if ( isset($size['xs']) || isset($size['sm']) || isset($size['md']) || isset($size['lg']) ){
                $col['sizes'] = $size;
            }
        } else if ( $size > 0 ){
            $col['size'] = $size;
        }
        $col['options'] = $options;
        $this->col = $col;
        ob_start();
    }
    public function endCol()
    {        
        $this->col['content'] = ob_get_contents ( );
        ob_end_clean();
        $this->cols[] = $this->col;
    }
    public function init()
    {
        if ( $this->content === null ){
            ob_start(); 
        }
    }
    public function run()
    {
        if ( $this->content === null ){
            $this->content = ob_get_contents ( );
            ob_end_clean();
        }
        $this->controller->addClass( $this->options, "row" );
        echo CHtml::openTag("div", $this->options );
        echo $this->content;
        
        $nbCols = count( $this->cols );        
        foreach( $this->cols as $col ){
            if ( !is_array($col) ){
                $col = array( 'content' => $col );
            }
            if ( isset($col['sizes']) ){
                $sizes = $col['sizes'];
            } else if ( isset($col['size']) ){
                $sizes = array( 'xs' => $col['size']);                
            } else {
                $sizes = array( 'xs' => floor( 12 / $nbCols ) );
            }   
            if ( isset($col['offsets']) ){
                $offsets = $col['offsets'];
            } else if ( isset($col['offset']) ){
                $offsets = array( 'xs' => $col['offset']);                
            } else {
                $offsets = array();
            } 
            
            $class = "";
            foreach( $sizes as $size => $val ){
                $class .= " col-$size-$val";
            }
            foreach( $offsets as $size => $val ){
                $class .= " col-$size-offset-$val";
            }
            if ( isset($col['pushs']) ){
                foreach( $col['pushs'] as $size => $val ){
                    $class .= " col-$size-push-$val";
                }
            }
            if ( isset($col['pulls']) ){
                foreach( $col['pulls'] as $size => $val ){
                    $class .= " col-$size-pull-$val";
                }
            }
            if ( isset($col['visibles']) ){
                foreach( $col['visibles'] as $size => $val ){
                    if ( $val === true ){
                        $class .= " visible-$size";
                    } else if ( $val === false ) {
                        $class .= " hidden-$size";
                    }
                }
            }
            
            $options = array( "class" => $class);            
            if ( isset($col['options']) ){
                $this->controller->addOptions( $options, $col['options'] );
            }
            echo CHtml::openTag("div", $options );
            echo $col['content'];
            echo CHtml::closeTag("div" );
        }
        
        echo CHtml::closeTag("div" );
    }
}
