var Layer2 = (function() {
    var background_drop = null;
    var sizes = {
        svg: { width: ko.observable(1920), height: ko.observable(1080) },
        html: { width: ko.observable(759), height: ko.observable(428) }           
    };
    
    var targetElement;
    var editRatio = ko.computed(function(){
       return  sizes.svg.width() / sizes.svg.height();
    }).extend({ rateLimit: 1000 });
    function resize( ar) {
        if ( targetElement ) {
            var width = targetElement.parent().width();
            var height = width/ar;
            targetElement.width(width);
            targetElement.height(height);
            //console.log( sizes.svg.width()+"x"+sizes.svg.height()+" => "+width + "x" +height + " => "+ar);
            sizes.html.width( width );
            sizes.html.height( height );
        }        
    };  
    $( window ).resize( function( ev ) { 
        if ( ev.target === window ){
            resize( editRatio() ); 
        }
    } );
    $( function() { resize( editRatio() ); });
    
    editRatio.subscribe( function( newValue ) { 
        setTimeout(function() {
            // need to wait for all the other changes (that may include the html to be modified)
            // before actually doing the resize itself
            resize( newValue );              
        }, 0 );             
    });
    
    function toHtmlX( dim ){
        return Math.floor( dim/sizes.svg.width()*sizes.html.width() ) + "px";
    }
    function toHtmlY( dim ){
        return Math.floor( dim/sizes.svg.height()*sizes.html.height() ) + "px";
    }
    function fromHtmlX( dim, width ){
        var x = Math.ceil( dim*sizes.svg.width()/sizes.html.width() );
        if ( x<0 )
            x = 0;
        if ( width && x>sizes.svg.width()-width )
            x=sizes.svg.width()-width;
        return x;
    }
    function fromHtmlY( dim, height ){
        var y = Math.ceil( dim*sizes.svg.height()/sizes.html.height() );
        if ( y<0 )
            y = 0;
        if ( height && y>sizes.svg.height()-height )
            y=sizes.svg.height()-height;
        return y;
    }
    return function( data, playout ) {        
        var self = this;
        
        if ( data === 'setTarget' ){
            targetElement = arguments[1];            
            return;
        };
        if ( data === 'getEditRatioObservable' ){            
            return editRatio;
        };
        self.getPlayout = function() {
            return playout;
        };
        
        self.fromJS = function( data ) {
            var args = data.args || {
                top: 0, left: 0, width: sizes.svg.width(), height: sizes.svg.height() 
            };
            self.type = data.type;  
            if ( data.background ){
                // background is the same as the svg sizes
                self.args = {
                    top: ko.observable(0),
                    left: ko.observable(0),
                    width: sizes.svg.width,
                    height: sizes.svg.height
                };                                           
                self.args.width( args.width );
                self.args.height( args.height );
                self.color = ko.observable( data.color || '#000000' );
                self.backgroundProperties = [
                    { name: spxapi.t('Color'), type : 'color', value: self.color }
                ];                
            } else {
                self.args = ko.mapping.fromJS( args );
            }

            if ( self.type === 'playlist' ){
                self.playlist = new Playlist2( data.data, {
                    editName: false
                } );            
            } else {                     
                data.data.widgetType = 'layer';
                self.givenName = ko.observable( data.data.name );
                self.apps = ko.observable( new Apps2( data.data ) );
            }
            self.background = data.background;            
            self.resizable = !self.background;
            self.draggable = !self.background;

            self.left = ko.computed(function() {
                return toHtmlX( self.args.left() );
            });        
            self.top = ko.computed(function() {
                return toHtmlY( self.args.top() );
            });
            self.width = ko.computed(function() {
                return toHtmlX( self.args.width() );
            });
            self.height = ko.computed(function() {
                return toHtmlY( self.args.height() );
            });
            self.maxHeight = sizes.html.height() + "px";
        };
        self.fromJS( data );

        self.toJS = function(){
            data = {
                type: self.type,
                args: ko.mapping.toJS( self.args )
            };
            if ( self.type === 'playlist' ){
                data.data = self.playlist.toJS();
            } else {
                data.data = self.apps().toJS();
                if ( self.givenName() ){
                    data.data.name = self.givenName();
                }
            }
            if ( self.background ){
                data.color = self.color();
            }
            return data;
        };
        self.toJSON = function(){
            return JSON.stringify( self.toJS() );
        };
        self.overlap = ko.observable( false ).extend({ rateLimit: 0 });
        self.selected = ko.observable( false );   
        self.name = ko.computed( {
            read: function() {
                var name;
                if ( self.type === 'playlist' ) {
                    name = self.playlist.name();
                } else {
                    if ( self.givenName() ){
                        name = self.givenName();
                    } else {
                        name = self.apps().name;
                    }
                }
                if ( name.length > 20 ){
                    name =  name.substr(0,17) + "...";
                }
                return name;
            },
            write: function( value ) {
                if ( self.type === 'playlist' ) {
                    self.playlist.name( value );
                } else {
                    self.givenName( value );
                }
            }
        });
        self.preview = ko.computed( function() {
            if ( self.type === 'playlist' ) {
                return self.playlist.preview();
            } else {
                return self.apps().preview() + "&width="+self.args.width() + "&height="+self.args.height();
            }
        });
        self.editTooltipText = ko.computed(function() {
            if ( self.type === 'playlist' ){
                if ( self.playlist.media().length > 1 ){
                    return spxapi.t("Edit Set");
                } else {
                    return spxapi.t("Create Set");
                }
            } else if ( self.type === 'apps' ){
                return spxapi.t("Edit Apps");
            }        
            return "???";
        });
        self.cleanup = function () {
            if ( self.type === 'apps' && self.apps() ){
                self.apps().cleanup();
            }
        };


        self.drag = function( event, ui ) {
            self.args.left( fromHtmlX( ui.position.left, self.args.width() ) );
            self.args.top( fromHtmlY( ui.position.top, self.args.height() ) );        
        };
        self.resize = function( event, ui ) {
            self.args.left( fromHtmlX( ui.position.left ) );
            self.args.top( fromHtmlY( ui.position.top ) );

            self.args.width( fromHtmlX( ui.size.width ) );
            self.args.height( fromHtmlY( ui.size.height ) );

        };
        editRatio.subscribe( function( newValue ) {
            var x = self.args.left();
            var width = self.args.width();
            var y = self.args.top();
            var height = self.args.height();
            
            if ( width>sizes.svg.width() ){
                self.args.left( 0 );
                self.args.width( sizes.svg.width() );
            } else if ( x>sizes.svg.width()-width ){
                self.args.left(sizes.svg.width()-width);
            }
            
            if ( height>sizes.svg.height() ){
                self.args.top( 0 );
                self.args.height( sizes.svg.height() );
            } else if ( y>sizes.svg.height()-height ){
                self.args.top(sizes.svg.height()-height);
            }
        });
        self.createSet = ko.observable( self.playlist && self.playlist.media().length > 2 );
        
        self.addPlaylistItem = function( item ) {
            if ( self.playlist ){
                var playlistItem = self.playlist.createPlaylistItem( item );
                if ( self.createSet() ){
                    self.playlist.push( playlistItem );
                } else {
                    self.playlist.set( playlistItem );
                }
            }            
        };
        self.clearPlaylist = function( item ) {
            self.createSet( false );
            if ( self.playlist ){
                self.playlist.set( [] );
            }            
        };
        self.drop = function( item, event, ui ) {
            if ( self.background ){
                if ( background_drop===null ){
                    background_drop = true;
                    // do it at the end
                    setTimeout(function() {
                        self.drop( item, event, ui );
                    }, 0 ); 
                    return true; // drop is fine for the background
                } else if ( background_drop === false ) {
                    background_drop = null;
                    return true; // this was not for the background
                } else {
                    // this is for us
                    background_drop = null;
                }
            } else {
                if ( self.type !== 'playlist' )
                    return false;
                background_drop = false;
            }
            

            self.addPlaylistItem( item );
            self.getPlayout().select( this, true );
            return true;
        };
        self.preserveAspectRatio = ko.computed(function() {
            if ( !self.playlist ){
                return "";
            }
            if ( self.playlist.options.mediaFit() === 'fill' ){
                return "none";
            }
            var map = { center: 'xMidYMid', midLeft:'xMinYMid', midRight:'xMaxYMid', topMid:'xMidYMin', bottomMid:'xMidYMax' };
            return map[self.playlist.options.mediaAlign()] + " " + self.playlist.options.mediaFit();
        });
        self.getStyle =function() {
            return { 
                width: self.width(), 
                height: self.height(), 
                padding: (self.width()/self.height()*100)+'% 0 0' 
            };
        };
    };
}());
var Playout2 = function( data ) {
    var self = this;
    self.editRatio = Layer2('getEditRatioObservable');
    var appsEditLink = data.appsEditLink;
    
    this.fromJS = function( data ) {
        self.name = ko.observable( data.name ); 
        self.locked = ko.observable( data.options && data.options.locked );
        self.keywords = ko.observable();
        if ( data.keywords ){
            self.keywords(data.keywords.join(","));
        }
        self.manage = data.manage;
        self.type = data.type;
        self.layers = ko.observableArray();
        data.layers = data.layers || [];
        if ( data.layers.length === 0 ) {
            
            // we must have a backgournd
            var layer = {
                type: 'playlist',                
                data: {
                    name : spxapi.t('Background'),
                    media: []
                }
            };
            if ( data.vertical ){
                layer.args = { top: 0, left: 0, width: 1080, height: 1920 };
            } else {
                layer.args = { top: 0, left: 0, width: 1920, height: 1080 };
            }
            data.layers.push( layer );
        }        
        for( var i=0; i<data.layers.length; i++ ){
            if ( i === 0 )
                data.layers[i].background = true; 
            if ( data.layers[i].type === 'apps' && data.layers[i].data.apps.uri ){
                data.layers[i].data.apps.editLink = appsEditLink.replace( "%5Bid%5D", data.layers[i].data.id );
            }
            self.layers.push( new Layer2( data.layers[i], self ) );
        }    
        if ( data.active ){
            spxapi.ui.message({
                type: 'info',
                title: spxapi.t('Live Content'),
                text: spxapi.t("This is currently displayed on the screen")
            });            
        }
        //self.active = ko.observable( data.active ); 
    };
    this.toJS = function(){
        var data = {
            name: self.name(),
            options: { locked: self.locked() },
            layers: []
        };
        if ( self.keywords() ){
            data.keywords = self.keywords().split(",");
        }
        var layers = self.layers();
        for( var i=0; i<layers.length; i++ ){
            data.layers.push( layers[i].toJS() );
        } 
        return data;
    };   
    self.toJSON = function(){
        return JSON.stringify( self.toJS() );
    };
    
    this.fromJS( data );
    self.remove = function( layer ){
        if ( layer.selected() ){
            self.select( null );
        }
        layer.cleanup();
        self.layers.remove( layer );        
    };
    self.add = function( data ){
        var layer = new Layer2( data, self );
        self.layers.push( layer );
        return layer;
    };
    
    self.move = function( oldPos, newPos ) {
        self.layers.splice(newPos, 0, self.layers.splice(oldPos, 1)[0]);
    };
    self.drop = function( item, event, ui ) {
        var layer ;
        ui.position.top = ui.position.top-70;
        if ( item.type === 'builtin' ){
            layer = self.add({
                type: 'playlist', 
                args: {
                    top: 0,
                    left: 0,
                    width : 1280,
                    height: 720
                },
                data: {
                    name : spxapi.t('Media'),
                    media: []
                }
            });   
            layer.drag( event, ui );
            self.select( layer, true );
        } else {
            spxapi.apps.get( item.manage ).done( function( apps ) {
                // by default select the first widget that can be used as a layer
                var widgetId, widget = null;
                for ( widgetId in apps.widgets ){                    
                    if ( apps.widgets[widgetId].type !== 'slide' ){
                        widget = apps.widgets[widgetId];
                        break;
                    }
                }
                if ( widget ) {
                    if ( apps.uri ){
                        apps.editLink = appsEditLink.replace( "%5Bid%5D", apps.id );
                    }
                    var width = widget.width || 1280;
                    var height = widget.height || 720;
                    layer = self.add({
                        type: 'apps', 
                        args: {
                            top: 0,
                            left: 0,
                            width : width,
                            height: height
                        },
                        data: {
                            id: apps.id,
                            widgetId: widgetId,
                            query : {},
                            apps: apps
                        }
                    });
                    layer.drag( event, ui );
                    self.select( layer, true );
                }
            });
        }
        
    };
    self.selectedLayer = ko.observable( null );
    self.select = function( layer, force ){
        var selectIdx, 
            selectedLayer,
            layers = self.layers();
        if ( layer && layer.selected() ){
            if ( force === true )
                return;
            else 
                layer = null;
        }        
        selectedLayer = self.selectedLayer();
        self.selectedLayer( layer );
        
        if ( selectedLayer ){
            selectIdx = layers.indexOf( selectedLayer );
            if ( !layer ){
                $('#collapseLayer'+selectIdx).collapse('hide'); 
            }
            $('#collapseLayer'+selectIdx).parent().addClass('collapsed')
                                                  .removeClass('not-collapsed');
            selectedLayer.selected( false );
        }       
        if ( layer ) {
            layer.selected( true );
            selectIdx = layers.indexOf( layer );
            $('#collapseLayer'+selectIdx).collapse('show');       
            $('#collapseLayer'+selectIdx).parent().removeClass('collapsed')
                                                  .addClass('not-collapsed');;
        }
    };
     
    self.editProperties = ko.observable( false );
    self.properties = [ ];
    self.properties.push( { name: spxapi.t('Name'), type : 'string', value: self.name } );
    this.properties.push( { name: spxapi.t('Keywords'), type : 'tags', value: self.keywords, options: { tags: keywordsMemory().get() } } );
    if ( self.type === 'template' ){
        self.orientation = ko.computed({
            read: function() {
                return self.layers()[0].args.width()>self.layers()[0].args.height()?'horizontal':'vertical';
            },
            write: function( dir ) {
                if ( dir === 'horizontal' ){
                    self.layers()[0].args.width(1920);
                    self.layers()[0].args.height(1080);
                } else {
                    self.layers()[0].args.width(1080);
                    self.layers()[0].args.height(1920);
                }
            }
        });
        self.properties.push( { name: spxapi.t('Orientation'), type : 'choice' , value: self.orientation, select: [
                { name: spxapi.t("Horizontal"), value: 'horizontal' },
                { name: spxapi.t("Vertical"), value: 'vertical' }
        ]} );
        self.properties.push( { name: 'Locked', type : 'boolean', value: self.locked } );
        //self.properties.push( { name: 'Height', type : 'number', value: self.layers()[0].args.height } );
    }
    
    self.overlap = ko.computed( function() {
        var overlap = false;
        var layers = self.layers();
        for( var i=1; i<layers.length; i++ ){
            layers[i].overlap( false );
        }
        for( var i=1; i<layers.length; i++ ){
            for( var j=i+1; j<layers.length; j++ ){
                var li = layers[i].args;
                var lj = layers[j].args;
                var x1 = Math.max(parseInt(li.left()), parseInt(lj.left()) );
                var x2 = Math.min(parseInt(li.left())+parseInt(li.width()), parseInt(lj.left())+parseInt(lj.width()) );
                if ( x1 < x2 ){
                    var y1 = Math.max(parseInt(li.top()), parseInt(lj.top()) );
                    var y2 = Math.min(parseInt(li.top())+parseInt(li.height()), parseInt(lj.top())+parseInt(lj.height()) );
                    if ( y1 < y2 ){
                        overlap = true;                        
                        layers[i].overlap( true );
                        layers[j].overlap( true );
                    }
                }                 
            }
        }
        return overlap;
    }).extend({ rateLimit: 1000 });
    
    self.switchVertical = function( ){
        var layers = self.layers();
        var selectedLayer = self.selectedLayer();
        var height = parseInt( layers[0].args.height() );
        if ( selectedLayer && !selectedLayer.background ){
            selectedLayer.args.top( height - parseInt(selectedLayer.args.top(),10) - parseInt(selectedLayer.args.height(),10) );
        } else {
            for( var i=1; i<layers.length; i++ ){
                var args = layers[i].args;            
                args.top( height - parseInt(args.top(),10) - parseInt(args.height(),10) );
            }
        }
    };
    self.switchHorizontal = function( ){
        var selectedLayer = self.selectedLayer();
        var layers = self.layers();
        var width = parseInt( layers[0].args.width(), 10 );
        if ( selectedLayer && !selectedLayer.background ){
            selectedLayer.args.left( width - parseInt(selectedLayer.args.left(),10) - parseInt(selectedLayer.args.width(),10) );
        } else {
            for( var i=1; i<layers.length; i++ ){
                var args = layers[i].args;            
                args.left( width - parseInt(args.left(),10) - parseInt(args.width(),10) );
            }
        }
    };
    function fillVertical( selectedLayer ){
        var margin = 40;
        var pos = selectedLayer.args;
        var layers = self.layers();
        var height = parseInt(layers[0].args.height());
        var target = { top: 0, bottom: height };
        
        for( var i=1; i<layers.length; i++ ){
            if ( layers[i] === selectedLayer ){
                continue;
            }
            var args = layers[i].args;            
            if ( parseInt( args.left(), 10 ) < parseInt( pos.left(),10 )+parseInt(pos.width(),10) 
                    && parseInt(args.left(),10)+parseInt(args.width(),10) > parseInt(pos.left(),10) ){
                // horizontal 
                var bottom = parseInt(args.top(),10)+parseInt(args.height(),10);
                var top = parseInt(args.top(),10);
                if ( bottom < parseInt(pos.top(),10) && bottom > target.top ){
                    target.top = bottom;                
                }
                if ( top > parseInt(pos.top(),10)+parseInt(pos.height(),10) && top < target.bottom ){
                    target.bottom = top;                
                }
            }                         
        }
        if ( target.top < target.bottom-2*margin ){
            pos.top( target.top + margin );
            pos.height( target.bottom - target.top - 2*margin );
        }
    }
    function fillHorizontal( selectedLayer ){
        var margin = 40;
        var pos = selectedLayer.args;
        var layers = self.layers();
        var width = parseInt( layers[0].args.width() );
        var target = { left: 0, right: width };
        
        for( var i=1; i<layers.length; i++ ){
            if ( layers[i] === selectedLayer ){
                continue;
            }
            var args = layers[i].args;            
            if ( parseInt(args.top(),10) < parseInt(pos.top(),10)+parseInt(pos.height(),10) 
                    && parseInt(args.top(),10)+parseInt(args.height(),10) > parseInt(pos.top(),10) ){
                // vertical 
                var right = parseInt(args.left(),10)+parseInt(args.width(),10);
                var left = parseInt(args.left(),10);
                if ( right < pos.left() && right > target.left ){
                    target.left = right;                
                }
                if ( left > parseInt(pos.left(),10)+parseInt(pos.width(),10) && left < target.right ){
                    target.right = left;                
                }
            }                        
        }
        if ( target.left < target.right-2*margin ){
            pos.left( target.left + margin );
            pos.width( target.right - target.left - 2*margin );            
        }
    }
    self.fillVertical = function( ){
        var selectedLayer = self.selectedLayer();
        if ( !selectedLayer || selectedLayer.background ){
            var layers = self.layers();
            for( var i=1; i<layers.length; i++ ){
                fillVertical( layers[i] );
            }
        } else {
            fillVertical( selectedLayer );
        }
    };
    self.fillHorizontal = function( ){
        var selectedLayer = self.selectedLayer();
        if ( !selectedLayer || selectedLayer.background ){
            var layers = self.layers();
            for( var i=1; i<layers.length; i++ ){
                fillHorizontal( layers[i] );
            }
        } else {
            fillHorizontal( selectedLayer );
        }
    };
};

function PlayoutEdit( args ) {
    
    args = args || {};
    var type = args.type || 'playout';
    var self = this;
    if ( !args.layoutOnly ) {
        self.media = resourcesSelect({
            resources: [ 'media' ],
            draggable : true,
            keepHidden: type === 'template'
        });
        iconView( self.media, { 
            draggable : true,
            rows: 1,
            sizes: { large: "col-md-4 col-sm-12", medium: "col-md-2 col-sm-4 col-xs-6", small: "col-md-1 col-sm-3 col-xs-4" }
        } );
    }
    self.apps = resourcesSelect({
        resources: [ {
            id: "media",
            name: spxapi.t("Media zone"),
            desc: spxapi.t("Media zone"),
            type: "builtin",
            keywords: ['default'],
            model: spxapi.resources.add ( {
                id: 'new layer'
            })
        }, 'apps' ],
        vertical: false,
        draggable : true
    });
    iconView( self.apps, {
        draggable : true,        
        itemCss: 'apps',
        rows: 1,
        sizes: { large: "col-md-4 col-sm-12", medium: "col-md-2 col-sm-4 col-xs-6", small: "col-md-1 col-sm-3 col-xs-4" }
    });    
    self.id = ko.observable();
    if ( args.id !== 'vertical' && args.id !== 'horizontal' ){
        self.id( args.id );
    }
    self.playout = ko.observable( new Playout2({        
        name: spxapi.t("New Playout"), 
        type: type,
        vertical:  args.id === 'vertical',
        appsEditLink: args.appsEditLink
    }));  
    
    self.useVerticalLayout = ko.observable();
    function verticalLayout( vertical, playlistEdit ){
        var w = $(window).width();
        var maxWidth = args.layoutOnly?992:768;
        if ( vertical && w >= maxWidth ) {
            if ( w >= 992 ){
                if ( $('#selectZone').parent() !== $('#selectZoneVertical') ){
                    $('#selectZone').appendTo("#selectZoneVertical");
                }
            } else {
                if ( $('#selectZone').parent() !== $('#selectZoneHorizontal') ){
                    $('#selectZone').appendTo("#selectZoneHorizontal");
                }
            }
            self.apps.setSizes( { large: "col-md-12 col-sm-4", medium: "col-md-6 col-sm-3 col-xs-6", small: "col-md-3 col-sm-2 col-xs-4" },2 );
            if ( !args.layoutOnly ) {
                self.media.setSizes( { large: "col-md-12 col-sm-4", medium: "col-md-6 col-sm-3 col-xs-6", small: "col-md-3 col-sm-2 col-xs-4" },2 );
            }
            self.useVerticalLayout( true );
        } else {
            if ( $('#selectZone').parent() !== $('#selectZoneHorizontal') ){
                $('#selectZone').appendTo("#selectZoneHorizontal");
            }
            
            
            if ( !args.layoutOnly ) {
                self.apps.setSizes( { large: "col-md-4 col-sm-12", medium: "col-md-2 col-sm-4 col-xs-6", small: "col-md-1 col-sm-3 col-xs-4" } ,1 );
                if ( playlistEdit ){
                    self.media.setSizes( { large: "col-md-4 col-sm-4", medium: "col-md-2 col-sm-3 col-xs-6", small: "col-md-1 col-sm-2 col-xs-4" },1 );
                } else {
                    self.media.setSizes( { large: "col-md-4 col-sm-12", medium: "col-md-2 col-sm-4 col-xs-6", small: "col-md-1 col-sm-3 col-xs-4" },1 );
                }                
            } else {
                self.apps.setSizes( { large: "col-md-4 col-sm-4", medium: "col-md-2 col-sm-3 col-xs-6", small: "col-md-1 col-sm-2 col-xs-4" },1 );
            }
            self.useVerticalLayout( false );
        }
    }
    self.playout().editRatio.subscribe( function( newVal ){ 
        verticalLayout( newVal < 1 );        
    });    
    $( window ).resize( function() {
        if ( !self.playlist() ){
            verticalLayout( self.playout().editRatio() < 1 );
        }
    });
    self.status = new ko.dirtyFlag( self.playout, true );
    
    spxapi.ui.resourceLoadingInfo.start();
    self.load = function(){
        if ( self.id() ){
            spxapi.ui.resourceLoadingInfo.toLoad++;
            self.playout().name( spxapi.t("Loading ...")  );
            spxapi[type].get( spxapi[type].uri + self.id() + "/" )
            .done( function( data ){
                data.appsEditLink = args.appsEditLink;
                self.playout( new Playout2( data ));
                self.status.reset();
            }).always(function( data ) {
                spxapi.ui.resourceLoadingInfo.finished();                
            }); 
        } else if ( args.templateId ){
            spxapi.ui.resourceLoadingInfo.toLoad++;
            self.playout().name( spxapi.t("Loading ...")  );
            spxapi.template.get( spxapi.template.uri + args.templateId + "/" )
            .done( function( data ){
                data.type = 'playout';
                data.appsEditLink = args.appsEditLink;
                self.playout( new Playout2( data ));
                self.status.reset();
            }).always(function( data ) {
                spxapi.ui.resourceLoadingInfo.finished();                
            }); 
        } else {
            self.status.reset();
        }
    };
    self.load();
    
    // layer actions
    self.selectLayer = function( layer, force ){
        self.playout().select( layer, force );
    };
    self.removeLayer = function( layer ){
        self.playout().remove( layer );        
    };
    self.moveUp = function( layer ) {
        self.selectLayer( null );
        var idx = self.playout().layers.indexOf( layer );
        if ( idx > 1){
            self.playout().move(idx, idx-1);
            self.selectLayer( layer, true );
        }
    };
    self.moveDown = function( layer ) {
        self.selectLayer( null );
        var idx = self.playout().layers.indexOf( layer );
        if ( idx < self.playout().layers().length -1 ){
            self.playout().move(idx, idx+1);
            self.selectLayer( layer, true );
        }
    };
    
    self.editLayout = ko.observable( args.layoutOnly ); 
    
    self.playlist = ko.observable( null );
    self.appForLayout = ko.observable( null );
    
    self.editLayers = ko.computed( function() {
        return self.playlist() !== null || self.appForLayout() !== null  ;
    });

    this.startEditApps = function( layer ){
        self.selectLayer( layer, true );
        if ( layer.type === 'apps' ){
            self.appForLayout( layer );
        }
    };
    this.startEdit = function( layer ){   
        self.selectLayer( layer, true );        
        verticalLayout( false, true );
        if ( layer.type === 'playlist' ){
            self.playlist( layer.playlist );
        }    
        
    };
    this.stopEdit = function( ){   
        
        self.playlist( null ); 
        self.appForLayout( null );
        
        if ( !self.editLayers() ){
            verticalLayout( self.playout().editRatio() < 1 );
        }
    };
    self.breadcrumbs = ko.computed( function() {
        var breadcrumbs = [ { 
            name: ko.computed(function() { return self.playout().name(); }),
            active: ko.observable( true ),
            click: self.stopEdit
        } ];
        if ( self.playlist() ){
            breadcrumbs[breadcrumbs.length-1].active( false );
            breadcrumbs = breadcrumbs.concat( self.playlist().breadcrumbs() );
        }        
        if ( !args.layoutOnly && self.editLayout() ) {
            breadcrumbs[breadcrumbs.length-1].active( false );
            breadcrumbs.push( {
                name: spxapi.t("Edit"),
                active: ko.observable( true ),
                click: function() { 
                    self.appForLayout( null );
                }                
            });
            if ( self.appForLayout() ){
                breadcrumbs[breadcrumbs.length-1].active( false );
                breadcrumbs.push( {
                    name: self.appForLayout().name,
                    active: ko.observable( true ),
                    click: false                
                });
            }
        }
        return breadcrumbs;
    });    
    
    
        
    
    self.addMediaFile = function( data ) {
        // add a new media to the list of media
        self.media.add( data );
        if ( self.playlist() ) {
            // add the media to the playlist itself
            self.playlist().push( 
                    self.playlist().createPlaylistItem( data )
            );
        } else if ( self.playout().selectedLayer() ){
            var layer = self.playout().selectedLayer();
            if ( layer.type === 'playlist' ){
                layer.drop( data );
            }            
        }
    };
    
    
    self.apply = function ( data, event ) {      
        spxapi.ui.loading(event.target);
        var params = self.playout().toJS();
        if( self.id() ) {
            return spxapi[type].update( self.playout().manage, params ).done(function( data ){
                self.status.reset();                       
            }).always( function() {
                spxapi.ui.reset(event.target);
            });      
        } else {
            return spxapi[type].create( params ).done(function( data ){
                self.status.reset();
                
                // if this is a new item, then we complete it
                var memory = spxapi.storage.get("spx-calendar-new-item" );
                if ( memory ){
                    var newItem = JSON.parse( memory );
                    newItem.title = data.name;
                    newItem.resource = {
                        id: data.id,
                        type: data.type
                    };                    
                    spxapi.storage.set("spx-calendar-new-item", JSON.stringify( newItem ) );
                }   
                self.id( data.id );
                self.playout().manage = data.manage;
                type = data.type;
            }).always( function() {
                spxapi.ui.reset(event.target);
            });
        }        
    };
    self.cancel = function ( data, event ) { 
        location.href = args.backLink ||document.referrer;                 
    };
    self.save = function ( data, event ) {
        if ( self.editLayers() ){
            self.stopEdit();
        } else if ( !args.layoutOnly && self.editLayout() ) {
            self.editLayout( false );
        } else {
            self.apply( data, event ).done( function() {
                self.cancel( data, event );
            });
        }
    };
    
    self.copy = function ( data, event ) {
        self.id( null );
        self.playout().name( spxapi.t( "{name} - Copy", {"{name}":self.playout().name()}) ); 
        self.playout().editProperties( true );
    };
    
    // Prevent leaving the page with changes
    $(window).bind('beforeunload', function(e){
        if ( self.status.isDirty() ) {
            return spxapi.t("Some changes have not been saved.");
        } else {
            return;
        }
    });
    
}
