<?php
function pleasWaitPopup( $text ) {
?>
    <div class="modal" tabindex="-1" role="dialog" id="pleaseWaitDialog" data-backdrop="static" data-keyboard="false">
    <div class="modal-dialog">
        <div class="modal-content">
            <div class="modal-header">
                <h1 style="text-align: center;"><?php echo $text;?></h1>
            </div>
            <div class="modal-body">
                <div style="text-align: center;"><i class="fa fa-circle-o-notch fa-spin fa-4x"></i></div>

            </div>
        </div>    
    </div>
</div> 
<script type="text/javascript" >
//<![CDATA[   
$(function() {
    $("#pleaseWaitDialog").modal('show').children(".modal-dialog").css({
        'margin-top': function () { //vertical centering
            return ($(this).parent().height() / 2) - $(this).height() / 2;
        }
    });    
});
//]]></script>
<?php
}

function panel( $title, $img, $id = null ){
    $style = "width: 100%;";
    if ( $id == 'snapshot' ) {
        // because f... image for create and schedule have a margin inside the image for the shadow
        $style .= "padding-left: 1.5%; padding-right: 2%;";
    }
    return CHtml::image($img, $title, array( "style" => $style, "class"=>"spx-opacity-over"));        
}

$hasControlCenter = Yii::app()->user->checkAccess('useControlCenter');
if (SnapshotDisplay::isVertical( $playerConfig->orientation ) ){
    $sizes = array( "lg" => 4, "md" => 6, "xs" => 6 );
    $offsets = array( "lg" => 1, "md" => 0 );
    $snapshotSizes = array( "lg" => 2, "md" => 4, "sm" => 6, "xs" => 8 );
    $snapshotOffsets = array( "lg"=>0, "md" => 4, "sm" => 3, "xs" => 2 );
    $create = '/images/create_v.png';
    $schedule = '/images/schedule_v.png';
    $snapshotStyle = 'margin-top: 9%;';
} else {
    $sizes = array( "lg" => 5, "xs" => 6 );
    $offsets = array( "lg" => 1 );
    $snapshotSizes = array( "md" => 6, "sm" => 12 );
    $snapshotOffsets = array( "md" => 3 );
    $create = '/images/create.png';
    $schedule = '/images/schedule.png';
    $snapshotStyle = '';
}

$this->widget('BsRow', array(    
    'cols' => array( 
        array(  'sizes' => $sizes, 
                'offsets' => $offsets, 
                'content' => CHtml::link( 
                    panel( 'Create', $create ), 
                    array("/assets/playing/create")                         

                ) 
        ),   
        array(  'sizes' => $sizes, 
                'content' => CHtml::link( 
                    panel( 'Schedule', $schedule ), 
                    array("/assets/playing/schedule")                         
                ) 
        ), 
        array( 'sizes' =>$snapshotSizes, 
            'offsets' => $snapshotOffsets,
            'content' => $this->widget('SnapshotDisplay', array(
                                'resolution' => $screenInfo->resolution,
                                'aspect' => $screenInfo->aspect,
                                'orientation' => $playerConfig->orientation,
                                'link' => $hasControlCenter?array( "/controlcenter/main/index" ):null,
                                'clickToRefresh' => !$hasControlCenter,
                                'style' => $snapshotStyle
                            ), true )            
        ), 
    )
)); 

$wizard = new Wizard();
if( $wizard->getWelcome() ){
    $targetRedirect = CHtml::normalizeUrl( array('/controlcenter/main/index') );
} else {
    $targetRedirect = null;
}
if ( Actions::getAction( 'recovery needed' ) ){   
    pleasWaitPopup( "Power loss recovering, please wait" );
    $recoverUrl = $this->createUrl("/api/api/recover")
?>
<script type="text/javascript" >
//<![CDATA[   
$(function() {
    $.ajax( "<?php echo $recoverUrl;?>").always( function( data ){        
        <?php 
            if ( Actions::getAction( 'preview' ) ) {
                echo "location.reload();"; 
            } else {                
                echo '$("#pleaseWaitDialog").modal("hide");';
            }
        ?>        
    });    
});
//]]></script>
<?php
} else if ( Actions::getAction( 'preview' ) ){
    Actions::setAction( 'preview', false );
    pleasWaitPopup( "Updating, please wait" );
?>    
<script type="text/javascript" >
//<![CDATA[   
$(function() {
    spxapi.template.list().always( function(){
        spxapi.playout.list().always( function(){
            <?php 
                if ( $targetRedirect ) {
                    echo "window.location = '$targetRedirect';"; 
                } else {
                    echo '$("#pleaseWaitDialog").modal("hide");';
                }
            ?>                    
        });
    });
});
//]]></script>
<?php
} else { 
    if( $targetRedirect ){
        echo CHtml::script("$(function() { window.location = '$targetRedirect'; });" );
    }
}
?>
<script type="text/javascript" >
//<![CDATA[
$(function() {
    $('#cl-wrapper').addClass("grad");
    $(".cl-mcont").css("background-color", "inherit");
});
//]]></script>
