<?php

// change the following paths if necessary
if( PHP_OS == "WINNT" ) {
    $yii=dirname(__FILE__).'/../../framework/yii.php';
} else {
    $yii='yii-framework/yii.php';
}
$config=dirname(__FILE__).'/config/console.php';

// set PHP timezone from setings
if(PHP_OS != "WINNT") {
    $realpath = readlink( "/etc/localtime" );
    if ( substr( $realpath,0,1 )!='/' )
        $realpath = realpath( "/etc/" . $realpath );
    $pos = strpos( $realpath, "zoneinfo/");
    if ( $pos!==false ) {
        $link = substr($realpath, strpos( $realpath, "zoneinfo/")+9);
        date_default_timezone_set( $link );
    }
} else {
    date_default_timezone_set( 'UTC' );
}

// fix for fcgi
defined('STDIN') or define('STDIN', fopen('php://stdin', 'r'));

defined('YII_DEBUG') or define('YII_DEBUG',true);

require_once( $yii );

include ( dirname(__FILE__).'/components/MyConsoleApplication.php' );
if(isset($config))
{
    $app = Yii::createApplication( 'MyConsoleApplication', $config );	
	$app->commandRunner->addCommands(YII_PATH.'/cli/commands');
}
else
	$app=Yii::createConsoleApplication(array('basePath'=>dirname(__FILE__).'/cli'));

$env=@getenv('YII_CONSOLE_COMMANDS');
if(!empty($env))
	$app->commandRunner->addCommands($env);

$app->run();
