var keywordsMemory = function ( args ){
    args = args || {};
    
    var keywords = [];
    if ( args.reset ) {
        //console.log("reset keywords");
        spxapi.storage.remove("spx-default-keywords" )
    } else {
        keywords = JSON.parse( spxapi.storage.get("spx-default-keywords" ) );
        if ( !keywords ){
            keywords = [];
        }
    }
    
    var self = {
        add: function( keyword ){
            for( var i=0; i<keywords.length; i++ ){
                if ( keywords[i]=== keyword ){
                    return;
                }
            }
            keywords.push( keyword );
            spxapi.storage.set("spx-default-keywords", JSON.stringify( keywords ));            
        },
        get: function(){
            return keywords;
        },
        reset: function(){
            keywords = [];
             spxapi.storage.remove("spx-default-keywords" );
        }
    };
    return self;
};
var substringMatcher = function( stringsObservableArray ) {
    return function findMatches(q, cb) {
        var matches, substrRegex;

        matches = [];
        substrRegex = new RegExp(q, 'i');

        $.each( stringsObservableArray(), function(i, str) {
            if (substrRegex.test(str)) {
                matches.push({value: str});
            }
        });
        if ( matches.length > 5 ) {
            matches.splice(5, matches.length - 5 );
        }
        cb(matches);
    };
};
var resourcesSelect = function( args ) {
    args = args || {};
    var resources = args.resources || [ 'media' ];
    var keepAllApps = args.keepAllApps !== false;
    var keepHidden = args.keepHidden;
    var memory = keywordsMemory();
    var viewId = args.viewId || 'default';
    
    var mainModel = {
        viewId: args.viewId || 'default',
        types: ko.observableArray([""]),
        keywords: ko.observableArray( [] ),//.extend({ rateLimit: 0 });
        names: ko.observableArray( [] ),//.extend({ rateLimit: 0 });
        table: ko.observable(),
        selected: ko.observableArray(),
        prepareModel: function( row, td, id, rowData ){     
            var table = mainModel.table();
            var model = {
                row: row,
                table: table,
                id: id,
                resourceModel: rowData.model,
                remove: mainModel.remove               
            };
            model.checked = ko.computed({
                read: function () {
                    var sel = mainModel.selected();
                    for (var i = 0; i < sel.length; i++){
                        if ( sel[i].id === model.id ){
                           return true;
                        }
                    }
                    return false;
                },
                write: function ( checked ) {  
                    var sel = mainModel.selected();
                    var idx = -1;
                    for (var i = 0; i < sel.length; i++){
                        if ( sel[i].id === model.id ){
                            idx = i; 
                            break;
                        }
                    }
                    if ( checked ){
                        if ( idx === -1 ) {                                
                            mainModel.selected.push( model );
                        }
                    }else {
                        if ( idx !== -1 ) {
                            mainModel.selected.splice( idx, 1 );
                        }
                    }
                }
            });
            return model;
        },
        columns: [
                {   title: "", 
                    data : "model", orderable : false,
                    createdCell: function (td, cellData, rowData, row, col) {
                        if ( args.draggable ) {
                            $(td).html("");
                            var img = $("<img class='icon' data-bind='draggable: { data: $root, template: false }' src='"+cellData.snapshots.small.src()+"'/>");
                            $(td).append(img);
                            
                            //ko.applyBindings(rowData, img[0]); 
                        } else {
                            var img = $("<img class='icon' src='"+cellData.snapshots.small.src()+"'/>");
                            $(td).html( img );             
                            if ( mainModel.open && ( rowData.model.type() != 'apps' || rowData.uri)){                               
                                var model = mainModel.prepareModel( $(row), img[0], rowData.id, rowData );                
                                model.open = function() { mainModel.open( model ); };
                                img.attr("data-bind", "click: open");
                                ko.applyBindings(model, img[0]); 
                            }
                        }                        
                    } 
                },
                {   title: spxapi.t("name"), 
                    data : "name"
                },
                {   title: spxapi.t("type"), 
                    data : "type"
                },
                {   title: spxapi.t("keywords"), 
                    data : "keywords"
                },
                {   
                    title: "", 
                    data : "id", orderable : false, width: '160px',
                    createdCell: function(td, cellData, rowData, row, col) { 
                        $(td).html("");
                        if ( mainModel.canSelect && mainModel.canSelect(rowData) ) {                                                       
                            var actions = $("<input type='checkbox' data-bind='iCheck: checked'/>")
                                .addClass("form-control input-sm btn-sm spx-visible-check")                
                                .appendTo( td );
                            var model = mainModel.prepareModel( $(td).parents('tr'), actions[0], cellData, rowData );                               
                            ko.applyBindings(model, actions[0]);                            
                        }
                    }
                }
        ],
        addColumn: function ( col ){
            mainModel.columns.splice(mainModel.columns.length-1, 0, col );
        },
        remove: function( model, nodraw ){
            spxapi.resources.delete( model.id, function( data ){
                if ( data !== false){
                    var r = model.table.row( model.row );
                    r.remove();
                    if ( nodraw === undefined ){
                        r.draw( false );
                    }
                    if ( nodraw === false ){
                        setTimeout(function() {
                            r.draw( false ); // to make sure all actions are over when doing the redraw
                        }, 500 );
                    }
                }
            });
        }
    };
    mainModel.searchDatasets = [{
        name: 'keywords',
        templates :{
            header: spxapi.t("Keywords")
        },
        source: substringMatcher( mainModel.keywords )
    },{
        name: 'names',
        templates :{
            header: spxapi.t("Names")
        },
        source: substringMatcher( mainModel.names )
    }];
    mainModel.addMediaFile = function( data ){
        var table = mainModel.table();
        var kw = data.model.vertical()? "vertical" : "horizontal";
        if ( data.keywords ) {
            data.keywords.push( kw );
        } else {
            data.keywords = [ kw ];
        }
        mainModel.vertical( data.model.vertical() );
        
        var insertedRow = table.row.add( data ); 
        insertedRow.draw( false );
        // find the index of the row
        var idx = table.rows().indexes().indexOf( insertedRow.index() );
        var pageSize = table.page.info().length;
        table.page( Math.floor(idx / pageSize ) ).draw(false);
    }; 
    
    
    
    function addKeywords( keywords )  {
        for ( var i=0; i<keywords.length; i++ ){
            if ( mainModel.keywords.indexOf(keywords[i]) === -1 ){
                mainModel.keywords.push( keywords[i] );
                memory.add( keywords[i] );
            }
        }
    };
    function addName( name )  {
        if ( mainModel.names.indexOf( name ) === -1 ){
            mainModel.names.push( name );            
        }
    };
    mainModel.typeOptionText = function( val ) {
        var names = {
            "": spxapi.t("All"),
            "playlist" : spxapi.t("Playlists"),
            "playout" : spxapi.t("Playouts"),
            "external" : spxapi.t("Live Sources")
        };
        if ( val in names ){
            return names[val];
        }
        return spxapi.t( val.charAt(0).toUpperCase() + val.slice(1) );
    };
    if ( args.vertical !== undefined ){
        spxapi.storage.set("spx-"+viewId+"-iconviewvertical", args.vertical );
    }
    mainModel.vertical = ko.observable( spxapi.storage.get("spx-"+viewId+"-iconviewvertical")==='true' );
    mainModel.vertical.subscribe( function( newVal) {
        spxapi.storage.set("spx-"+viewId+"-iconviewvertical", newVal );
        mainModel.setPageLength( mainModel.tableView()? "list" : mainModel.iconSize );
    });
    mainModel.typeSearch = ko.observable( );
    mainModel.inputSearch = ko.observable();
    mainModel.search = ko.computed( function() {
        // force dropdown to be re-read, if the searach items are updated
        var s = "";
        if ( args.vertical !== false ) {
            if ( mainModel.vertical() ){
                s = "vertical";
            } else {
                s = "horizontal";
            }
        }
        if ( mainModel.typeSearch() ){
            s += " " +mainModel.typeSearch();
        }
        
        if ( mainModel.inputSearch() ){            
            s += " " + mainModel.inputSearch();
        }
        
        if ( mainModel.table() ){
            mainModel.table().search( s ).draw();                    
        }
        return s;
    });
    mainModel.add = function( data ) {
        
        if ( $.type(data) === 'array' ){            
            var keptData = [];
            for( var i=0; i< data.length; i++ ) {
                if ( !keepAllApps && data[i].type === 'apps' && data[i].uri === null ) {
                    continue;
                }
                if ( !keepHidden && data[i].hidden ){
                    continue;
                }
                if ( !data[i].model ){
                    data[i].model = spxapi.resources.add( data[i] ); 
                }
                
                if ( data[i].type !== 'apps' ){
                    var kw = data[i].model.vertical()? "vertical" : "horizontal";                     
                    if ( data[i].keywords ) {
                        data[i].keywords.push( kw );
                    } else {
                        data[i].keywords = [ kw ];
                    }
                }
                addKeywords( data[i].keywords );
                
                addName( data[i].name );
                keptData.push( data[i] );                
            }
            if ( mainModel.table() ) {
                mainModel.table()
                         .rows.add( keptData )
                         .draw();
            } else {
                tableData = tableData.concat( keptData );                
            }
        } else {            
            if ( !keepAllApps && data.type === 'apps' ) {
                //console.log( data );
            }
            if ( data.hidden || !data.model || ( !keepAllApps && data.type === 'apps' && data.uri === null ) ) {
                // skip this data
            } else {
                if ( data.type !== 'apps' && data.type !== 'builtin' ){
                    var kw = data.model.vertical()? "vertical" : "horizontal";
                    if ( data.keywords ) {
                        data.keywords.push( kw );
                    } else {
                        data.keywords = [ kw ];
                    }
                }
                addKeywords( data.keywords );
                
                addName( data.name );
                if ( mainModel.table() ) {
                        mainModel.table()
                                 .row.add( data )
                                 .draw();
                } else {
                    tableData.push( data );
                }
            }
        }         
    };
    mainModel.prepareInfo = function( row, td, cellData, rowData ){
        var type = rowData.type;
        if ( type === 'apps' || type == 'builtin'){
            return;
        }
        if ( type === 'media' ){
            type = rowData.mimeType.substr(0, rowData.mimeType.indexOf('/') );
        }
        var actions = spxapi.ui.iconAction( { 
            type: type,
            tooltip: true
        } );
        $(td).html(actions);        
    };
    // load the data
    var tableData = [];
    
    function loadResource( name ){
        if ( spxapi.ui.resourceLoadingInfo.toLoad === 0 ){
            spxapi.ui.resourceLoadingInfo.start();
        }
        spxapi.ui.resourceLoadingInfo.toLoad++;        
        //alert( "starting "+name+": "+spxapi.ui.resourceLoadingInfo.loaded+"/"+spxapi.ui.resourceLoadingInfo.toLoad);
        spxapi[name].list().done( function( data ) {         
                        
            if ( data.length > 0 ) {
                mainModel.types.push( data[0].type );
                if ( data[0].type == args.type ){
                    mainModel.typeSearch( args.type );
                }
            }            
            mainModel.add( data );
            
            for( var i=0; i<data.length; i++ ){
                if ( !data[i].hidden ){
                    nbItemsLoaded++;
                }
            }
            
        }).always(function( data ) {
            //alert( "finished: "+spxapi.ui.resourceLoadingInfo.loaded+"/"+spxapi.ui.resourceLoadingInfo.toLoad);
            spxapi.ui.resourceLoadingInfo.finished();   
            if ( spxapi.ui.resourceLoadingInfo.toLoad === spxapi.ui.resourceLoadingInfo.loaded && nbItemsLoaded === 0 && args.noItemMsg ){
                spxapi.ui.message( args.noItemMsg );
            }
        }); 
    }
    var nbItemsLoaded = 0;
    for( var i=0; i<resources.length; i++ ){   
        if ( $.type(resources[i]) === "string" ) {
            loadResource( resources[i] );
        } else {
            function addResource( res ){
                setTimeout(function() {
                    mainModel.add( res );            
                }, 0 );
            };
            addResource( resources[i] );
        }
    }
    mainModel.datatableOptions = {
        data: tableData,       
        columns: mainModel.columns
    };
    if ( args.options ){
        $.extend( mainModel.datatableOptions, args.options );
    }    
    
    return mainModel;
};

var iconView = function( mainModel, args ) {
    mainModel = mainModel || {};
    args = args || { };  
    
    var viewId = mainModel.viewId || 'default';
    
    var initialSize = spxapi.storage.get("spx-"+viewId+"-iconviewsize") || args.size || 'medium';
    
    var itemCss = args.itemCss || "resource";
    var rows = args.rows || 1;
    var showType = args.showType !== false;
    
    var iconNode = false;
    
    mainModel.tableView = ko.observable( false );        
    mainModel.setSizes = function( newSizes, newRows ){
        sizes = newSizes;
        if ( newRows ){
            rows = newRows;
        }
        mainModel.setPageLength( initialSize );
        mainModel.table().draw();        
    };
    var sizes = $.extend({ large: "col-md-4 col-sm-6", medium: "col-lg-2 col-sm-3 col-xs-6", small: "col-lg-1 col-sm-2 col-xs-4" }, args.sizes);
    
    mainModel.length = function ( size ) {
        var length;
        var s = ( mainModel.vertical() && sizes.v && sizes.v[size] ) || sizes[size];
        var div = 1;
        if ( mainModel.vertical() ){
            div = 2;
        }
        var n = 12/parseInt(s.substr(7,2), 10 );
        if ( size === 'large' ){
            length = n * Math.ceil( rows / div );
        } else if ( size === 'small' ){
            length = n * Math.ceil( rows / div * 4 );
        } else {
            length = n * Math.ceil( rows / div * 2 );
        }         
        return length;
    };
    mainModel.datatableOptions.lengthMenu = [ mainModel.length( initialSize ) ];
    mainModel.pageLength = ko.observable( mainModel.length( initialSize ) );
    mainModel.iconSize = initialSize;
    mainModel.setPageLength = function ( val, setModel ) {
        console.log( val) ;
        if ( val === 'large' || val === 'small' || val === 'medium'){
            mainModel.iconSize = val;
            spxapi.storage.set("spx-"+viewId+"-iconviewsize", mainModel.iconSize);
            val = mainModel.length( val );
            setModel = true;
            mainModel.tableView(false);            
        }
        if ( val === 'list' ){            
            mainModel.tableView( true ); 
            if ( mainModel.tableView() ) { 
                val = 8;            
            } else { 
                val = mainModel.pageLength();
            }
        }
        if ( mainModel.table() ){
            mainModel.table().page.len( val ).draw();                    
        }       
        if ( setModel ){
            mainModel.pageLength( val );
        }
    };
    
    mainModel.datatableOptions.dom =
            "<'clearfix't<'icon-view row spx-gallery'>><'clearfix'<'pull-right spx-pages'p><'clearfix'>>";
        
    mainModel.datatableOptions.preDrawCallback = function( settings ) {
        // clear out the thumbs container
        if ( iconNode === false ){                
            iconNode = $('.icon-view', settings.nTableWrapper);
            iconNode.attr('data-bind', 'hidden: tableView');
            //ko.applyBindings(mainModel, iconNode[0]);            
        }
        iconNode.html(''); 
        return true;
    };
    
    
    
    var previousSelectTarget = null;
    mainModel.selection = ko.observable( );    
    var onClick;
    var onClickBase = args.onClick;
    if ( args.selectable ){
        onClickBase = mainModel.selection;
    }
    if ( onClickBase ) {
        onClick = function( data, event ){
            var target = $(event.target).parents('.spx-media-block');
            if ( previousSelectTarget ) {
               previousSelectTarget.removeClass('selected');
            }
            onClickBase( data );
            target.addClass('selected');
            previousSelectTarget = target;
        };
    }
    function getTtooltipName( data ) {
        var type = data.type;
        if ( type === 'media' ){
            type = data.mimeType.substr(0, data.mimeType.indexOf('/') );
        }
        if ( type === 'external' || type === 'apps' || type === 'builtin'){
            return data.name;
        } 
        var reg = /(['\\])/g;
        return spxapi.t(type.charAt(0).toUpperCase() + type.slice(1)) + ": " + data.name.replace(reg, "\\$1");
    }
    mainModel.datatableOptions.rowCallback = function( row, data ) {
        var api = this.api(),
            length = api.page.len(),
            size,
            src, 
            head = null;
        if ( mainModel.tableView() ){
            return;
        }
        size = ( mainModel.vertical() && sizes.v && sizes.v[mainModel.iconSize] ) || sizes[mainModel.iconSize] ; 
        src = data.model.snapshots[mainModel.iconSize].src();

        if ( args.draggable ) {
            var main = $("<div data-bind='draggable: { data: $root, template: false }'/>");
            main.addClass( itemCss );            
        } else if ( onClick ){
            var main = $("<div data-bind='click: select'/>"); 
            data.select = onClick;            
        }else {
            var main = $("<div/>");                    
        }
        main.addClass( "type-" + data.model.type() );
        main.addClass( size );  
        
        var panel = $("<div />")
                    .addClass("block-flat widget-block spx-media-block")
                    .appendTo( main );
        if ( data.type =='apps' && data.uri ){
            panel.addClass("apps-config");
        }
        var showTolltip = true;
        if ( mainModel.iconSize === 'large' ) {
            head = $("<div/>")
                .addClass("header")
                .appendTo( panel );
            var txt = data.name;
            var txt2 = data.name;
            if ( txt.length > 20 ){
                txt = txt.substr(0,17) + "...";
            } else {
                showTolltip = false;
            }
            if ( txt2.length > 36 ){
                txt2 = txt2.substr(0,33) + "...";
            }
            $("<span/>")
                .addClass("visible-sm-inline visible-md-inline")
                .text( txt )
                .appendTo( head );  
            $("<span/>")
                .addClass("hidden-sm hidden-md")
                .text( txt2 )
                .appendTo( head );
        }
        
        var body = $("<div/>")
                    .addClass("content")
                    .appendTo( panel );
        if ( args.selectable && ( !mainModel.selection() || mainModel.selection() === data ) ){            
            onClick( data, { target: body[0] } );            
        }
        var preview = $("<div/>")
                    .addClass("spx-preview-fixed")
                    .appendTo( body );
        $("<div/>")
                    .addClass("spx-preview-fixed-item")
                    .addClass("spx-preview-background")
                    .css("background-image","url("+src+")")
                    .appendTo( preview );
        if ( data.model.vertical() ) {
            preview.addClass("vertical");
            body.addClass("vertical");
        }
        /*
        $("<img alt='"+data.name+"' src='"+src+"'/>")
                    .addClass("spx-preview")
                    .appendTo( sub );
                    */
        if ( showTolltip ) {
            
            panel.attr("data-bind", "tooltip: '" + getTtooltipName(data) +"'" );    
        }
        if ( mainModel.iconSize !== 'large' ) {
            // overlay icons on the top
            head = $("<div/>")
                .addClass("over")
                .appendTo( panel );
        } 
        // open on click
        var model = mainModel.prepareModel( $(row), body[0], data.id, data );                
        
        if ( mainModel.open && !onClick && ( data.model.type() != 'apps' || data.uri)){            
            data.open = function() { mainModel.open( model ); };
            body.attr("data-bind", "click: open" );   
        }
        
        // TODO: something for the small icon view
        main.appendTo( iconNode );
        
        if ( showType && mainModel.prepareInfo) {
            var actions = $("<span />")
                            .addClass("spx-media-info")
                            .appendTo( panel );
            mainModel.prepareInfo( $(row), actions[0], data.id, data );
        }
        if ( head && mainModel.canSelect && mainModel.canSelect(data) ) {            
            var div = $('<div/>').addClass("pull-right").appendTo( head );
            $("<input type='checkbox' data-bind='iCheck: checked'/>")
                .addClass("form-control input-sm btn-sm spx-visible-check")                
                .appendTo( div );     
            data.checked = model.checked;
        }
        ko.applyBindings(data, main[0]);

    };
};




