<?php

yii::import(
    'application.modules.controlcenter.controllers.actions.SystemAction'
);
yii::import(
    'application.modules.controlcenter.controllers.actions.DisplayAction'
);
yii::import('application.modules.api.controllers.ApiController');
class MainController extends Controller
{
    public $defaultAction = 'index';
    public function accessRules()
    {
        $rules = array(
            array(
                'allow',
                'actions' => array('firmware'),
                'expression' => "Updater::isUpdateInProgress()",
            ),
        );
        return array_merge($rules, parent::accessRules());
    }
    public function actionIndex($arya = null)
    {
        if (!Yii::app()->branding->hasRight('CreateSchedule') 
            || (new ARYAMode())->getEnabled()) {
            $url = Yii::app()->user->checkAccess('viewLogs') 
                || Yii::app()->user->checkAccess('useControlCenter') ?
                "/controlcenter/main/index" : "/controlcenter/user/profile";
            return $this->redirect($url);
        }
        $screenInfo = new ScreenInfo();
        $screenInfo->load();
        $playerConfig = new PlayerConfig();

        $options = array(
            'screenInfo' => $screenInfo,
            'playerConfig' => $playerConfig,
        );
        $this->render('index', $options);
    }

    public function actionList()
    {
        $this->render('list');
    }

    public function actionApps()
    {
        $this->render('apps');
    }
    public function actionFirmware($handle = false, $source = false)
    {
        $this->render('firmware', array(
            'handle' => $handle,
            'source' => $source
        ));
    }
    public function actionCheckAlive()
    {
        if (!Yii::app()->request->isAjaxRequest) {
            throw new CHttpException(403, "Direct access not allowed");
        }

        echo json_encode(array(
            'success' => true,
            'boot-id' => Tools::getBootID(),
        ));
    }

    public function actionGo()
	{
        $url = Yii::app()->getRequest()->getRequestUri();
        if (($url = preg_replace('#^/main/go/?#', '/uiauth/', $url)) === null) {
            throw new CHttpException(400, "Failed to process requested URL");
        }
        $this->redirect($url);
    }
}
